/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.partition.impl;

import com.hazelcast.nio.Address;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.partition.ReplicaErrorLogger;
import com.hazelcast.partition.impl.CheckReplicaVersion;
import com.hazelcast.partition.impl.InternalPartitionImpl;
import com.hazelcast.partition.impl.InternalPartitionServiceImpl;
import com.hazelcast.spi.Callback;
import com.hazelcast.spi.NodeEngine;
import com.hazelcast.spi.Operation;
import com.hazelcast.spi.OperationService;
import com.hazelcast.spi.PartitionAwareOperation;
import java.io.IOException;

final class SyncReplicaVersion
extends Operation
implements PartitionAwareOperation {
    public static final int OPERATION_TRY_COUNT = 10;
    public static final int OPERATION_TRY_PAUSE_MILLIS = 250;
    private final int syncReplicaIndex;
    private final Callback<Object> callback;
    private final boolean sync;

    public SyncReplicaVersion(int syncReplicaIndex, Callback<Object> callback) {
        if (syncReplicaIndex < 1 || syncReplicaIndex > 6) {
            throw new IllegalArgumentException("Replica index should be in range [1-6]");
        }
        this.syncReplicaIndex = syncReplicaIndex;
        this.callback = callback;
        this.sync = callback != null;
    }

    @Override
    public void beforeRun() throws Exception {
    }

    @Override
    public void run() throws Exception {
        InternalPartitionServiceImpl partitionService = (InternalPartitionServiceImpl)this.getService();
        int partitionId = this.getPartitionId();
        int replicaIndex = this.syncReplicaIndex;
        InternalPartitionImpl partition = partitionService.getPartition(partitionId);
        Address target = partition.getReplicaAddress(replicaIndex);
        if (target == null) {
            this.notifyCallback(false);
            return;
        }
        this.invokeCheckReplicaVersion(partitionId, replicaIndex, target);
    }

    private void invokeCheckReplicaVersion(int partitionId, int replicaIndex, Address target) {
        InternalPartitionServiceImpl partitionService = (InternalPartitionServiceImpl)this.getService();
        long[] currentVersions = partitionService.getPartitionReplicaVersions(partitionId);
        long currentReplicaVersion = currentVersions[replicaIndex - 1];
        if (currentReplicaVersion > 0L) {
            CheckReplicaVersion op = this.createCheckReplicaVersion(partitionId, replicaIndex, currentReplicaVersion);
            NodeEngine nodeEngine = this.getNodeEngine();
            OperationService operationService = nodeEngine.getOperationService();
            if (this.sync) {
                operationService.createInvocationBuilder("hz:core:partitionService", (Operation)op, target).setCallback(this.callback).setTryCount(10).setTryPauseMillis(250L).build().invoke();
            } else {
                operationService.send((Operation)op, target);
            }
        } else {
            this.notifyCallback(true);
        }
    }

    private void notifyCallback(boolean result) {
        if (this.callback != null) {
            this.callback.notify(result);
        }
    }

    private CheckReplicaVersion createCheckReplicaVersion(int partitionId, int replicaIndex, long currentVersion) {
        CheckReplicaVersion op = new CheckReplicaVersion(currentVersion, this.sync);
        op.setPartitionId(partitionId).setReplicaIndex(replicaIndex).setServiceName("hz:core:partitionService");
        return op;
    }

    @Override
    public void afterRun() throws Exception {
    }

    @Override
    public boolean returnsResponse() {
        return false;
    }

    @Override
    public Object getResponse() {
        return null;
    }

    @Override
    public boolean validatesTarget() {
        return false;
    }

    @Override
    public String getServiceName() {
        return "hz:core:partitionService";
    }

    @Override
    public void logError(Throwable e) {
        ReplicaErrorLogger.log(e, this.getLogger());
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("SyncReplicaVersion{");
        sb.append("partitionId=").append(this.getPartitionId());
        sb.append(", replicaIndex=").append(this.syncReplicaIndex);
        sb.append('}');
        return sb.toString();
    }
}

