/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.partition.impl;

import com.hazelcast.core.HazelcastException;
import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.BufferObjectDataInput;
import com.hazelcast.nio.IOUtil;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.SerializationService;
import com.hazelcast.partition.MigrationEndpoint;
import com.hazelcast.partition.MigrationInfo;
import com.hazelcast.partition.impl.BaseMigrationOperation;
import com.hazelcast.partition.impl.InternalPartitionServiceImpl;
import com.hazelcast.spi.MigrationAwareService;
import com.hazelcast.spi.Operation;
import com.hazelcast.spi.OperationAccessor;
import com.hazelcast.spi.PartitionMigrationEvent;
import com.hazelcast.spi.ResponseHandler;
import com.hazelcast.spi.exception.RetryableHazelcastException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.logging.Level;

public final class MigrationOperation
extends BaseMigrationOperation {
    private static final ResponseHandler ERROR_RESPONSE_HANDLER = new ResponseHandler(){

        @Override
        public void sendResponse(Object obj) {
            throw new HazelcastException("Migration operations can not send response!");
        }

        @Override
        public boolean isLocal() {
            return true;
        }
    };
    private long[] replicaVersions;
    private Collection<Operation> tasks;
    private byte[] taskData;
    private boolean compressed;

    public MigrationOperation() {
    }

    public MigrationOperation(MigrationInfo migrationInfo, long[] replicaVersions, byte[] taskData, boolean compressed) {
        super(migrationInfo);
        this.replicaVersions = replicaVersions;
        this.taskData = taskData;
        this.compressed = compressed;
    }

    @Override
    public Object getResponse() {
        return this.success;
    }

    @Override
    public void run() throws Exception {
        this.assertMigrationInitiatorIsMaster();
        try {
            this.doRun();
        }
        catch (Throwable t) {
            this.logMigrationFailure(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doRun() throws Exception {
        if (this.startMigration()) {
            try {
                this.migrate();
            }
            finally {
                this.afterMigrate();
            }
        } else {
            this.logMigrationCancelled();
        }
    }

    private void assertMigrationInitiatorIsMaster() {
        Address masterAddress = this.getNodeEngine().getMasterAddress();
        if (!masterAddress.equals(this.migrationInfo.getMaster())) {
            throw new RetryableHazelcastException("Migration initiator is not master node! => " + this.toString());
        }
    }

    private boolean startMigration() {
        return this.migrationInfo.startProcessing();
    }

    private void logMigrationCancelled() {
        this.getLogger().warning("Migration is cancelled -> " + this.migrationInfo);
    }

    private void afterMigrate() {
        if (this.success) {
            InternalPartitionServiceImpl partitionService = (InternalPartitionServiceImpl)this.getService();
            partitionService.setPartitionReplicaVersions(this.migrationInfo.getPartitionId(), this.replicaVersions);
        }
        this.migrationInfo.doneProcessing();
    }

    private void logMigrationFailure(Throwable e) {
        ILogger logger;
        Level level = Level.WARNING;
        if (e instanceof IllegalStateException) {
            level = Level.FINEST;
        }
        if ((logger = this.getLogger()).isLoggable(level)) {
            logger.log(level, e.getMessage(), e);
        }
    }

    private void migrate() throws Exception {
        this.buildMigrationTasks();
        this.addActiveMigration();
        for (Operation op : this.tasks) {
            try {
                this.runMigrationTask(op);
            }
            catch (Throwable e) {
                this.getLogger().severe("An exception occurred while executing migration operation " + op, e);
                return;
            }
        }
        this.success = true;
    }

    private void addActiveMigration() {
        InternalPartitionServiceImpl partitionService = (InternalPartitionServiceImpl)this.getService();
        partitionService.addActiveMigration(this.migrationInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildMigrationTasks() throws IOException {
        SerializationService serializationService = this.getNodeEngine().getSerializationService();
        BufferObjectDataInput in = serializationService.createObjectDataInput(this.toData());
        try {
            int size = in.readInt();
            this.tasks = new ArrayList<Operation>(size);
            for (int i = 0; i < size; ++i) {
                Operation task = (Operation)serializationService.readObject(in);
                this.tasks.add(task);
            }
        }
        finally {
            IOUtil.closeResource(in);
        }
    }

    private byte[] toData() throws IOException {
        if (this.compressed) {
            return IOUtil.decompress(this.taskData);
        }
        return this.taskData;
    }

    private void runMigrationTask(Operation op) throws Exception {
        op.setNodeEngine(this.getNodeEngine()).setPartitionId(this.getPartitionId()).setReplicaIndex(this.getReplicaIndex());
        op.setResponseHandler(ERROR_RESPONSE_HANDLER);
        OperationAccessor.setCallerAddress(op, this.migrationInfo.getSource());
        MigrationAwareService service = (MigrationAwareService)op.getService();
        PartitionMigrationEvent event = new PartitionMigrationEvent(MigrationEndpoint.DESTINATION, this.migrationInfo.getPartitionId());
        service.beforeMigration(event);
        op.beforeRun();
        op.run();
        op.afterRun();
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeBoolean(this.compressed);
        out.writeInt(this.taskData.length);
        out.write(this.taskData);
        out.writeLongArray(this.replicaVersions);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.compressed = in.readBoolean();
        int size = in.readInt();
        this.taskData = new byte[size];
        in.readFully(this.taskData);
        this.replicaVersions = in.readLongArray();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getName());
        sb.append("{partitionId=").append(this.getPartitionId());
        sb.append(", migration=").append(this.migrationInfo);
        sb.append(", compressed=").append(this.compressed);
        sb.append('}');
        return sb.toString();
    }
}

