/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.management.request;

import com.hazelcast.cluster.ClusterServiceImpl;
import com.hazelcast.concurrent.lock.LockResource;
import com.hazelcast.concurrent.lock.LockService;
import com.hazelcast.instance.HazelcastInstanceImpl;
import com.hazelcast.management.ClusterRuntimeState;
import com.hazelcast.management.ManagementCenterService;
import com.hazelcast.management.request.ConsoleRequest;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.Connection;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.partition.impl.InternalPartitionServiceImpl;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class RuntimeStateRequest
implements ConsoleRequest {
    private static final long LOCK_TIME_THRESHOLD = TimeUnit.SECONDS.toMillis(300L);

    @Override
    public int getType() {
        return 1;
    }

    private Collection<LockResource> collectLockState(HazelcastInstanceImpl instance) {
        LockService lockService = (LockService)instance.node.nodeEngine.getService("hz:impl:lockService");
        return lockService.getAllLocks();
    }

    @Override
    public void writeResponse(ManagementCenterService mcs, ObjectDataOutput dos) throws Exception {
        HazelcastInstanceImpl instance = mcs.getHazelcastInstance();
        ClusterServiceImpl cluster = instance.node.getClusterService();
        InternalPartitionServiceImpl partitionService = instance.node.partitionService;
        Collection<LockResource> lockedRecords = this.collectLockState(instance);
        Map<Address, Connection> connectionMap = instance.node.connectionManager.getReadonlyConnectionMap();
        ClusterRuntimeState clusterRuntimeState = new ClusterRuntimeState(cluster.getMembers(), partitionService.getPartitions(), partitionService.getActiveMigrations(), connectionMap, lockedRecords);
        clusterRuntimeState.writeData(dos);
    }

    @Override
    public Object readResponse(ObjectDataInput in) throws IOException {
        ClusterRuntimeState clusterRuntimeState = new ClusterRuntimeState();
        clusterRuntimeState.readData(in);
        return clusterRuntimeState;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
    }
}

