/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client;

import com.hazelcast.client.DistributedObjectInfo;
import com.hazelcast.client.GetDistributedObjectsRequest;
import com.hazelcast.client.HazelcastClientManagedContext;
import com.hazelcast.client.HazelcastClientProxy;
import com.hazelcast.client.LifecycleServiceImpl;
import com.hazelcast.client.LoadBalancer;
import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.config.XmlClientConfigBuilder;
import com.hazelcast.client.connection.ClientConnectionManager;
import com.hazelcast.client.connection.DummyClientConnectionManager;
import com.hazelcast.client.connection.SmartClientConnectionManager;
import com.hazelcast.client.proxy.ClientClusterProxy;
import com.hazelcast.client.proxy.PartitionServiceProxy;
import com.hazelcast.client.spi.ClientClusterService;
import com.hazelcast.client.spi.ClientExecutionService;
import com.hazelcast.client.spi.ClientInvocationService;
import com.hazelcast.client.spi.ClientPartitionService;
import com.hazelcast.client.spi.ProxyManager;
import com.hazelcast.client.spi.impl.ClientClusterServiceImpl;
import com.hazelcast.client.spi.impl.ClientExecutionServiceImpl;
import com.hazelcast.client.spi.impl.ClientInvocationServiceImpl;
import com.hazelcast.client.spi.impl.ClientPartitionServiceImpl;
import com.hazelcast.client.txn.ClientTransactionManager;
import com.hazelcast.client.util.RoundRobinLB;
import com.hazelcast.concurrent.lock.proxy.LockProxy;
import com.hazelcast.config.Config;
import com.hazelcast.config.GroupConfig;
import com.hazelcast.core.ClientService;
import com.hazelcast.core.Cluster;
import com.hazelcast.core.DistributedObject;
import com.hazelcast.core.DistributedObjectListener;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IAtomicLong;
import com.hazelcast.core.ICountDownLatch;
import com.hazelcast.core.IExecutorService;
import com.hazelcast.core.IList;
import com.hazelcast.core.ILock;
import com.hazelcast.core.IMap;
import com.hazelcast.core.IQueue;
import com.hazelcast.core.ISemaphore;
import com.hazelcast.core.ISet;
import com.hazelcast.core.ITopic;
import com.hazelcast.core.IdGenerator;
import com.hazelcast.core.LifecycleService;
import com.hazelcast.core.MultiMap;
import com.hazelcast.core.PartitionService;
import com.hazelcast.core.PartitioningStrategy;
import com.hazelcast.logging.LoggingService;
import com.hazelcast.nio.ClassLoaderUtil;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.SerializationService;
import com.hazelcast.nio.serialization.SerializationServiceBuilder;
import com.hazelcast.partition.strategy.DefaultPartitioningStrategy;
import com.hazelcast.spi.impl.SerializableCollection;
import com.hazelcast.transaction.TransactionContext;
import com.hazelcast.transaction.TransactionException;
import com.hazelcast.transaction.TransactionOptions;
import com.hazelcast.transaction.TransactionalTask;
import com.hazelcast.util.ExceptionUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;

public final class HazelcastClient
implements HazelcastInstance {
    private static final AtomicInteger CLIENT_ID = new AtomicInteger();
    private static final ConcurrentMap<Integer, HazelcastClientProxy> CLIENTS = new ConcurrentHashMap<Integer, HazelcastClientProxy>(5);
    private final int id = CLIENT_ID.getAndIncrement();
    private final String instanceName;
    private final ClientConfig config;
    private final ThreadGroup threadGroup;
    private final LifecycleServiceImpl lifecycleService;
    private final SerializationService serializationService;
    private final ClientConnectionManager connectionManager;
    private final ClientClusterServiceImpl clusterService;
    private final ClientPartitionServiceImpl partitionService;
    private final ClientInvocationServiceImpl invocationService;
    private final ClientExecutionServiceImpl executionService;
    private final ClientTransactionManager transactionManager;
    private final ProxyManager proxyManager;
    private final ConcurrentMap<String, Object> userContext;

    private HazelcastClient(ClientConfig config) {
        this.config = config;
        GroupConfig groupConfig = config.getGroupConfig();
        this.instanceName = "hz.client_" + this.id + (groupConfig != null ? "_" + groupConfig.getName() : "");
        this.threadGroup = new ThreadGroup(this.instanceName);
        this.lifecycleService = new LifecycleServiceImpl(this);
        try {
            String partitioningStrategyClassName = System.getProperty("hazelcast.partitioning.strategy.class");
            PartitioningStrategy partitioningStrategy = partitioningStrategyClassName != null && partitioningStrategyClassName.length() > 0 ? (PartitioningStrategy)ClassLoaderUtil.newInstance(config.getClassLoader(), partitioningStrategyClassName) : new DefaultPartitioningStrategy();
            this.serializationService = new SerializationServiceBuilder().setManagedContext(new HazelcastClientManagedContext(this, config.getManagedContext())).setClassLoader(config.getClassLoader()).setConfig(config.getSerializationConfig()).setPartitioningStrategy(partitioningStrategy).build();
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow(e);
        }
        this.proxyManager = new ProxyManager(this);
        this.transactionManager = new ClientTransactionManager(this);
        this.executionService = new ClientExecutionServiceImpl(this.instanceName, this.threadGroup, Thread.currentThread().getContextClassLoader(), config.getExecutorPoolSize());
        this.clusterService = new ClientClusterServiceImpl(this);
        LoadBalancer loadBalancer = config.getLoadBalancer();
        if (loadBalancer == null) {
            loadBalancer = new RoundRobinLB();
        }
        this.connectionManager = config.isSmartRouting() ? new SmartClientConnectionManager(this, this.clusterService.getAuthenticator(), loadBalancer) : new DummyClientConnectionManager(this, this.clusterService.getAuthenticator(), loadBalancer);
        this.invocationService = new ClientInvocationServiceImpl(this);
        this.userContext = new ConcurrentHashMap<String, Object>();
        loadBalancer.init(this.getCluster(), config);
        this.proxyManager.init(config);
        this.partitionService = new ClientPartitionServiceImpl(this);
    }

    public static HazelcastInstance newHazelcastClient() {
        return HazelcastClient.newHazelcastClient(new XmlClientConfigBuilder().build());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HazelcastInstance newHazelcastClient(ClientConfig config) {
        HazelcastClientProxy proxy;
        if (config == null) {
            config = new XmlClientConfigBuilder().build();
        }
        ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(HazelcastClient.class.getClassLoader());
            HazelcastClient client = new HazelcastClient(config);
            client.start();
            proxy = new HazelcastClientProxy(client);
            CLIENTS.put(client.id, proxy);
        }
        finally {
            Thread.currentThread().setContextClassLoader(tccl);
        }
        return proxy;
    }

    public static Collection<HazelcastInstance> getAllHazelcastClients() {
        return Collections.unmodifiableCollection(CLIENTS.values());
    }

    public static void shutdownAll() {
        for (HazelcastClientProxy proxy : CLIENTS.values()) {
            try {
                proxy.client.getLifecycleService().shutdown();
            }
            catch (Exception exception) {
                // empty catch block
            }
            proxy.client = null;
        }
        CLIENTS.clear();
    }

    private void start() {
        this.lifecycleService.setStarted();
        try {
            this.clusterService.start();
        }
        catch (IllegalStateException e) {
            this.lifecycleService.shutdown();
            throw e;
        }
        this.partitionService.start();
    }

    @Override
    public Config getConfig() {
        throw new UnsupportedOperationException("Client cannot access cluster config!");
    }

    @Override
    public String getName() {
        return this.instanceName;
    }

    @Override
    public <E> IQueue<E> getQueue(String name) {
        return (IQueue)this.getDistributedObject("hz:impl:queueService", name);
    }

    @Override
    public <E> ITopic<E> getTopic(String name) {
        return (ITopic)this.getDistributedObject("hz:impl:topicService", name);
    }

    @Override
    public <E> ISet<E> getSet(String name) {
        return (ISet)this.getDistributedObject("hz:impl:setService", name);
    }

    @Override
    public <E> IList<E> getList(String name) {
        return (IList)this.getDistributedObject("hz:impl:listService", name);
    }

    @Override
    public <K, V> IMap<K, V> getMap(String name) {
        return (IMap)this.getDistributedObject("hz:impl:mapService", name);
    }

    @Override
    public <K, V> MultiMap<K, V> getMultiMap(String name) {
        return (MultiMap)this.getDistributedObject("hz:impl:multiMapService", name);
    }

    @Override
    public ILock getLock(String key) {
        return (ILock)this.getDistributedObject("hz:impl:lockService", key);
    }

    @Override
    @Deprecated
    public ILock getLock(Object key) {
        return (ILock)this.getDistributedObject("hz:impl:lockService", LockProxy.convertToStringKey(key, this.serializationService));
    }

    @Override
    public Cluster getCluster() {
        return new ClientClusterProxy(this.clusterService);
    }

    @Override
    public IExecutorService getExecutorService(String name) {
        return (IExecutorService)this.getDistributedObject("hz:impl:executorService", name);
    }

    @Override
    public <T> T executeTransaction(TransactionalTask<T> task) throws TransactionException {
        return this.transactionManager.executeTransaction(task);
    }

    @Override
    public <T> T executeTransaction(TransactionOptions options, TransactionalTask<T> task) throws TransactionException {
        return this.transactionManager.executeTransaction(options, task);
    }

    @Override
    public TransactionContext newTransactionContext() {
        return this.transactionManager.newTransactionContext();
    }

    @Override
    public TransactionContext newTransactionContext(TransactionOptions options) {
        return this.transactionManager.newTransactionContext(options);
    }

    @Override
    public IdGenerator getIdGenerator(String name) {
        return (IdGenerator)this.getDistributedObject("hz:impl:idGeneratorService", name);
    }

    @Override
    public IAtomicLong getAtomicLong(String name) {
        return (IAtomicLong)this.getDistributedObject("hz:impl:atomicLongService", name);
    }

    @Override
    public ICountDownLatch getCountDownLatch(String name) {
        return (ICountDownLatch)this.getDistributedObject("hz:impl:countDownLatchService", name);
    }

    @Override
    public ISemaphore getSemaphore(String name) {
        return (ISemaphore)this.getDistributedObject("hz:impl:semaphoreService", name);
    }

    @Override
    public Collection<DistributedObject> getDistributedObjects() {
        try {
            GetDistributedObjectsRequest request = new GetDistributedObjectsRequest();
            SerializableCollection serializableCollection = (SerializableCollection)this.invocationService.invokeOnRandomTarget(request);
            for (Data data : serializableCollection) {
                DistributedObjectInfo o = (DistributedObjectInfo)this.serializationService.toObject(data);
                this.getDistributedObject(o.getServiceName(), o.getName());
            }
            return this.proxyManager.getDistributedObjects();
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow(e);
        }
    }

    @Override
    public String addDistributedObjectListener(DistributedObjectListener distributedObjectListener) {
        return this.proxyManager.addDistributedObjectListener(distributedObjectListener);
    }

    @Override
    public boolean removeDistributedObjectListener(String registrationId) {
        return this.proxyManager.removeDistributedObjectListener(registrationId);
    }

    @Override
    public PartitionService getPartitionService() {
        return new PartitionServiceProxy(this.partitionService);
    }

    @Override
    public ClientService getClientService() {
        throw new UnsupportedOperationException();
    }

    @Override
    public LoggingService getLoggingService() {
        throw new UnsupportedOperationException();
    }

    @Override
    public LifecycleService getLifecycleService() {
        return this.lifecycleService;
    }

    @Override
    @Deprecated
    public <T extends DistributedObject> T getDistributedObject(String serviceName, Object id) {
        if (id instanceof String) {
            return (T)this.proxyManager.getProxy(serviceName, (String)id);
        }
        throw new IllegalArgumentException("'id' must be type of String!");
    }

    @Override
    public <T extends DistributedObject> T getDistributedObject(String serviceName, String name) {
        return (T)this.proxyManager.getProxy(serviceName, name);
    }

    @Override
    public ConcurrentMap<String, Object> getUserContext() {
        return this.userContext;
    }

    public ClientConfig getClientConfig() {
        return this.config;
    }

    public SerializationService getSerializationService() {
        return this.serializationService;
    }

    public ClientConnectionManager getConnectionManager() {
        return this.connectionManager;
    }

    public ClientClusterService getClientClusterService() {
        return this.clusterService;
    }

    public ClientExecutionService getClientExecutionService() {
        return this.executionService;
    }

    public ClientPartitionService getClientPartitionService() {
        return this.partitionService;
    }

    public ClientInvocationService getInvocationService() {
        return this.invocationService;
    }

    public ThreadGroup getThreadGroup() {
        return this.threadGroup;
    }

    @Override
    public void shutdown() {
        this.getLifecycleService().shutdown();
    }

    void doShutdown() {
        CLIENTS.remove(this.id);
        this.executionService.shutdown();
        this.partitionService.stop();
        this.clusterService.stop();
        this.connectionManager.shutdown();
        this.proxyManager.destroy();
    }
}

