/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.operation;

import com.hazelcast.core.HazelcastInstanceAware;
import com.hazelcast.map.EntryBackupProcessor;
import com.hazelcast.map.operation.KeyBasedMapOperation;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.spi.BackupOperation;
import java.io.IOException;
import java.util.AbstractMap;
import java.util.Map;

public class EntryBackupOperation
extends KeyBasedMapOperation
implements BackupOperation {
    private EntryBackupProcessor entryProcessor;

    public EntryBackupOperation(String name, Data dataKey, EntryBackupProcessor entryProcessor) {
        super(name, dataKey);
        this.entryProcessor = entryProcessor;
    }

    public EntryBackupOperation() {
    }

    @Override
    public void innerBeforeRun() {
        if (this.entryProcessor instanceof HazelcastInstanceAware) {
            ((HazelcastInstanceAware)((Object)this.entryProcessor)).setHazelcastInstance(this.getNodeEngine().getHazelcastInstance());
        }
    }

    @Override
    public void run() {
        Map.Entry<Data, Object> mapEntry = this.recordStore.getMapEntryForBackup(this.dataKey);
        if (mapEntry.getValue() != null) {
            AbstractMap.SimpleEntry<Object, Object> entry = new AbstractMap.SimpleEntry<Object, Object>(this.mapService.toObject(this.dataKey), this.mapService.toObject(mapEntry.getValue()));
            this.entryProcessor.processBackup(entry);
            this.recordStore.put(new AbstractMap.SimpleImmutableEntry<Data, Object>(this.dataKey, entry.getValue()));
        }
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.entryProcessor = (EntryBackupProcessor)in.readObject();
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeObject(this.entryProcessor);
    }

    @Override
    public Object getResponse() {
        return true;
    }

    public String toString() {
        return "EntryBackupOperation{}";
    }
}

