/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.txn.proxy;

import com.hazelcast.client.ClientDestroyRequest;
import com.hazelcast.client.spi.impl.ClientClusterServiceImpl;
import com.hazelcast.client.txn.TransactionContextProxy;
import com.hazelcast.core.HazelcastException;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.partition.strategy.StringPartitioningStrategy;
import com.hazelcast.transaction.TransactionalObject;
import com.hazelcast.util.ExceptionUtil;
import java.io.IOException;

abstract class ClientTxnProxy
implements TransactionalObject {
    final String objectName;
    final TransactionContextProxy proxy;

    ClientTxnProxy(String objectName, TransactionContextProxy proxy) {
        this.objectName = objectName;
        this.proxy = proxy;
    }

    final <T> T invoke(Object request) {
        ClientClusterServiceImpl clusterService = (ClientClusterServiceImpl)this.proxy.getClient().getClientClusterService();
        try {
            return clusterService.sendAndReceiveFixedConnection(this.proxy.getConnection(), request);
        }
        catch (IOException e) {
            throw ExceptionUtil.rethrow(new HazelcastException(e));
        }
    }

    abstract void onDestroy();

    @Override
    public final void destroy() {
        this.onDestroy();
        ClientDestroyRequest request = new ClientDestroyRequest(this.objectName, this.getServiceName());
        this.invoke(request);
    }

    @Override
    public Object getId() {
        return this.objectName;
    }

    @Override
    public String getPartitionKey() {
        return StringPartitioningStrategy.getPartitionKey(this.getName());
    }

    Data toData(Object obj) {
        return this.proxy.getClient().getSerializationService().toData(obj);
    }

    Object toObject(Data data) {
        return this.proxy.getClient().getSerializationService().toObject(data);
    }
}

