/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.partition;

import com.hazelcast.core.HazelcastException;
import com.hazelcast.core.MemberLeftException;
import com.hazelcast.instance.MemberImpl;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.BufferObjectDataOutput;
import com.hazelcast.nio.IOUtil;
import com.hazelcast.nio.serialization.SerializationService;
import com.hazelcast.partition.BaseMigrationOperation;
import com.hazelcast.partition.MigrationEndpoint;
import com.hazelcast.partition.MigrationInfo;
import com.hazelcast.partition.MigrationOperation;
import com.hazelcast.partition.PartitionImpl;
import com.hazelcast.partition.PartitionServiceImpl;
import com.hazelcast.spi.ExceptionAction;
import com.hazelcast.spi.Invocation;
import com.hazelcast.spi.MigrationAwareService;
import com.hazelcast.spi.NodeEngine;
import com.hazelcast.spi.Operation;
import com.hazelcast.spi.PartitionMigrationEvent;
import com.hazelcast.spi.PartitionReplicationEvent;
import com.hazelcast.spi.ResponseHandler;
import com.hazelcast.spi.ServiceInfo;
import com.hazelcast.spi.exception.RetryableHazelcastException;
import com.hazelcast.spi.exception.TargetNotMemberException;
import com.hazelcast.spi.impl.NodeEngineImpl;
import java.util.Collection;
import java.util.LinkedList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;

public final class MigrationRequestOperation
extends BaseMigrationOperation {
    private transient boolean returnResponse = true;

    public MigrationRequestOperation() {
    }

    public MigrationRequestOperation(MigrationInfo migrationInfo) {
        super(migrationInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        final NodeEngine nodeEngine = this.getNodeEngine();
        Address masterAddress = nodeEngine.getMasterAddress();
        if (!masterAddress.equals(this.migrationInfo.getMaster())) {
            throw new RetryableHazelcastException("Migration initiator is not master node! => " + this.toString());
        }
        if (!masterAddress.equals(this.getCallerAddress())) {
            throw new RetryableHazelcastException("Caller is not master node! => " + this.toString());
        }
        Address source = this.migrationInfo.getSource();
        final Address destination = this.migrationInfo.getDestination();
        MemberImpl target = nodeEngine.getClusterService().getMember(destination);
        if (target == null) {
            throw new TargetNotMemberException("Destination of migration could not be found! => " + this.toString());
        }
        if (destination.equals(source)) {
            this.getLogger().warning("Source and destination addresses are the same! => " + this.toString());
            this.success = false;
            return;
        }
        if (source == null || !source.equals(nodeEngine.getThisAddress())) {
            throw new RetryableHazelcastException("Source of migration is not this node! => " + this.toString());
        }
        PartitionServiceImpl partitionService = (PartitionServiceImpl)this.getService();
        PartitionImpl partition = partitionService.getPartition(this.migrationInfo.getPartitionId());
        Address owner = partition.getOwner();
        if (owner == null) {
            throw new RetryableHazelcastException("Cannot migrate at the moment! Owner of the partition is null => " + this.migrationInfo);
        }
        if (this.migrationInfo.startProcessing()) {
            try {
                if (!source.equals(owner)) {
                    throw new HazelcastException("Cannot migrate! This node is not owner of the partition => " + this.migrationInfo + " -> " + partition);
                }
                partitionService.addActiveMigration(this.migrationInfo);
                final long[] replicaVersions = partitionService.getPartitionReplicaVersions(this.migrationInfo.getPartitionId());
                final long timeout = nodeEngine.getGroupProperties().PARTITION_MIGRATION_TIMEOUT.getLong();
                final Collection<Operation> tasks = this.prepareMigrationTasks();
                if (tasks.size() > 0) {
                    this.returnResponse = false;
                    final ResponseHandler responseHandler = this.getResponseHandler();
                    final SerializationService serializationService = nodeEngine.getSerializationService();
                    nodeEngine.getExecutionService().getExecutor("hz:async").execute(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            BufferObjectDataOutput out = serializationService.createObjectDataOutput(32768);
                            try {
                                out.writeInt(tasks.size());
                                for (Operation task : tasks) {
                                    serializationService.writeObject(out, task);
                                }
                                boolean compress = nodeEngine.getGroupProperties().PARTITION_MIGRATION_ZIP_ENABLED.getBoolean();
                                byte[] data = compress ? IOUtil.compress(out.toByteArray()) : out.toByteArray();
                                MigrationOperation migrationOperation = new MigrationOperation(MigrationRequestOperation.this.migrationInfo, replicaVersions, data, tasks.size(), compress);
                                Invocation inv = nodeEngine.getOperationService().createInvocationBuilder("hz:core:partitionService", (Operation)migrationOperation, destination).setTryPauseMillis(1000L).setReplicaIndex(MigrationRequestOperation.this.getReplicaIndex()).build();
                                Future future = inv.invoke();
                                Boolean result = (Boolean)nodeEngine.toObject(future.get(timeout, TimeUnit.SECONDS));
                                responseHandler.sendResponse(result);
                            }
                            catch (Throwable e) {
                                responseHandler.sendResponse(Boolean.FALSE);
                                if (e instanceof ExecutionException) {
                                    e = e.getCause() != null ? e.getCause() : e;
                                }
                                Level level = e instanceof MemberLeftException || e instanceof InterruptedException || !MigrationRequestOperation.this.getNodeEngine().isActive() ? Level.INFO : Level.WARNING;
                                MigrationRequestOperation.this.getLogger().log(level, e.getMessage(), e);
                            }
                            finally {
                                IOUtil.closeResource(out);
                            }
                        }
                    });
                }
                this.success = true;
            }
            catch (Throwable e) {
                this.getLogger().warning(e);
                this.success = false;
            }
            finally {
                this.migrationInfo.doneProcessing();
            }
        } else {
            this.getLogger().warning("Migration is cancelled -> " + this.migrationInfo);
            this.success = false;
        }
    }

    @Override
    public ExceptionAction onException(Throwable throwable) {
        NodeEngine nodeEngine;
        if (throwable instanceof TargetNotMemberException && (nodeEngine = this.getNodeEngine()) != null && nodeEngine.getClusterService().getMember(this.migrationInfo.getDestination()) == null) {
            return ExceptionAction.THROW_EXCEPTION;
        }
        return super.onException(throwable);
    }

    @Override
    public Object getResponse() {
        return this.success;
    }

    @Override
    public boolean returnsResponse() {
        return this.returnResponse;
    }

    private Collection<Operation> prepareMigrationTasks() {
        NodeEngineImpl nodeEngine = (NodeEngineImpl)this.getNodeEngine();
        PartitionReplicationEvent replicationEvent = new PartitionReplicationEvent(this.migrationInfo.getPartitionId(), 0);
        PartitionMigrationEvent migrationEvent = new PartitionMigrationEvent(MigrationEndpoint.SOURCE, this.migrationInfo.getPartitionId());
        LinkedList<Operation> tasks = new LinkedList<Operation>();
        for (ServiceInfo serviceInfo : nodeEngine.getServiceInfos(MigrationAwareService.class)) {
            MigrationAwareService service = (MigrationAwareService)serviceInfo.getService();
            service.beforeMigration(migrationEvent);
            Operation op = service.prepareReplicationOperation(replicationEvent);
            if (op == null) continue;
            op.setServiceName(serviceInfo.getName());
            tasks.add(op);
        }
        return tasks;
    }
}

