/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jmx;

import com.hazelcast.core.EntryEvent;
import com.hazelcast.core.EntryListener;
import com.hazelcast.core.IMap;
import com.hazelcast.jmx.HazelcastMBean;
import com.hazelcast.jmx.ManagedAnnotation;
import com.hazelcast.jmx.ManagedDescription;
import com.hazelcast.jmx.ManagementService;
import com.hazelcast.query.SqlPredicate;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;

@ManagedDescription(value="IMap")
public class MapMBean
extends HazelcastMBean<IMap> {
    private AtomicLong totalAddedEntryCount = new AtomicLong();
    private AtomicLong totalRemovedEntryCount = new AtomicLong();
    private AtomicLong totalUpdatedEntryCount = new AtomicLong();
    private AtomicLong totalEvictedEntryCount = new AtomicLong();
    private final String listenerId;

    protected MapMBean(IMap managedObject, ManagementService service) {
        super(managedObject, service);
        this.objectName = service.createObjectName("IMap", managedObject.getName());
        EntryListener entryListener = new EntryListener(){

            public void entryAdded(EntryEvent event) {
                MapMBean.this.totalAddedEntryCount.incrementAndGet();
            }

            public void entryRemoved(EntryEvent event) {
                MapMBean.this.totalRemovedEntryCount.incrementAndGet();
            }

            public void entryUpdated(EntryEvent event) {
                MapMBean.this.totalUpdatedEntryCount.incrementAndGet();
            }

            public void entryEvicted(EntryEvent event) {
                MapMBean.this.totalEvictedEntryCount.incrementAndGet();
            }
        };
        this.listenerId = managedObject.addEntryListener(entryListener, false);
    }

    @Override
    public void preDeregister() throws Exception {
        super.preDeregister();
        try {
            ((IMap)this.managedObject).removeEntryListener(this.listenerId);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @ManagedAnnotation(value="localOwnedEntryCount")
    @ManagedDescription(value="number of entries owned on this member")
    public long getLocalOwnedEntryCount() {
        return ((IMap)this.managedObject).getLocalMapStats().getOwnedEntryCount();
    }

    @ManagedAnnotation(value="localBackupEntryCount")
    @ManagedDescription(value="the number of backup entries hold on this member")
    public long getLocalBackupEntryCount() {
        return ((IMap)this.managedObject).getLocalMapStats().getBackupEntryCount();
    }

    @ManagedAnnotation(value="localBackupCount")
    @ManagedDescription(value="the number of backups per entry on this member")
    public int getLocalBackupCount() {
        return ((IMap)this.managedObject).getLocalMapStats().getBackupCount();
    }

    @ManagedAnnotation(value="localOwnedEntryMemoryCost")
    @ManagedDescription(value="memory cost (number of bytes) of owned entries on this member")
    public long getLocalOwnedEntryMemoryCost() {
        return ((IMap)this.managedObject).getLocalMapStats().getOwnedEntryMemoryCost();
    }

    @ManagedAnnotation(value="localBackupEntryMemoryCost")
    @ManagedDescription(value="memory cost (number of bytes) of backup entries on this member.")
    public long getLocalBackupEntryMemoryCost() {
        return ((IMap)this.managedObject).getLocalMapStats().getBackupEntryMemoryCost();
    }

    @ManagedAnnotation(value="localCreationTime")
    @ManagedDescription(value="the creation time of this map on this member.")
    public long getLocalCreationTime() {
        return ((IMap)this.managedObject).getLocalMapStats().getCreationTime();
    }

    @ManagedAnnotation(value="localLastAccessTime")
    @ManagedDescription(value="the last access (read) time of the locally owned entries.")
    public long getLocalLastAccessTime() {
        return ((IMap)this.managedObject).getLocalMapStats().getLastAccessTime();
    }

    @ManagedAnnotation(value="localHits")
    @ManagedDescription(value="the number of hits (reads) of the locally owned entries.")
    public long getLocalHits() {
        return ((IMap)this.managedObject).getLocalMapStats().getHits();
    }

    @ManagedAnnotation(value="localLockedEntryCount")
    @ManagedDescription(value="the number of currently locked locally owned keys.")
    public long getLocalLockedEntryCount() {
        return ((IMap)this.managedObject).getLocalMapStats().getLockedEntryCount();
    }

    @ManagedAnnotation(value="localDirtyEntryCount")
    @ManagedDescription(value="the number of entries that the member owns and are dirty on this member")
    public long getLocalDirtyEntryCount() {
        return ((IMap)this.managedObject).getLocalMapStats().getDirtyEntryCount();
    }

    @ManagedAnnotation(value="localPutOperationCount")
    @ManagedDescription(value="the number of put operations on this member")
    public long getLocalPutOperationCount() {
        return ((IMap)this.managedObject).getLocalMapStats().getPutOperationCount();
    }

    @ManagedAnnotation(value="localGetOperationCount")
    @ManagedDescription(value="number of get operations on this member")
    public long getLocalGetOperationCount() {
        return ((IMap)this.managedObject).getLocalMapStats().getGetOperationCount();
    }

    @ManagedAnnotation(value="localRemoveOperationCount")
    @ManagedDescription(value="number of remove operations on this member")
    public long getLocalRemoveOperationCount() {
        return ((IMap)this.managedObject).getLocalMapStats().getRemoveOperationCount();
    }

    @ManagedAnnotation(value="localTotalPutLatency")
    @ManagedDescription(value="the total latency of put operations. To get the average latency, divide to number of puts")
    public long getLocalTotalPutLatency() {
        return ((IMap)this.managedObject).getLocalMapStats().getTotalPutLatency();
    }

    @ManagedAnnotation(value="localTotalGetLatency")
    @ManagedDescription(value="the total latency of get operations. To get the average latency, divide to number of gets")
    public long getLocalTotalGetLatency() {
        return ((IMap)this.managedObject).getLocalMapStats().getTotalGetLatency();
    }

    @ManagedAnnotation(value="localTotalRemoveLatency")
    @ManagedDescription(value="the total latency of remove operations. To get the average latency, divide to number of gets")
    public long getLocalTotalRemoveLatency() {
        return ((IMap)this.managedObject).getLocalMapStats().getTotalRemoveLatency();
    }

    @ManagedAnnotation(value="localMaxPutLatency")
    @ManagedDescription(value="the maximum latency of put operations. To get the average latency, divide to number of puts")
    public long getLocalMaxPutLatency() {
        return ((IMap)this.managedObject).getLocalMapStats().getMaxPutLatency();
    }

    @ManagedAnnotation(value="localMaxGetLatency")
    @ManagedDescription(value="the maximum latency of get operations. To get the average latency, divide to number of gets")
    public long getLocalMaxGetLatency() {
        return ((IMap)this.managedObject).getLocalMapStats().getMaxGetLatency();
    }

    @ManagedAnnotation(value="localMaxRemoveLatency")
    @ManagedDescription(value="the maximum latency of remove operations. To get the average latency, divide to number of gets")
    public long getMaxRemoveLatency() {
        return ((IMap)this.managedObject).getLocalMapStats().getMaxRemoveLatency();
    }

    @ManagedAnnotation(value="localEventOperationCount")
    @ManagedDescription(value="number of events received on this member")
    public long getLocalEventOperationCount() {
        return ((IMap)this.managedObject).getLocalMapStats().getEventOperationCount();
    }

    @ManagedAnnotation(value="localOtherOperationCount")
    @ManagedDescription(value="the total number of other operations on this member")
    public long getLocalOtherOperationCount() {
        return ((IMap)this.managedObject).getLocalMapStats().getOtherOperationCount();
    }

    @ManagedAnnotation(value="localTotal")
    @ManagedDescription(value="the total number of operations on this member")
    public long localTotal() {
        return ((IMap)this.managedObject).getLocalMapStats().total();
    }

    @ManagedAnnotation(value="localHeapCost")
    @ManagedDescription(value="the total heap cost of map, near cache and heap cost")
    public long localHeapCost() {
        return ((IMap)this.managedObject).getLocalMapStats().getHeapCost();
    }

    @ManagedAnnotation(value="name")
    @ManagedDescription(value="name of the map")
    public String getName() {
        return ((IMap)this.managedObject).getName();
    }

    @ManagedAnnotation(value="size")
    @ManagedDescription(value="size of the map")
    public int getSize() {
        return ((IMap)this.managedObject).size();
    }

    @ManagedAnnotation(value="config")
    @ManagedDescription(value="MapConfig")
    public String getConfig() {
        return this.service.instance.getConfig().getMapConfig(((IMap)this.managedObject).getName()).toString();
    }

    @ManagedAnnotation(value="totalAddedEntryCount")
    public long getTotalAddedEntryCount() {
        return this.totalAddedEntryCount.get();
    }

    @ManagedAnnotation(value="totalRemovedEntryCount")
    public long getTotalRemovedEntryCount() {
        return this.totalRemovedEntryCount.get();
    }

    @ManagedAnnotation(value="totalUpdatedEntryCount")
    public long getTotalUpdatedEntryCount() {
        return this.totalUpdatedEntryCount.get();
    }

    @ManagedAnnotation(value="totalEvictedEntryCount")
    public long getTotalEvictedEntryCount() {
        return this.totalEvictedEntryCount.get();
    }

    @ManagedAnnotation(value="clear", operation=true)
    @ManagedDescription(value="Clear Map")
    public void clear() {
        ((IMap)this.managedObject).clear();
    }

    @ManagedAnnotation(value="values", operation=true)
    public String values(String query) {
        Collection coll;
        if (query != null && !query.isEmpty()) {
            SqlPredicate predicate = new SqlPredicate(query);
            coll = ((IMap)this.managedObject).values(predicate);
        } else {
            coll = ((IMap)this.managedObject).values();
        }
        StringBuilder buf = new StringBuilder();
        if (coll.size() == 0) {
            buf.append("Empty");
        } else {
            buf.append("[");
            for (Object obj : coll) {
                buf.append(obj);
                buf.append(", ");
            }
            buf.replace(buf.length() - 1, buf.length(), "]");
        }
        return buf.toString();
    }

    @ManagedAnnotation(value="entrySet", operation=true)
    public String entrySet(String query) {
        Set entrySet;
        if (query != null && !query.isEmpty()) {
            SqlPredicate predicate = new SqlPredicate(query);
            entrySet = ((IMap)this.managedObject).entrySet(predicate);
        } else {
            entrySet = ((IMap)this.managedObject).entrySet();
        }
        StringBuilder buf = new StringBuilder();
        if (entrySet.size() == 0) {
            buf.append("Empty");
        } else {
            buf.append("[");
            for (Map.Entry entry : entrySet) {
                buf.append("{key:");
                buf.append(entry.getKey());
                buf.append(", value:");
                buf.append(entry.getValue());
                buf.append("}, ");
            }
            buf.replace(buf.length() - 1, buf.length(), "]");
        }
        return buf.toString();
    }
}

