/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.concurrent.semaphore;

import com.hazelcast.config.SemaphoreConfig;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.DataSerializable;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class Permit
implements DataSerializable {
    private int available;
    private int partitionId;
    private Map<String, Integer> attachMap;
    private int backupCount;
    private int asyncBackupCount;
    private boolean initialized = false;

    public Permit() {
    }

    public Permit(int partitionId, SemaphoreConfig config) {
        this.partitionId = partitionId;
        this.backupCount = config.getBackupCount();
        this.asyncBackupCount = config.getAsyncBackupCount();
        this.available = config.getInitialPermits();
        this.attachMap = new HashMap<String, Integer>(10);
    }

    private void attach(String caller, int permitCount) {
        Integer attached = this.attachMap.get(caller);
        if (attached == null) {
            attached = 0;
        }
        this.attachMap.put(caller, attached + permitCount);
    }

    private void detach(String caller, int permitCount) {
        Integer attached = this.attachMap.get(caller);
        if (attached != null) {
            if ((attached = Integer.valueOf(attached - permitCount)) <= 0) {
                this.attachMap.remove(caller);
            } else {
                this.attachMap.put(caller, attached);
            }
        }
    }

    public boolean memberRemoved(String caller) {
        Integer attached = this.attachMap.remove(caller);
        if (attached != null) {
            this.available += attached.intValue();
            return true;
        }
        return false;
    }

    public boolean init(int permitCount) {
        if (this.initialized || this.available != 0) {
            return false;
        }
        this.available = permitCount;
        this.initialized = true;
        return true;
    }

    public int getAvailable() {
        return this.available;
    }

    public boolean isAvailable(int permitCount) {
        return this.available - permitCount >= 0;
    }

    public boolean acquire(int permitCount, String caller) {
        if (this.isAvailable(permitCount)) {
            this.available -= permitCount;
            this.attach(caller, permitCount);
            this.initialized = true;
            return true;
        }
        return false;
    }

    public int drain(String caller) {
        int drain = this.available;
        this.available = 0;
        if (drain > 0) {
            this.initialized = true;
            this.attach(caller, drain);
        }
        return drain;
    }

    public boolean reduce(int permitCount) {
        if (this.available == 0 || permitCount == 0) {
            return false;
        }
        this.available -= permitCount;
        if (this.available < 0) {
            this.available = 0;
        }
        return true;
    }

    public void release(int permitCount, String caller) {
        this.available += permitCount;
        this.initialized = true;
        this.detach(caller, permitCount);
    }

    public int getPartitionId() {
        return this.partitionId;
    }

    public int getSyncBackupCount() {
        return this.backupCount;
    }

    public int getAsyncBackupCount() {
        return this.asyncBackupCount;
    }

    protected void setInitialized(boolean initialized) {
        this.initialized = initialized;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeInt(this.available);
        out.writeInt(this.partitionId);
        out.writeInt(this.backupCount);
        out.writeInt(this.asyncBackupCount);
        out.writeInt(this.attachMap.size());
        for (Map.Entry<String, Integer> entry : this.attachMap.entrySet()) {
            out.writeUTF(entry.getKey());
            out.writeInt(entry.getValue());
        }
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.available = in.readInt();
        this.partitionId = in.readInt();
        this.backupCount = in.readInt();
        this.asyncBackupCount = in.readInt();
        int size = in.readInt();
        this.attachMap = new HashMap<String, Integer>(size);
        for (int i = 0; i < size; ++i) {
            String caller = in.readUTF();
            Integer val = in.readInt();
            this.attachMap.put(caller, val);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Permit");
        sb.append("{available=").append(this.available);
        sb.append(", partitionId=").append(this.partitionId);
        sb.append(", backupCount=").append(this.backupCount);
        sb.append(", asyncBackupCount=").append(this.asyncBackupCount);
        sb.append('}');
        sb.append("\n");
        for (Map.Entry<String, Integer> entry : this.attachMap.entrySet()) {
            sb.append("{caller=").append(entry.getKey());
            sb.append(", attached=").append(entry.getValue());
            sb.append("} ");
        }
        return sb.toString();
    }

    public int getTotalBackupCount() {
        return this.backupCount + this.asyncBackupCount;
    }
}

