/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client;

import com.hazelcast.client.HazelcastClient;
import com.hazelcast.config.ListenerConfig;
import com.hazelcast.core.LifecycleEvent;
import com.hazelcast.core.LifecycleListener;
import com.hazelcast.core.LifecycleService;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;

public final class LifecycleServiceImpl
implements LifecycleService {
    private final HazelcastClient client;
    private final ConcurrentMap<String, LifecycleListener> lifecycleListeners = new ConcurrentHashMap<String, LifecycleListener>();
    private final Object lifecycleLock = new Object();
    private final AtomicBoolean active = new AtomicBoolean(false);

    public LifecycleServiceImpl(HazelcastClient client) {
        this.client = client;
        List<ListenerConfig> listenerConfigs = client.getClientConfig().getListenerConfigs();
        if (listenerConfigs != null && !listenerConfigs.isEmpty()) {
            for (ListenerConfig listenerConfig : listenerConfigs) {
                if (!(listenerConfig.getImplementation() instanceof LifecycleListener)) continue;
                this.addLifecycleListener((LifecycleListener)listenerConfig.getImplementation());
            }
        }
        this.fireLifecycleEvent(LifecycleEvent.LifecycleState.STARTING);
    }

    private ILogger getLogger() {
        return Logger.getLogger(LifecycleService.class);
    }

    @Override
    public String addLifecycleListener(LifecycleListener lifecycleListener) {
        String id = UUID.randomUUID().toString();
        this.lifecycleListeners.put(id, lifecycleListener);
        return id;
    }

    @Override
    public boolean removeLifecycleListener(String registrationId) {
        return this.lifecycleListeners.remove(registrationId) != null;
    }

    private void fireLifecycleEvent(LifecycleEvent.LifecycleState lifecycleState) {
        LifecycleEvent lifecycleEvent = new LifecycleEvent(lifecycleState);
        this.getLogger().info("HazelcastClient[" + this.client.getName() + "] is " + (Object)((Object)lifecycleEvent.getState()));
        for (LifecycleListener lifecycleListener : this.lifecycleListeners.values()) {
            lifecycleListener.stateChanged(lifecycleEvent);
        }
    }

    void setStarted() {
        this.active.set(true);
        this.fireLifecycleEvent(LifecycleEvent.LifecycleState.STARTED);
    }

    @Override
    public boolean isRunning() {
        return this.active.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown() {
        this.active.set(false);
        Object object = this.lifecycleLock;
        synchronized (object) {
            this.fireLifecycleEvent(LifecycleEvent.LifecycleState.SHUTTING_DOWN);
            this.client.doShutdown();
            this.fireLifecycleEvent(LifecycleEvent.LifecycleState.SHUTDOWN);
        }
    }

    @Override
    public void terminate() {
        this.shutdown();
    }
}

