/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.util.executor;

import com.hazelcast.util.executor.StripedRunnable;
import java.util.Random;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.atomic.AtomicBoolean;

public final class StripedExecutor
implements Executor {
    private final int size;
    private final Executor executor;
    private final Worker[] workers;
    private final Random rand = new Random();
    private volatile boolean live = true;

    public StripedExecutor(Executor executor, int workerCount) {
        this.size = workerCount;
        this.executor = executor;
        this.workers = new Worker[workerCount];
        for (int i = 0; i < workerCount; ++i) {
            this.workers[i] = new Worker();
        }
    }

    @Override
    public void execute(Runnable command) {
        int key = command instanceof StripedRunnable ? ((StripedRunnable)command).getKey() : this.rand.nextInt();
        if (!this.live) {
            throw new RejectedExecutionException("Executor is terminated!");
        }
        int index = key != Integer.MIN_VALUE ? Math.abs(key) % this.size : 0;
        this.workers[index].execute(command);
    }

    public void shutdown() {
        this.live = false;
        for (Worker worker : this.workers) {
            worker.clear();
        }
    }

    private class Worker
    extends ConcurrentLinkedQueue<Runnable>
    implements Executor,
    Runnable {
        private final AtomicBoolean scheduled = new AtomicBoolean(false);

        private Worker() {
        }

        @Override
        public void execute(Runnable command) {
            if (!this.offer(command)) {
                throw new RejectedExecutionException("Worker queue is full!");
            }
            this.schedule();
        }

        private void schedule() {
            if (!this.isEmpty() && this.scheduled.compareAndSet(false, true)) {
                try {
                    StripedExecutor.this.executor.execute(this);
                }
                catch (RejectedExecutionException e) {
                    this.scheduled.set(false);
                    throw e;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                Runnable r;
                do {
                    if ((r = (Runnable)this.poll()) == null) continue;
                    r.run();
                } while (r != null);
            }
            finally {
                this.scheduled.set(false);
                this.schedule();
            }
        }
    }
}

