/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.spi.impl;

import com.hazelcast.core.DistributedObject;
import com.hazelcast.core.DistributedObjectEvent;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.HazelcastInstanceAware;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.DataSerializable;
import java.io.IOException;

public final class DistributedObjectEventImpl
implements DataSerializable,
HazelcastInstanceAware,
DistributedObjectEvent {
    private DistributedObjectEvent.EventType eventType;
    private String serviceName;
    private Object objectId;
    private transient HazelcastInstance hazelcastInstance;

    public DistributedObjectEventImpl() {
    }

    public DistributedObjectEventImpl(DistributedObjectEvent.EventType eventType, String serviceName, Object objectId) {
        this.eventType = eventType;
        this.serviceName = serviceName;
        this.objectId = objectId;
    }

    @Override
    public String getServiceName() {
        return this.serviceName;
    }

    @Override
    public DistributedObjectEvent.EventType getEventType() {
        return this.eventType;
    }

    @Override
    public Object getObjectId() {
        return this.objectId;
    }

    @Override
    public DistributedObject getDistributedObject() {
        return this.hazelcastInstance != null ? (DistributedObject)this.hazelcastInstance.getDistributedObject(this.serviceName, this.objectId) : null;
    }

    @Override
    public void setHazelcastInstance(HazelcastInstance hazelcastInstance) {
        this.hazelcastInstance = hazelcastInstance;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeBoolean(this.eventType == DistributedObjectEvent.EventType.CREATED);
        out.writeUTF(this.serviceName);
        out.writeObject(this.objectId);
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.eventType = in.readBoolean() ? DistributedObjectEvent.EventType.CREATED : DistributedObjectEvent.EventType.DESTROYED;
        this.serviceName = in.readUTF();
        this.objectId = in.readObject();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("DistributedObjectEvent");
        sb.append("{eventType=").append((Object)this.eventType);
        sb.append(", serviceName='").append(this.serviceName).append('\'');
        sb.append(", objectId=").append(this.objectId);
        sb.append('}');
        return sb.toString();
    }
}

