/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.nio.serialization;

import com.hazelcast.nio.BufferObjectDataInput;
import com.hazelcast.nio.BufferObjectDataOutput;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.ClassDefinition;
import com.hazelcast.nio.serialization.DefaultPortableReader;
import com.hazelcast.nio.serialization.DefaultPortableWriter;
import com.hazelcast.nio.serialization.HazelcastSerializationException;
import com.hazelcast.nio.serialization.MorphingPortableReader;
import com.hazelcast.nio.serialization.Portable;
import com.hazelcast.nio.serialization.PortableContextAwareInputStream;
import com.hazelcast.nio.serialization.PortableFactory;
import com.hazelcast.nio.serialization.SerializationConstants;
import com.hazelcast.nio.serialization.SerializationContext;
import com.hazelcast.nio.serialization.StreamSerializer;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

final class PortableSerializer
implements StreamSerializer<Portable> {
    private final SerializationContext context;
    private final Map<Integer, PortableFactory> factories = new HashMap<Integer, PortableFactory>();

    PortableSerializer(SerializationContext context, Map<Integer, ? extends PortableFactory> portableFactories) {
        this.context = context;
        this.factories.putAll(portableFactories);
    }

    @Override
    public int getTypeId() {
        return SerializationConstants.CONSTANT_TYPE_PORTABLE;
    }

    @Override
    public void write(ObjectDataOutput out, Portable p) throws IOException {
        if (p.getClassId() == 0) {
            throw new IllegalArgumentException("Portable class id cannot be zero!");
        }
        if (!(out instanceof BufferObjectDataOutput)) {
            throw new IllegalArgumentException("ObjectDataOutput must be instance of BufferObjectDataOutput!");
        }
        if (p.getClassId() == 0) {
            throw new IllegalArgumentException("Portable class id cannot be zero!");
        }
        ClassDefinition cd = this.context.lookupOrRegisterClassDefinition(p);
        BufferObjectDataOutput bufferedOut = (BufferObjectDataOutput)out;
        DefaultPortableWriter writer = new DefaultPortableWriter(this, bufferedOut, cd);
        p.writePortable(writer);
        writer.end();
    }

    @Override
    public Portable read(ObjectDataInput in) throws IOException {
        DefaultPortableReader reader;
        if (!(in instanceof BufferObjectDataInput)) {
            throw new IllegalArgumentException("ObjectDataInput must be instance of BufferObjectDataInput!");
        }
        if (!(in instanceof PortableContextAwareInputStream)) {
            throw new IllegalArgumentException("ObjectDataInput must be instance of PortableContextAwareInputStream!");
        }
        PortableContextAwareInputStream ctxIn = (PortableContextAwareInputStream)((Object)in);
        int factoryId = ctxIn.getFactoryId();
        int dataClassId = ctxIn.getClassId();
        int dataVersion = ctxIn.getVersion();
        PortableFactory portableFactory = this.factories.get(factoryId);
        if (portableFactory == null) {
            throw new HazelcastSerializationException("Could not find PortableFactory for factory-id: " + factoryId);
        }
        Portable portable = portableFactory.create(dataClassId);
        if (portable == null) {
            throw new HazelcastSerializationException("Could not create Portable for class-id: " + dataClassId);
        }
        BufferObjectDataInput bufferedIn = (BufferObjectDataInput)in;
        if (this.context.getVersion() == dataVersion) {
            ClassDefinition cd = this.context.lookup(factoryId, dataClassId);
            reader = new DefaultPortableReader(this, bufferedIn, cd);
        } else {
            ClassDefinition cd = this.context.lookup(factoryId, dataClassId, dataVersion);
            reader = new MorphingPortableReader(this, bufferedIn, cd);
        }
        portable.readPortable(reader);
        reader.end();
        return portable;
    }

    @Override
    public void destroy() {
        this.factories.clear();
    }
}

