/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.record;

import com.hazelcast.map.record.Record;
import com.hazelcast.map.record.RecordStatistics;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.DataSerializable;
import java.io.IOException;

public abstract class AbstractRecord<V>
implements Record<V>,
DataSerializable {
    protected volatile RecordStatistics statistics;
    protected volatile Data key;
    protected volatile long version;

    public AbstractRecord(Data key, boolean statisticsEnabled) {
        this.key = key;
        if (statisticsEnabled) {
            this.statistics = new RecordStatistics();
        }
        this.version = 0L;
    }

    public AbstractRecord() {
    }

    @Override
    public Data getKey() {
        return this.key;
    }

    @Override
    public RecordStatistics getStatistics() {
        return this.statistics;
    }

    @Override
    public void setStatistics(RecordStatistics stats) {
        this.statistics = stats;
    }

    public Integer getHits() {
        return this.statistics == null ? -1 : this.statistics.getHits();
    }

    public Long getLastAccessTime() {
        return this.statistics == null ? -1L : this.statistics.getLastAccessTime();
    }

    @Override
    public abstract long getCost();

    @Override
    public long getVersion() {
        return this.version;
    }

    @Override
    public void onAccess() {
        if (this.statistics != null) {
            this.statistics.access();
        }
    }

    @Override
    public void onStore() {
        if (this.statistics != null) {
            this.statistics.store();
        }
    }

    @Override
    public void onUpdate() {
        if (this.statistics != null) {
            this.statistics.update();
        }
        ++this.version;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        this.key.writeData(out);
        if (this.statistics != null) {
            out.writeBoolean(true);
            this.statistics.writeData(out);
        } else {
            out.writeBoolean(false);
        }
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.key = new Data();
        this.key.readData(in);
        boolean statsEnabled = in.readBoolean();
        if (statsEnabled) {
            this.statistics = new RecordStatistics();
            this.statistics.readData(in);
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractRecord that = (AbstractRecord)o;
        return this.key.equals(that.key);
    }

    @Override
    public int hashCode() {
        return this.key.hashCode();
    }

    public String toString() {
        return "AbstractRecord{key=" + this.key + '}';
    }
}

