/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.proxy;

import com.hazelcast.concurrent.lock.proxy.LockProxySupport;
import com.hazelcast.config.EntryListenerConfig;
import com.hazelcast.config.MapConfig;
import com.hazelcast.config.MapIndexConfig;
import com.hazelcast.core.EntryListener;
import com.hazelcast.core.EntryView;
import com.hazelcast.core.HazelcastInstanceAware;
import com.hazelcast.instance.MemberImpl;
import com.hazelcast.map.EntryEventFilter;
import com.hazelcast.map.EntryProcessor;
import com.hazelcast.map.MapEntrySet;
import com.hazelcast.map.MapInterceptor;
import com.hazelcast.map.MapKeySet;
import com.hazelcast.map.MapService;
import com.hazelcast.map.MapValueCollection;
import com.hazelcast.map.QueryEventFilter;
import com.hazelcast.map.QueryResult;
import com.hazelcast.map.operation.AddIndexOperation;
import com.hazelcast.map.operation.AddInterceptorOperation;
import com.hazelcast.map.operation.BasePutOperation;
import com.hazelcast.map.operation.BaseRemoveOperation;
import com.hazelcast.map.operation.ClearOperation;
import com.hazelcast.map.operation.ContainsKeyOperation;
import com.hazelcast.map.operation.ContainsValueOperationFactory;
import com.hazelcast.map.operation.EntryOperation;
import com.hazelcast.map.operation.EvictOperation;
import com.hazelcast.map.operation.GetEntryViewOperation;
import com.hazelcast.map.operation.GetOperation;
import com.hazelcast.map.operation.KeyBasedMapOperation;
import com.hazelcast.map.operation.MapEntrySetOperation;
import com.hazelcast.map.operation.MapFlushOperation;
import com.hazelcast.map.operation.MapGetAllOperationFactory;
import com.hazelcast.map.operation.MapIsEmptyOperation;
import com.hazelcast.map.operation.MapKeySetOperation;
import com.hazelcast.map.operation.MapValuesOperation;
import com.hazelcast.map.operation.PartitionWideEntryOperation;
import com.hazelcast.map.operation.PutAllOperation;
import com.hazelcast.map.operation.PutIfAbsentOperation;
import com.hazelcast.map.operation.PutOperation;
import com.hazelcast.map.operation.PutTransientOperation;
import com.hazelcast.map.operation.QueryOperation;
import com.hazelcast.map.operation.QueryPartitionOperation;
import com.hazelcast.map.operation.RemoveIfSameOperation;
import com.hazelcast.map.operation.RemoveInterceptorOperation;
import com.hazelcast.map.operation.RemoveOperation;
import com.hazelcast.map.operation.ReplaceIfSameOperation;
import com.hazelcast.map.operation.ReplaceOperation;
import com.hazelcast.map.operation.SetOperation;
import com.hazelcast.map.operation.SizeOperationFactory;
import com.hazelcast.map.operation.TryPutOperation;
import com.hazelcast.map.operation.TryRemoveOperation;
import com.hazelcast.monitor.LocalMapStats;
import com.hazelcast.monitor.impl.LocalMapStatsImpl;
import com.hazelcast.nio.ClassLoaderUtil;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.partition.PartitionService;
import com.hazelcast.partition.PartitionView;
import com.hazelcast.query.Predicate;
import com.hazelcast.spi.AbstractDistributedObject;
import com.hazelcast.spi.DefaultObjectNamespace;
import com.hazelcast.spi.InitializingObject;
import com.hazelcast.spi.Invocation;
import com.hazelcast.spi.NodeEngine;
import com.hazelcast.spi.Operation;
import com.hazelcast.spi.OperationService;
import com.hazelcast.spi.impl.BinaryOperationFactory;
import com.hazelcast.util.ExceptionUtil;
import com.hazelcast.util.IterationType;
import com.hazelcast.util.QueryResultSet;
import com.hazelcast.util.ThreadUtil;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;

abstract class MapProxySupport
extends AbstractDistributedObject<MapService>
implements InitializingObject {
    protected static final String NULL_KEY_IS_NOT_ALLOWED = "Null key is not allowed!";
    protected static final String NULL_VALUE_IS_NOT_ALLOWED = "Null value is not allowed!";
    protected final String name;
    protected final MapConfig mapConfig;
    protected final LocalMapStatsImpl localMapStats;
    protected final LockProxySupport lockSupport;

    protected MapProxySupport(String name, MapService service, NodeEngine nodeEngine) {
        super(nodeEngine, service);
        this.name = name;
        this.mapConfig = service.getMapContainer(name).getMapConfig();
        this.localMapStats = service.getLocalMapStatsImpl(name);
        this.lockSupport = new LockProxySupport(new DefaultObjectNamespace("hz:impl:mapService", name));
    }

    @Override
    public void initialize() {
        this.initializeListeners();
        this.initializeIndexes();
    }

    private void initializeIndexes() {
        for (MapIndexConfig index : this.mapConfig.getMapIndexConfigs()) {
            if (index.getAttribute() == null) continue;
            this.addIndex(index.getAttribute(), index.isOrdered());
        }
    }

    private void initializeListeners() {
        NodeEngine nodeEngine = this.getNodeEngine();
        List<EntryListenerConfig> listenerConfigs = this.mapConfig.getEntryListenerConfigs();
        for (EntryListenerConfig listenerConfig : listenerConfigs) {
            EntryListener listener = null;
            if (listenerConfig.getImplementation() != null) {
                listener = listenerConfig.getImplementation();
            } else if (listenerConfig.getClassName() != null) {
                try {
                    listener = (EntryListener)ClassLoaderUtil.newInstance(nodeEngine.getConfigClassLoader(), listenerConfig.getClassName());
                }
                catch (Exception e) {
                    throw ExceptionUtil.rethrow(e);
                }
            }
            if (listener == null) continue;
            if (listener instanceof HazelcastInstanceAware) {
                ((HazelcastInstanceAware)((Object)listener)).setHazelcastInstance(nodeEngine.getHazelcastInstance());
            }
            if (listenerConfig.isLocal()) {
                this.addLocalEntryListener(listener);
                continue;
            }
            this.addEntryListenerInternal(listener, null, listenerConfig.isIncludeValue());
        }
    }

    protected Object getInternal(Data key) {
        Object cached;
        MapService mapService = (MapService)this.getService();
        boolean nearCacheEnabled = this.mapConfig.isNearCacheEnabled();
        if (nearCacheEnabled && (cached = mapService.getFromNearCache(this.name, key)) != null) {
            mapService.interceptAfterGet(this.name, cached);
            return cached;
        }
        NodeEngine nodeEngine = this.getNodeEngine();
        if (this.mapConfig.isReadBackupData()) {
            int backupCount = this.mapConfig.getTotalBackupCount();
            PartitionService partitionService = mapService.getNodeEngine().getPartitionService();
            for (int i = 0; i <= backupCount; ++i) {
                Object val;
                int partitionId = partitionService.getPartitionId(key);
                PartitionView partition = partitionService.getPartition(partitionId);
                if (!nodeEngine.getThisAddress().equals(partition.getReplicaAddress(i)) || (val = mapService.getPartitionContainer(partitionId).getRecordStore(this.name).get(key)) == null) continue;
                mapService.interceptAfterGet(this.name, val);
                return val;
            }
        }
        GetOperation operation = new GetOperation(this.name, key);
        Data result = (Data)this.invokeOperation(key, operation);
        if (nearCacheEnabled) {
            int partitionId = nodeEngine.getPartitionService().getPartitionId(key);
            if (!nodeEngine.getPartitionService().getPartitionOwner(partitionId).equals(nodeEngine.getClusterService().getThisAddress())) {
                mapService.putNearCache(this.name, key, result);
            }
        }
        return result;
    }

    protected Future<Data> getAsyncInternal(Data key) {
        NodeEngine nodeEngine = this.getNodeEngine();
        int partitionId = nodeEngine.getPartitionService().getPartitionId(key);
        GetOperation operation = new GetOperation(this.name, key);
        try {
            Invocation invocation = nodeEngine.getOperationService().createInvocationBuilder("hz:impl:mapService", (Operation)operation, partitionId).build();
            return invocation.invoke();
        }
        catch (Throwable t) {
            throw ExceptionUtil.rethrow(t);
        }
    }

    protected Data putInternal(Data key, Data value, long ttl, TimeUnit timeunit) {
        PutOperation operation = new PutOperation(this.name, key, value, this.getTimeInMillis(ttl, timeunit));
        return (Data)this.invokeOperation(key, operation);
    }

    protected boolean tryPutInternal(Data key, Data value, long timeout, TimeUnit timeunit) {
        TryPutOperation operation = new TryPutOperation(this.name, key, value, this.getTimeInMillis(timeout, timeunit));
        return (Boolean)this.invokeOperation(key, operation);
    }

    protected Data putIfAbsentInternal(Data key, Data value, long ttl, TimeUnit timeunit) {
        PutIfAbsentOperation operation = new PutIfAbsentOperation(this.name, key, value, this.getTimeInMillis(ttl, timeunit));
        return (Data)this.invokeOperation(key, operation);
    }

    protected void putTransientInternal(Data key, Data value, long ttl, TimeUnit timeunit) {
        PutTransientOperation operation = new PutTransientOperation(this.name, key, value, this.getTimeInMillis(ttl, timeunit));
        this.invokeOperation(key, operation);
    }

    private Object invokeOperation(Data key, KeyBasedMapOperation operation) {
        NodeEngine nodeEngine = this.getNodeEngine();
        int partitionId = nodeEngine.getPartitionService().getPartitionId(key);
        operation.setThreadId(ThreadUtil.getThreadId());
        try {
            Object o;
            Invocation invocation = nodeEngine.getOperationService().createInvocationBuilder("hz:impl:mapService", (Operation)operation, partitionId).build();
            if (this.mapConfig.isStatisticsEnabled()) {
                long time = System.currentTimeMillis();
                Future f = invocation.invoke();
                o = f.get();
                if (operation instanceof BasePutOperation) {
                    this.localMapStats.incrementPuts(System.currentTimeMillis() - time);
                } else if (operation instanceof BaseRemoveOperation) {
                    this.localMapStats.incrementRemoves(System.currentTimeMillis() - time);
                } else if (operation instanceof GetOperation) {
                    this.localMapStats.incrementGets(System.currentTimeMillis() - time);
                }
            } else {
                Future f = invocation.invoke();
                o = f.get();
            }
            return o;
        }
        catch (Throwable t) {
            throw ExceptionUtil.rethrow(t);
        }
    }

    protected Future<Data> putAsyncInternal(Data key, Data value, long ttl, TimeUnit timeunit) {
        NodeEngine nodeEngine = this.getNodeEngine();
        int partitionId = nodeEngine.getPartitionService().getPartitionId(key);
        PutOperation operation = new PutOperation(this.name, key, value, this.getTimeInMillis(ttl, timeunit));
        operation.setThreadId(ThreadUtil.getThreadId());
        try {
            Invocation invocation = nodeEngine.getOperationService().createInvocationBuilder("hz:impl:mapService", (Operation)operation, partitionId).build();
            return invocation.invoke();
        }
        catch (Throwable t) {
            throw ExceptionUtil.rethrow(t);
        }
    }

    protected boolean replaceInternal(Data key, Data oldValue, Data newValue) {
        ReplaceIfSameOperation operation = new ReplaceIfSameOperation(this.name, key, oldValue, newValue);
        return (Boolean)this.invokeOperation(key, operation);
    }

    protected Data replaceInternal(Data key, Data value) {
        ReplaceOperation operation = new ReplaceOperation(this.name, key, value);
        return (Data)this.invokeOperation(key, operation);
    }

    protected void setInternal(Data key, Data value, long ttl, TimeUnit timeunit) {
        SetOperation operation = new SetOperation(this.name, key, value, timeunit.toMillis(ttl));
        this.invokeOperation(key, operation);
    }

    protected boolean evictInternal(Data key) {
        EvictOperation operation = new EvictOperation(this.name, key, false);
        return (Boolean)this.invokeOperation(key, operation);
    }

    protected Data removeInternal(Data key) {
        RemoveOperation operation = new RemoveOperation(this.name, key);
        return (Data)this.invokeOperation(key, operation);
    }

    protected void deleteInternal(Data key) {
        RemoveOperation operation = new RemoveOperation(this.name, key);
        this.invokeOperation(key, operation);
    }

    protected boolean removeInternal(Data key, Data value) {
        RemoveIfSameOperation operation = new RemoveIfSameOperation(this.name, key, value);
        return (Boolean)this.invokeOperation(key, operation);
    }

    protected boolean tryRemoveInternal(Data key, long timeout, TimeUnit timeunit) {
        TryRemoveOperation operation = new TryRemoveOperation(this.name, key, this.getTimeInMillis(timeout, timeunit));
        return (Boolean)this.invokeOperation(key, operation);
    }

    protected Future<Data> removeAsyncInternal(Data key) {
        NodeEngine nodeEngine = this.getNodeEngine();
        int partitionId = nodeEngine.getPartitionService().getPartitionId(key);
        RemoveOperation operation = new RemoveOperation(this.name, key);
        operation.setThreadId(ThreadUtil.getThreadId());
        try {
            Invocation invocation = nodeEngine.getOperationService().createInvocationBuilder("hz:impl:mapService", (Operation)operation, partitionId).build();
            return invocation.invoke();
        }
        catch (Throwable t) {
            throw ExceptionUtil.rethrow(t);
        }
    }

    protected boolean containsKeyInternal(Data key) {
        NodeEngine nodeEngine = this.getNodeEngine();
        int partitionId = nodeEngine.getPartitionService().getPartitionId(key);
        ContainsKeyOperation containsKeyOperation = new ContainsKeyOperation(this.name, key);
        containsKeyOperation.setServiceName("hz:impl:mapService");
        try {
            Invocation invocation = nodeEngine.getOperationService().createInvocationBuilder("hz:impl:mapService", (Operation)containsKeyOperation, partitionId).build();
            Future f = invocation.invoke();
            return (Boolean)((MapService)this.getService()).toObject(f.get());
        }
        catch (Throwable t) {
            throw ExceptionUtil.rethrow(t);
        }
    }

    public int size() {
        NodeEngine nodeEngine = this.getNodeEngine();
        try {
            Map<Integer, Object> results = nodeEngine.getOperationService().invokeOnAllPartitions("hz:impl:mapService", new SizeOperationFactory(this.name));
            int total = 0;
            for (Object result : results.values()) {
                Integer size = (Integer)((MapService)this.getService()).toObject(result);
                total += size.intValue();
            }
            return total;
        }
        catch (Throwable t) {
            throw ExceptionUtil.rethrow(t);
        }
    }

    public boolean containsValueInternal(Data dataValue) {
        NodeEngine nodeEngine = this.getNodeEngine();
        try {
            Map<Integer, Object> results = nodeEngine.getOperationService().invokeOnAllPartitions("hz:impl:mapService", new ContainsValueOperationFactory(this.name, dataValue));
            for (Object result : results.values()) {
                Boolean contains = (Boolean)((MapService)this.getService()).toObject(result);
                if (!contains.booleanValue()) continue;
                return true;
            }
            return false;
        }
        catch (Throwable t) {
            throw ExceptionUtil.rethrow(t);
        }
    }

    public boolean isEmpty() {
        NodeEngine nodeEngine = this.getNodeEngine();
        try {
            Map<Integer, Object> results = nodeEngine.getOperationService().invokeOnAllPartitions("hz:impl:mapService", new BinaryOperationFactory(new MapIsEmptyOperation(this.name), nodeEngine));
            for (Object result : results.values()) {
                if (((Boolean)((MapService)this.getService()).toObject(result)).booleanValue()) continue;
                return false;
            }
            return true;
        }
        catch (Throwable t) {
            throw ExceptionUtil.rethrow(t);
        }
    }

    protected Map<Data, Data> getAllDataInternal(Set<Data> keys) {
        return null;
    }

    protected Map<Object, Object> getAllObjectInternal(Set<Data> keys) {
        NodeEngine nodeEngine = this.getNodeEngine();
        HashMap<Object, Object> result = new HashMap<Object, Object>();
        Map<Integer, Object> responses = null;
        try {
            responses = nodeEngine.getOperationService().invokeOnAllPartitions("hz:impl:mapService", new MapGetAllOperationFactory(this.name, keys));
            for (Object response : responses.values()) {
                Set<Map.Entry<Data, Data>> entries = ((MapEntrySet)((MapService)this.getService()).toObject(response)).getEntrySet();
                for (Map.Entry<Data, Data> entry : entries) {
                    result.put(((MapService)this.getService()).toObject(entry.getKey()), ((MapService)this.getService()).toObject(entry.getValue()));
                }
            }
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow(e);
        }
        return result;
    }

    protected void putAllInternal(Map<? extends Object, ? extends Object> entries) {
        NodeEngine nodeEngine = this.getNodeEngine();
        MapService mapService = (MapService)this.getService();
        int factor = 3;
        PartitionService partitionService = nodeEngine.getPartitionService();
        OperationService operationService = nodeEngine.getOperationService();
        int partitionCount = partitionService.getPartitionCount();
        boolean tooManyEntries = entries.size() > partitionCount * factor;
        try {
            if (tooManyEntries) {
                LinkedList<Future> flist = new LinkedList<Future>();
                HashMap<Integer, MapEntrySet> entryMap = new HashMap<Integer, MapEntrySet>();
                for (Map.Entry<? extends Object, ? extends Object> entry : entries.entrySet()) {
                    int partitionId = partitionService.getPartitionId(entry.getKey());
                    if (!entryMap.containsKey(partitionId)) {
                        entryMap.put(partitionId, new MapEntrySet());
                    }
                    ((MapEntrySet)entryMap.get(partitionId)).add(new AbstractMap.SimpleImmutableEntry<Data, Data>(mapService.toData(entry.getKey()), mapService.toData(entry.getValue())));
                }
                for (Integer partitionId : entryMap.keySet()) {
                    PutAllOperation op = new PutAllOperation(this.name, (MapEntrySet)entryMap.get(partitionId));
                    op.setPartitionId(partitionId);
                    flist.add(operationService.createInvocationBuilder("hz:impl:mapService", (Operation)op, partitionId).build().invoke());
                }
                for (Future future : flist) {
                    future.get();
                }
            } else {
                for (Map.Entry<? extends Object, ? extends Object> entry : entries.entrySet()) {
                    if (entry.getValue() == null) {
                        throw new NullPointerException(NULL_VALUE_IS_NOT_ALLOWED);
                    }
                    this.putInternal(mapService.toData(entry.getKey()), mapService.toData(entry.getValue()), -1L, TimeUnit.SECONDS);
                }
            }
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow(e);
        }
    }

    protected Set<Data> keySetInternal() {
        NodeEngine nodeEngine = this.getNodeEngine();
        try {
            Map<Integer, Object> results = nodeEngine.getOperationService().invokeOnAllPartitions("hz:impl:mapService", new BinaryOperationFactory(new MapKeySetOperation(this.name), nodeEngine));
            HashSet<Data> keySet = new HashSet<Data>();
            for (Object result : results.values()) {
                Set<Data> keys = ((MapKeySet)((MapService)this.getService()).toObject(result)).getKeySet();
                keySet.addAll(keys);
            }
            return keySet;
        }
        catch (Throwable t) {
            throw ExceptionUtil.rethrow(t);
        }
    }

    protected Set<Data> localKeySetInternal() {
        NodeEngine nodeEngine = this.getNodeEngine();
        try {
            Map<Integer, Object> results = nodeEngine.getOperationService().invokeOnTargetPartitions("hz:impl:mapService", new BinaryOperationFactory(new MapKeySetOperation(this.name), nodeEngine), nodeEngine.getThisAddress());
            HashSet<Data> keySet = new HashSet<Data>();
            for (Object result : results.values()) {
                Set<Data> keys = ((MapKeySet)((MapService)this.getService()).toObject(result)).getKeySet();
                keySet.addAll(keys);
            }
            return keySet;
        }
        catch (Throwable t) {
            throw ExceptionUtil.rethrow(t);
        }
    }

    public void flush() {
        NodeEngine nodeEngine = this.getNodeEngine();
        try {
            nodeEngine.getOperationService().invokeOnAllPartitions("hz:impl:mapService", new BinaryOperationFactory(new MapFlushOperation(this.name), nodeEngine));
        }
        catch (Throwable t) {
            throw ExceptionUtil.rethrow(t);
        }
    }

    protected Collection<Data> valuesInternal() {
        NodeEngine nodeEngine = this.getNodeEngine();
        try {
            Map<Integer, Object> results = nodeEngine.getOperationService().invokeOnAllPartitions("hz:impl:mapService", new BinaryOperationFactory(new MapValuesOperation(this.name), nodeEngine));
            ArrayList<Data> values = new ArrayList<Data>();
            for (Object result : results.values()) {
                values.addAll(((MapValueCollection)((MapService)this.getService()).toObject(result)).getValues());
            }
            return values;
        }
        catch (Throwable t) {
            throw ExceptionUtil.rethrow(t);
        }
    }

    public void clearInternal() {
        NodeEngine nodeEngine = this.getNodeEngine();
        try {
            ClearOperation clearOperation = new ClearOperation(this.name);
            clearOperation.setServiceName("hz:impl:mapService");
            nodeEngine.getOperationService().invokeOnAllPartitions("hz:impl:mapService", new BinaryOperationFactory(clearOperation, nodeEngine));
        }
        catch (Throwable t) {
            throw ExceptionUtil.rethrow(t);
        }
    }

    public String addMapInterceptorInternal(MapInterceptor interceptor) {
        NodeEngine nodeEngine = this.getNodeEngine();
        MapService mapService = (MapService)this.getService();
        String id = mapService.addInterceptor(this.name, interceptor);
        AddInterceptorOperation operation = new AddInterceptorOperation(id, interceptor, this.name);
        Collection<MemberImpl> members = nodeEngine.getClusterService().getMemberList();
        for (MemberImpl member : members) {
            try {
                if (member.localMember()) continue;
                Invocation invocation = nodeEngine.getOperationService().createInvocationBuilder("hz:impl:mapService", (Operation)operation, member.getAddress()).build();
                invocation.invoke().get();
            }
            catch (Throwable t) {
                throw ExceptionUtil.rethrow(t);
            }
        }
        return id;
    }

    public void removeMapInterceptorInternal(String id) {
        NodeEngine nodeEngine = this.getNodeEngine();
        MapService mapService = (MapService)this.getService();
        mapService.removeInterceptor(this.name, id);
        RemoveInterceptorOperation operation = new RemoveInterceptorOperation(this.name, id);
        Collection<MemberImpl> members = nodeEngine.getClusterService().getMemberList();
        for (MemberImpl member : members) {
            try {
                if (member.localMember()) continue;
                MemberImpl memberImpl = member;
                Invocation invocation = nodeEngine.getOperationService().createInvocationBuilder("hz:impl:mapService", (Operation)operation, memberImpl.getAddress()).build();
                invocation.invoke().get();
            }
            catch (Throwable t) {
                throw ExceptionUtil.rethrow(t);
            }
        }
    }

    public String addLocalEntryListener(EntryListener listener) {
        MapService mapService = (MapService)this.getService();
        return mapService.addLocalEventListener(listener, this.name);
    }

    protected String addEntryListenerInternal(EntryListener listener, Data key, boolean includeValue) {
        EntryEventFilter eventFilter = new EntryEventFilter(includeValue, key);
        MapService mapService = (MapService)this.getService();
        return mapService.addEventListener(listener, eventFilter, this.name);
    }

    protected String addEntryListenerInternal(EntryListener listener, Predicate predicate, Data key, boolean includeValue) {
        QueryEventFilter eventFilter = new QueryEventFilter(includeValue, key, predicate);
        MapService mapService = (MapService)this.getService();
        return mapService.addEventListener(listener, eventFilter, this.name);
    }

    protected boolean removeEntryListenerInternal(String id) {
        MapService mapService = (MapService)this.getService();
        return mapService.removeEventListener(this.name, id);
    }

    protected EntryView getEntryViewInternal(Data key) {
        NodeEngine nodeEngine = this.getNodeEngine();
        int partitionId = nodeEngine.getPartitionService().getPartitionId(key);
        GetEntryViewOperation getEntryViewOperation = new GetEntryViewOperation(this.name, key);
        getEntryViewOperation.setServiceName("hz:impl:mapService");
        try {
            Invocation invocation = nodeEngine.getOperationService().createInvocationBuilder("hz:impl:mapService", (Operation)getEntryViewOperation, partitionId).build();
            Future f = invocation.invoke();
            Object o = ((MapService)this.getService()).toObject(f.get());
            return (EntryView)o;
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    protected Set<Map.Entry<Data, Data>> entrySetInternal() {
        NodeEngine nodeEngine = this.getNodeEngine();
        try {
            Map<Integer, Object> results = nodeEngine.getOperationService().invokeOnAllPartitions("hz:impl:mapService", new BinaryOperationFactory(new MapEntrySetOperation(this.name), nodeEngine));
            HashSet<Map.Entry<Data, Data>> entrySet = new HashSet<Map.Entry<Data, Data>>();
            for (Object result : results.values()) {
                Set<Map.Entry<Data, Data>> entries = ((MapEntrySet)((MapService)this.getService()).toObject(result)).getEntrySet();
                if (entries == null) continue;
                entrySet.addAll(entries);
            }
            return entrySet;
        }
        catch (Throwable t) {
            throw ExceptionUtil.rethrow(t);
        }
    }

    public Data executeOnKeyInternal(Data key, EntryProcessor entryProcessor) {
        NodeEngine nodeEngine = this.getNodeEngine();
        int partitionId = nodeEngine.getPartitionService().getPartitionId(key);
        EntryOperation operation = new EntryOperation(this.name, key, entryProcessor);
        operation.setThreadId(ThreadUtil.getThreadId());
        try {
            Invocation invocation = nodeEngine.getOperationService().createInvocationBuilder("hz:impl:mapService", (Operation)operation, partitionId).build();
            Future future = invocation.invoke();
            return (Data)future.get();
        }
        catch (Throwable t) {
            throw ExceptionUtil.rethrow(t);
        }
    }

    public Map executeOnEntries(EntryProcessor entryProcessor) {
        HashMap<Object, Object> result = new HashMap<Object, Object>();
        try {
            NodeEngine nodeEngine = this.getNodeEngine();
            PartitionWideEntryOperation operation = new PartitionWideEntryOperation(this.name, entryProcessor);
            operation.setServiceName("hz:impl:mapService");
            Map<Integer, Object> results = nodeEngine.getOperationService().invokeOnAllPartitions("hz:impl:mapService", new BinaryOperationFactory(operation, nodeEngine));
            for (Object o : results.values()) {
                if (o == null) continue;
                MapService service = (MapService)this.getService();
                MapEntrySet mapEntrySet = (MapEntrySet)o;
                for (Map.Entry<Data, Data> entry : mapEntrySet.getEntrySet()) {
                    result.put(service.toObject(entry.getKey()), service.toObject(entry.getValue()));
                }
            }
        }
        catch (Throwable t) {
            throw ExceptionUtil.rethrow(t);
        }
        return result;
    }

    protected Set queryLocal(Predicate predicate, IterationType iterationType, boolean dataResult) {
        NodeEngine nodeEngine = this.getNodeEngine();
        OperationService operationService = nodeEngine.getOperationService();
        List<Integer> partitionIds = nodeEngine.getPartitionService().getMemberPartitions(nodeEngine.getThisAddress());
        QueryResultSet result = new QueryResultSet(nodeEngine.getSerializationService(), iterationType, dataResult);
        List<Object> returnedPartitionIds = new ArrayList();
        try {
            Invocation invocation = operationService.createInvocationBuilder("hz:impl:mapService", (Operation)new QueryOperation(this.name, predicate), nodeEngine.getThisAddress()).build();
            Future future = invocation.invoke();
            QueryResult queryResult = (QueryResult)future.get();
            if (queryResult != null) {
                returnedPartitionIds = queryResult.getPartitionIds();
                result.addAll(queryResult.getResult());
            }
            if (returnedPartitionIds.size() == partitionIds.size()) {
                return result;
            }
            ArrayList<Integer> missingList = new ArrayList<Integer>();
            for (Integer partitionId : partitionIds) {
                if (returnedPartitionIds.contains(partitionId)) continue;
                missingList.add(partitionId);
            }
            ArrayList<Future> futures = new ArrayList<Future>(missingList.size());
            for (Integer pid : missingList) {
                QueryPartitionOperation queryPartitionOperation = new QueryPartitionOperation(this.name, predicate);
                queryPartitionOperation.setPartitionId(pid);
                try {
                    Future f = operationService.createInvocationBuilder("hz:impl:mapService", (Operation)queryPartitionOperation, pid).build().invoke();
                    futures.add(f);
                }
                catch (Throwable t) {
                    throw ExceptionUtil.rethrow(t);
                }
            }
            for (Future f : futures) {
                QueryResult qResult = (QueryResult)f.get();
                result.addAll(qResult.getResult());
            }
        }
        catch (Throwable t) {
            throw ExceptionUtil.rethrow(t);
        }
        return result;
    }

    protected Set query(Predicate predicate, IterationType iterationType, boolean dataResult) {
        NodeEngine nodeEngine = this.getNodeEngine();
        OperationService operationService = nodeEngine.getOperationService();
        Collection<MemberImpl> members = nodeEngine.getClusterService().getMemberList();
        int partitionCount = nodeEngine.getPartitionService().getPartitionCount();
        HashSet<Integer> plist = new HashSet<Integer>(partitionCount);
        QueryResultSet result = new QueryResultSet(nodeEngine.getSerializationService(), iterationType, dataResult);
        try {
            ArrayList<Future> flist = new ArrayList<Future>();
            for (MemberImpl member : members) {
                Invocation invocation = operationService.createInvocationBuilder("hz:impl:mapService", (Operation)new QueryOperation(this.name, predicate), member.getAddress()).build();
                Future future = invocation.invoke();
                flist.add(future);
            }
            for (Future future : flist) {
                List<Integer> partitionIds;
                QueryResult queryResult = (QueryResult)future.get();
                if (queryResult == null || (partitionIds = queryResult.getPartitionIds()) == null) continue;
                plist.addAll(partitionIds);
                result.addAll(queryResult.getResult());
            }
            if (plist.size() == partitionCount) {
                return result;
            }
            ArrayList<Integer> missingList = new ArrayList<Integer>();
            for (int i = 0; i < partitionCount; ++i) {
                if (plist.contains(i)) continue;
                missingList.add(i);
            }
            ArrayList<Future> futures = new ArrayList<Future>(missingList.size());
            for (Integer pid : missingList) {
                QueryPartitionOperation queryPartitionOperation = new QueryPartitionOperation(this.name, predicate);
                queryPartitionOperation.setPartitionId(pid);
                try {
                    Future f = operationService.createInvocationBuilder("hz:impl:mapService", (Operation)queryPartitionOperation, pid).build().invoke();
                    futures.add(f);
                }
                catch (Throwable t) {
                    throw ExceptionUtil.rethrow(t);
                }
            }
            for (Future future : futures) {
                QueryResult queryResult = (QueryResult)future.get();
                result.addAll(queryResult.getResult());
            }
        }
        catch (Throwable t) {
            throw ExceptionUtil.rethrow(t);
        }
        return result;
    }

    public void addIndex(String attribute, boolean ordered) {
        NodeEngine nodeEngine = this.getNodeEngine();
        if (attribute == null) {
            throw new IllegalArgumentException("attribute name cannot be null");
        }
        try {
            AddIndexOperation addIndexOperation = new AddIndexOperation(this.name, attribute, ordered);
            Map<Integer, Object> results = nodeEngine.getOperationService().invokeOnAllPartitions("hz:impl:mapService", new BinaryOperationFactory(addIndexOperation, nodeEngine));
        }
        catch (Throwable t) {
            throw ExceptionUtil.rethrow(t);
        }
    }

    public LocalMapStats getLocalMapStats() {
        return ((MapService)this.getService()).createLocalMapStats(this.name);
    }

    protected long getTimeInMillis(long time, TimeUnit timeunit) {
        return timeunit != null ? timeunit.toMillis(time) : time;
    }

    @Override
    public final Object getId() {
        return this.name;
    }

    @Override
    public final String getName() {
        return this.name;
    }

    @Override
    public final String getServiceName() {
        return "hz:impl:mapService";
    }
}

