/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jmx;

import com.hazelcast.core.ISet;
import com.hazelcast.core.ItemEvent;
import com.hazelcast.core.ItemListener;
import com.hazelcast.jmx.HazelcastMBean;
import com.hazelcast.jmx.ManagedAnnotation;
import com.hazelcast.jmx.ManagedDescription;
import com.hazelcast.jmx.ManagementService;
import java.util.concurrent.atomic.AtomicLong;

public class SetMBean
extends HazelcastMBean<ISet> {
    private AtomicLong totalAddedItemCount = new AtomicLong();
    private AtomicLong totalRemovedItemCount = new AtomicLong();

    protected SetMBean(ISet managedObject, ManagementService service) {
        super(managedObject, service);
        this.objectName = this.createObjectName("Set", managedObject.getName());
        ItemListener itemListener = new ItemListener(){

            public void itemAdded(ItemEvent item) {
                SetMBean.this.totalAddedItemCount.incrementAndGet();
            }

            public void itemRemoved(ItemEvent item) {
                SetMBean.this.totalRemovedItemCount.incrementAndGet();
            }
        };
    }

    @ManagedAnnotation(value="clear", operation=true)
    @ManagedDescription(value="Clear List")
    public void clear() {
        ((ISet)this.managedObject).clear();
    }

    @ManagedAnnotation(value="name")
    @ManagedDescription(value="Name of the DistributedObject")
    public String getName() {
        return ((ISet)this.managedObject).getName();
    }

    @ManagedAnnotation(value="totalAddedItemCount")
    public long getTotalAddedItemCount() {
        return this.totalAddedItemCount.get();
    }

    @ManagedAnnotation(value="totalRemovedItemCount")
    public long getTotalRemovedItemCount() {
        return this.totalRemovedItemCount.get();
    }

    @Override
    public void preDeregister() throws Exception {
        super.preDeregister();
    }
}

