/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jmx;

import com.hazelcast.config.Config;
import com.hazelcast.core.Cluster;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.Member;
import com.hazelcast.jmx.HazelcastMBean;
import com.hazelcast.jmx.ManagedAnnotation;
import com.hazelcast.jmx.ManagedDescription;
import com.hazelcast.jmx.ManagementService;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

@ManagedDescription(value="HazelcastInstance")
public class InstanceMBean
extends HazelcastMBean<HazelcastInstance> {
    final Config config;
    final Cluster cluster;

    protected InstanceMBean(HazelcastInstance managedObject, ManagementService service) {
        super(managedObject, service);
        this.objectName = this.createObjectName(null, null);
        this.config = managedObject.getConfig();
        this.cluster = managedObject.getCluster();
    }

    @ManagedAnnotation(value="name")
    @ManagedDescription(value="Name of the Instance")
    public String getName() {
        return ((HazelcastInstance)this.managedObject).getName();
    }

    @ManagedAnnotation(value="config")
    @ManagedDescription(value="String representation of config")
    public String getConfig() {
        return this.config.toString();
    }

    @ManagedAnnotation(value="configSource")
    @ManagedDescription(value="The source of config")
    public String getConfigSource() {
        File configurationFile = this.config.getConfigurationFile();
        if (configurationFile != null) {
            return configurationFile.getAbsolutePath();
        }
        URL configurationUrl = this.config.getConfigurationUrl();
        if (configurationUrl != null) {
            return configurationUrl.toString();
        }
        return null;
    }

    @ManagedAnnotation(value="groupName")
    @ManagedDescription(value="Group Name")
    public String getGroupName() {
        return this.config.getGroupConfig().getName();
    }

    @ManagedAnnotation(value="port")
    @ManagedDescription(value="Network Port")
    public int getPort() {
        return this.config.getNetworkConfig().getPort();
    }

    @ManagedAnnotation(value="clusterTime")
    @ManagedDescription(value="Cluster-wide Time")
    public long getClusterTime() {
        return this.cluster.getClusterTime();
    }

    @ManagedAnnotation(value="memberCount")
    @ManagedDescription(value="size of the cluster")
    public int getMemberCount() {
        return this.cluster.getMembers().size();
    }

    @ManagedAnnotation(value="Members")
    @ManagedDescription(value="List of Members")
    public List<String> getMembers() {
        Set<Member> members = this.cluster.getMembers();
        ArrayList<String> list = new ArrayList<String>(members.size());
        for (Member member : members) {
            list.add(member.getInetSocketAddress().toString());
        }
        return list;
    }

    @ManagedAnnotation(value="running")
    @ManagedDescription(value="Running state")
    public boolean isRunning() {
        return ((HazelcastInstance)this.managedObject).getLifecycleService().isRunning();
    }

    @ManagedAnnotation(value="shutdown", operation=true)
    @ManagedDescription(value="Shutdown the Node")
    public void shutdown() {
        ((HazelcastInstance)this.managedObject).getLifecycleService().shutdown();
    }
}

