/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jmx;

import com.hazelcast.core.IQueue;
import com.hazelcast.core.ItemEvent;
import com.hazelcast.core.ItemListener;
import com.hazelcast.jmx.HazelcastMBean;
import com.hazelcast.jmx.ManagedAnnotation;
import com.hazelcast.jmx.ManagedDescription;
import com.hazelcast.jmx.ManagementService;
import java.util.concurrent.atomic.AtomicLong;

@ManagedDescription(value="IQueue")
public class QueueMBean
extends HazelcastMBean<IQueue> {
    private AtomicLong totalAddedItemCount = new AtomicLong();
    private AtomicLong totalRemovedItemCount = new AtomicLong();
    private final String registrationId;

    protected QueueMBean(IQueue managedObject, ManagementService service) {
        super(managedObject, service);
        this.objectName = service.createObjectName("IQueue", managedObject.getName());
        ItemListener itemListener = new ItemListener(){

            public void itemAdded(ItemEvent item) {
                QueueMBean.this.totalAddedItemCount.incrementAndGet();
            }

            public void itemRemoved(ItemEvent item) {
                QueueMBean.this.totalRemovedItemCount.incrementAndGet();
            }
        };
        this.registrationId = managedObject.addItemListener(itemListener, false);
    }

    @ManagedAnnotation(value="name")
    @ManagedDescription(value="Name of the DistributedObject")
    public String getName() {
        return ((IQueue)this.managedObject).getName();
    }

    @ManagedAnnotation(value="config")
    @ManagedDescription(value="QueueConfig")
    public String getConfig() {
        return this.service.instance.getConfig().getQueueConfig(((IQueue)this.managedObject).getName()).toString();
    }

    @ManagedAnnotation(value="clear", operation=true)
    @ManagedDescription(value="Clear Queue")
    public void clear() {
        ((IQueue)this.managedObject).clear();
    }

    @ManagedAnnotation(value="totalAddedItemCount")
    public long getTotalAddedItemCount() {
        return this.totalAddedItemCount.get();
    }

    @ManagedAnnotation(value="totalRemovedItemCount")
    public long getTotalRemovedItemCount() {
        return this.totalRemovedItemCount.get();
    }

    @Override
    public void preDeregister() throws Exception {
        super.preDeregister();
        try {
            ((IQueue)this.managedObject).removeItemListener(this.registrationId);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

