/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.collection.multimap.tx;

import com.hazelcast.collection.CollectionContainer;
import com.hazelcast.collection.CollectionProxyId;
import com.hazelcast.collection.multimap.tx.TxnPrepareBackupOperation;
import com.hazelcast.collection.operations.CollectionBackupAwareOperation;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.spi.Operation;
import com.hazelcast.transaction.TransactionException;
import java.io.IOException;

public class TxnPrepareOperation
extends CollectionBackupAwareOperation {
    long ttl;

    public TxnPrepareOperation() {
    }

    public TxnPrepareOperation(CollectionProxyId proxyId, Data dataKey, long ttl, int threadId) {
        super(proxyId, dataKey, threadId);
        this.ttl = ttl;
    }

    @Override
    public void run() throws Exception {
        CollectionContainer container = this.getOrCreateContainer();
        if (!container.extendLock(this.dataKey, this.getCallerUuid(), this.threadId, 10000L)) {
            throw new TransactionException("Lock is not owned by the transaction! -> " + container.getLockOwnerInfo(this.dataKey));
        }
        this.response = true;
    }

    @Override
    public boolean shouldBackup() {
        return true;
    }

    @Override
    public boolean shouldWait() {
        return false;
    }

    @Override
    public Operation getBackupOperation() {
        return new TxnPrepareBackupOperation(this.proxyId, this.dataKey, this.getCallerUuid(), this.threadId);
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeLong(this.ttl);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.ttl = in.readLong();
    }

    @Override
    public int getId() {
        return 32;
    }
}

