/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map;

import com.hazelcast.config.MapConfig;
import com.hazelcast.config.MapStoreConfig;
import com.hazelcast.config.WanReplicationRef;
import com.hazelcast.core.MapLoader;
import com.hazelcast.core.MapLoaderLifecycleSupport;
import com.hazelcast.core.MapStoreFactory;
import com.hazelcast.instance.MemberImpl;
import com.hazelcast.map.EvictionProcessor;
import com.hazelcast.map.MapInterceptor;
import com.hazelcast.map.MapService;
import com.hazelcast.map.MapStoreDeleteProcessor;
import com.hazelcast.map.MapStoreWrapper;
import com.hazelcast.map.MapStoreWriteProcessor;
import com.hazelcast.map.merge.MapMergePolicy;
import com.hazelcast.map.operation.MapInitialLoadOperation;
import com.hazelcast.map.operation.MapIsReadyOperation;
import com.hazelcast.map.operation.PutFromLoadOperation;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.ClassLoaderUtil;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.query.impl.IndexService;
import com.hazelcast.spi.Invocation;
import com.hazelcast.spi.NodeEngine;
import com.hazelcast.spi.Operation;
import com.hazelcast.spi.OperationAccessor;
import com.hazelcast.spi.ResponseHandler;
import com.hazelcast.util.ExceptionUtil;
import com.hazelcast.util.scheduler.EntryTaskScheduler;
import com.hazelcast.util.scheduler.EntryTaskSchedulerFactory;
import com.hazelcast.util.scheduler.ScheduleType;
import com.hazelcast.wan.WanReplicationPublisher;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

public class MapContainer {
    private final String name;
    private final MapConfig mapConfig;
    private final MapService mapService;
    private final MapStoreWrapper storeWrapper;
    private final List<MapInterceptor> interceptors;
    private final Map<String, MapInterceptor> interceptorMap;
    private final IndexService indexService = new IndexService();
    private final boolean nearCacheEnabled;
    private final AtomicBoolean initialLoaded = new AtomicBoolean(false);
    private final EntryTaskScheduler idleEvictionScheduler;
    private final EntryTaskScheduler ttlEvictionScheduler;
    private final EntryTaskScheduler mapStoreWriteScheduler;
    private final EntryTaskScheduler mapStoreDeleteScheduler;
    private final WanReplicationPublisher wanReplicationPublisher;
    private final MapMergePolicy wanMergePolicy;
    private volatile boolean mapReady = false;

    public MapContainer(String name, MapConfig mapConfig, MapService mapService) {
        MapLoader store = null;
        this.name = name;
        this.mapConfig = mapConfig;
        this.mapService = mapService;
        MapStoreConfig mapStoreConfig = mapConfig.getMapStoreConfig();
        NodeEngine nodeEngine = mapService.getNodeEngine();
        if (mapStoreConfig != null) {
            try {
                String factoryClassName;
                MapStoreFactory factory = (MapStoreFactory)mapStoreConfig.getFactoryImplementation();
                if (factory == null && (factoryClassName = mapStoreConfig.getFactoryClassName()) != null && !"".equals(factoryClassName)) {
                    factory = (MapStoreFactory)ClassLoaderUtil.newInstance(nodeEngine.getConfigClassLoader(), factoryClassName);
                }
                MapLoader mapLoader = store = factory == null ? mapStoreConfig.getImplementation() : factory.newMapStore(name, mapStoreConfig.getProperties());
                if (store == null) {
                    String mapStoreClassName = mapStoreConfig.getClassName();
                    store = ClassLoaderUtil.newInstance(nodeEngine.getConfigClassLoader(), mapStoreClassName);
                }
            }
            catch (Exception e) {
                throw ExceptionUtil.rethrow(e);
            }
            this.storeWrapper = new MapStoreWrapper(store, mapConfig.getName(), mapStoreConfig.isEnabled());
        } else {
            this.storeWrapper = null;
        }
        if (this.storeWrapper != null) {
            if (store instanceof MapLoaderLifecycleSupport) {
                ((MapLoaderLifecycleSupport)((Object)store)).init(nodeEngine.getHazelcastInstance(), mapStoreConfig.getProperties(), name);
            }
            if (nodeEngine.getClusterService().isMaster() && this.initialLoaded.compareAndSet(false, true)) {
                this.loadMapFromStore(true);
                Collection<MemberImpl> members = nodeEngine.getClusterService().getMemberList();
                for (MemberImpl member : members) {
                    try {
                        if (member.localMember()) continue;
                        MemberImpl memberImpl = member;
                        Invocation invocation = nodeEngine.getOperationService().createInvocationBuilder("hz:impl:mapService", (Operation)new MapInitialLoadOperation(name), memberImpl.getAddress()).build();
                        invocation.invoke();
                    }
                    catch (Throwable t) {
                        throw ExceptionUtil.rethrow(t);
                    }
                }
            } else {
                try {
                    Invocation invocation = nodeEngine.getOperationService().createInvocationBuilder("hz:impl:mapService", (Operation)new MapIsReadyOperation(name), nodeEngine.getMasterAddress()).build();
                    Future future = invocation.invoke();
                    this.mapReady = (Boolean)future.get();
                    while (!this.mapReady) {
                        Thread.sleep(1000L);
                        invocation = nodeEngine.getOperationService().createInvocationBuilder("hz:impl:mapService", (Operation)new MapIsReadyOperation(name), nodeEngine.getMasterAddress()).build();
                        future = invocation.invoke();
                        boolean temp = (Boolean)future.get();
                        if (this.mapReady) continue;
                        this.mapReady = temp;
                    }
                }
                catch (Exception e) {
                    throw ExceptionUtil.rethrow(e);
                }
            }
            if (mapStoreConfig.getWriteDelaySeconds() > 0) {
                this.mapStoreWriteScheduler = EntryTaskSchedulerFactory.newScheduler(nodeEngine.getExecutionService().getScheduledExecutor(), new MapStoreWriteProcessor(this, mapService), ScheduleType.FOR_EACH);
                this.mapStoreDeleteScheduler = EntryTaskSchedulerFactory.newScheduler(nodeEngine.getExecutionService().getScheduledExecutor(), new MapStoreDeleteProcessor(this, mapService), ScheduleType.SCHEDULE_IF_NEW);
            } else {
                this.mapStoreDeleteScheduler = null;
                this.mapStoreWriteScheduler = null;
            }
        } else {
            this.mapReady = true;
            this.mapStoreDeleteScheduler = null;
            this.mapStoreWriteScheduler = null;
        }
        this.ttlEvictionScheduler = EntryTaskSchedulerFactory.newScheduler(nodeEngine.getExecutionService().getScheduledExecutor(), new EvictionProcessor(nodeEngine, mapService, name), ScheduleType.POSTPONE);
        this.idleEvictionScheduler = EntryTaskSchedulerFactory.newScheduler(nodeEngine.getExecutionService().getScheduledExecutor(), new EvictionProcessor(nodeEngine, mapService, name), ScheduleType.POSTPONE);
        WanReplicationRef wanReplicationRef = mapConfig.getWanReplicationRef();
        if (wanReplicationRef != null) {
            this.wanReplicationPublisher = nodeEngine.getWanReplicationService().getWanReplicationListener(wanReplicationRef.getName());
            this.wanMergePolicy = mapService.getMergePolicy(wanReplicationRef.getMergePolicy());
        } else {
            this.wanMergePolicy = null;
            this.wanReplicationPublisher = null;
        }
        this.interceptors = new CopyOnWriteArrayList<MapInterceptor>();
        this.interceptorMap = new ConcurrentHashMap<String, MapInterceptor>();
        this.nearCacheEnabled = mapConfig.getNearCacheConfig() != null;
    }

    public boolean isMapReady() {
        return this.mapReady;
    }

    public void loadMapFromStore(boolean force) {
        if (force || this.initialLoaded.compareAndSet(false, true)) {
            this.mapReady = false;
            NodeEngine nodeEngine = this.mapService.getNodeEngine();
            int chunkSize = nodeEngine.getGroupProperties().MAP_LOAD_CHUNK_SIZE.getInteger();
            Set keys = this.storeWrapper.loadAllKeys();
            if (keys == null || keys.isEmpty()) {
                this.mapReady = true;
                return;
            }
            HashMap chunk = new HashMap();
            ArrayList chunkList = new ArrayList();
            for (Object key : keys) {
                Data dataKey = this.mapService.toData(key);
                int n = nodeEngine.getPartitionService().getPartitionId(dataKey);
                Address partitionOwner = nodeEngine.getPartitionService().getPartitionOwner(n);
                while (partitionOwner == null) {
                    partitionOwner = nodeEngine.getPartitionService().getPartitionOwner(n);
                    try {
                        Thread.sleep(10L);
                    }
                    catch (InterruptedException e) {
                        throw ExceptionUtil.rethrow(e);
                    }
                }
                if (!partitionOwner.equals(nodeEngine.getClusterService().getThisAddress())) continue;
                chunk.put(dataKey, key);
                if (chunk.size() < chunkSize) continue;
                chunkList.add(chunk);
                chunk = new HashMap();
            }
            if (chunk.size() > 0) {
                chunkList.add(chunk);
            }
            int numberOfChunks = chunkList.size();
            AtomicInteger counter = new AtomicInteger(numberOfChunks);
            for (Map map : chunkList) {
                try {
                    nodeEngine.getExecutionService().submit("hz:map-load", new MapLoadAllTask(map, counter));
                }
                catch (Throwable t) {
                    ExceptionUtil.rethrow(t);
                }
            }
        }
    }

    public EntryTaskScheduler getIdleEvictionScheduler() {
        return this.idleEvictionScheduler;
    }

    public EntryTaskScheduler getTtlEvictionScheduler() {
        return this.ttlEvictionScheduler;
    }

    public EntryTaskScheduler getMapStoreWriteScheduler() {
        return this.mapStoreWriteScheduler;
    }

    public EntryTaskScheduler getMapStoreDeleteScheduler() {
        return this.mapStoreDeleteScheduler;
    }

    public IndexService getIndexService() {
        return this.indexService;
    }

    public WanReplicationPublisher getWanReplicationPublisher() {
        return this.wanReplicationPublisher;
    }

    public MapMergePolicy getWanMergePolicy() {
        return this.wanMergePolicy;
    }

    public String addInterceptor(MapInterceptor interceptor) {
        String id = UUID.randomUUID().toString();
        this.interceptorMap.put(id, interceptor);
        this.interceptors.add(interceptor);
        return id;
    }

    public void addInterceptor(String id, MapInterceptor interceptor) {
        this.interceptorMap.put(id, interceptor);
        this.interceptors.add(interceptor);
    }

    public List<MapInterceptor> getInterceptors() {
        return this.interceptors;
    }

    public Map<String, MapInterceptor> getInterceptorMap() {
        return this.interceptorMap;
    }

    public void removeInterceptor(String id) {
        MapInterceptor interceptor = this.interceptorMap.remove(id);
        this.interceptors.remove(interceptor);
    }

    public String getName() {
        return this.name;
    }

    public boolean isNearCacheEnabled() {
        return this.nearCacheEnabled;
    }

    public int getTotalBackupCount() {
        return this.getBackupCount() + this.getAsyncBackupCount();
    }

    public int getBackupCount() {
        return this.mapConfig.getBackupCount();
    }

    public long getWriteDelayMillis() {
        return this.mapConfig.getMapStoreConfig().getWriteDelaySeconds() * 1000;
    }

    public int getAsyncBackupCount() {
        return this.mapConfig.getAsyncBackupCount();
    }

    public MapConfig getMapConfig() {
        return this.mapConfig;
    }

    public MapStoreWrapper getStore() {
        return this.storeWrapper;
    }

    private class MapLoadAllTask
    implements Runnable {
        private Map<Data, Object> keys;
        private AtomicInteger counter;

        private MapLoadAllTask(Map<Data, Object> keys, AtomicInteger counter) {
            this.keys = keys;
            this.counter = counter;
        }

        @Override
        public void run() {
            NodeEngine nodeEngine = MapContainer.this.mapService.getNodeEngine();
            Map values = MapContainer.this.storeWrapper.loadAll(this.keys.values());
            final CountDownLatch latch = new CountDownLatch(this.keys.size());
            for (Data dataKey : this.keys.keySet()) {
                Object key = this.keys.get(dataKey);
                Data dataValue = MapContainer.this.mapService.toData(values.get(key));
                int partitionId = nodeEngine.getPartitionService().getPartitionId(dataKey);
                PutFromLoadOperation operation = new PutFromLoadOperation(MapContainer.this.name, dataKey, dataValue, -1L);
                operation.setNodeEngine(nodeEngine);
                operation.setResponseHandler(new ResponseHandler(){

                    @Override
                    public void sendResponse(Object obj) {
                        latch.countDown();
                    }
                });
                operation.setPartitionId(partitionId);
                OperationAccessor.setCallerAddress(operation, nodeEngine.getThisAddress());
                operation.setServiceName("hz:impl:mapService");
                nodeEngine.getOperationService().executeOperation(operation);
            }
            try {
                if (latch.await(30L, TimeUnit.SECONDS) && this.counter.decrementAndGet() <= 0) {
                    MapContainer.this.mapReady = true;
                }
            }
            catch (InterruptedException e) {
                throw ExceptionUtil.rethrow(e);
            }
        }
    }
}

