/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.concurrent.semaphore;

import com.hazelcast.concurrent.semaphore.AcquireOperation;
import com.hazelcast.concurrent.semaphore.AvailableOperation;
import com.hazelcast.concurrent.semaphore.DrainOperation;
import com.hazelcast.concurrent.semaphore.InitOperation;
import com.hazelcast.concurrent.semaphore.ReduceOperation;
import com.hazelcast.concurrent.semaphore.ReleaseOperation;
import com.hazelcast.concurrent.semaphore.SemaphoreOperation;
import com.hazelcast.concurrent.semaphore.SemaphoreService;
import com.hazelcast.core.ISemaphore;
import com.hazelcast.spi.AbstractDistributedObject;
import com.hazelcast.spi.Invocation;
import com.hazelcast.spi.NodeEngine;
import com.hazelcast.spi.Operation;
import com.hazelcast.util.ExceptionUtil;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;

public class SemaphoreProxy
extends AbstractDistributedObject<SemaphoreService>
implements ISemaphore {
    final String name;
    final int partitionId;

    public SemaphoreProxy(String name, SemaphoreService service, NodeEngine nodeEngine) {
        super(nodeEngine, service);
        this.name = name;
        this.partitionId = nodeEngine.getPartitionService().getPartitionId(nodeEngine.toData(name));
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean init(int permits) {
        this.checkNegative(permits);
        try {
            return (Boolean)this.invoke(new InitOperation(this.name, permits));
        }
        catch (Throwable t) {
            throw ExceptionUtil.rethrow(t);
        }
    }

    @Override
    public void acquire() throws InterruptedException {
        this.acquire(1);
    }

    @Override
    public void acquire(int permits) throws InterruptedException {
        this.checkNegative(permits);
        try {
            this.invoke(new AcquireOperation(this.name, permits, -1L));
        }
        catch (Throwable t) {
            throw ExceptionUtil.rethrowAllowInterrupted(t);
        }
    }

    @Override
    public int availablePermits() {
        try {
            return (Integer)this.invoke(new AvailableOperation(this.name));
        }
        catch (Throwable t) {
            throw ExceptionUtil.rethrow(t);
        }
    }

    @Override
    public int drainPermits() {
        try {
            return (Integer)this.invoke(new DrainOperation(this.name));
        }
        catch (Throwable t) {
            throw ExceptionUtil.rethrow(t);
        }
    }

    @Override
    public void reducePermits(int reduction) {
        this.checkNegative(reduction);
        try {
            this.invoke(new ReduceOperation(this.name, reduction));
        }
        catch (Throwable t) {
            throw ExceptionUtil.rethrow(t);
        }
    }

    @Override
    public void release() {
        this.release(1);
    }

    @Override
    public void release(int permits) {
        this.checkNegative(permits);
        try {
            this.invoke(new ReleaseOperation(this.name, permits));
        }
        catch (Throwable t) {
            throw ExceptionUtil.rethrow(t);
        }
    }

    @Override
    public boolean tryAcquire() {
        try {
            return this.tryAcquire(1, 0L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            return false;
        }
    }

    @Override
    public boolean tryAcquire(int permits) {
        try {
            return this.tryAcquire(permits, 0L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            return false;
        }
    }

    @Override
    public boolean tryAcquire(long timeout, TimeUnit unit) throws InterruptedException {
        return this.tryAcquire(1, timeout, unit);
    }

    @Override
    public boolean tryAcquire(int permits, long timeout, TimeUnit unit) throws InterruptedException {
        this.checkNegative(permits);
        try {
            return (Boolean)this.invoke(new AcquireOperation(this.name, permits, unit.toMillis(timeout)));
        }
        catch (Throwable t) {
            throw ExceptionUtil.rethrowAllowInterrupted(t);
        }
    }

    @Override
    public Object getId() {
        return this.name;
    }

    private <T> T invoke(SemaphoreOperation operation) throws ExecutionException, InterruptedException {
        NodeEngine nodeEngine = this.getNodeEngine();
        Invocation inv = nodeEngine.getOperationService().createInvocationBuilder("hz:impl:semaphoreService", (Operation)operation, this.partitionId).build();
        Future f = inv.invoke();
        return nodeEngine.toObject(f.get());
    }

    private void checkNegative(int permits) {
        if (permits < 0) {
            throw new IllegalArgumentException("Permits cannot be negative!");
        }
    }

    @Override
    public String getServiceName() {
        return "hz:impl:semaphoreService";
    }
}

