/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.collection.operations.client;

import com.hazelcast.collection.operations.client.TxnMultiMapRequest;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.PortableReader;
import com.hazelcast.nio.serialization.PortableWriter;
import com.hazelcast.transaction.TransactionContext;
import java.io.IOException;

public class TxnMultiMapPutRequest
extends TxnMultiMapRequest {
    Data key;
    Data value;

    public TxnMultiMapPutRequest() {
    }

    public TxnMultiMapPutRequest(String name, Data key, Data value) {
        super(name);
        this.key = key;
        this.value = value;
    }

    public Object call() throws Exception {
        TransactionContext context = this.getEndpoint().getTransactionContext();
        return context.getMultiMap(this.name).put(this.key, this.value);
    }

    @Override
    public int getClassId() {
        return 27;
    }

    @Override
    public void writePortable(PortableWriter writer) throws IOException {
        super.writePortable(writer);
        ObjectDataOutput out = writer.getRawDataOutput();
        this.key.writeData(out);
        this.value.writeData(out);
    }

    @Override
    public void readPortable(PortableReader reader) throws IOException {
        super.readPortable(reader);
        ObjectDataInput in = reader.getRawDataInput();
        this.key = new Data();
        this.key.readData(in);
        this.value = new Data();
        this.value.readData(in);
    }
}

