/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.collection.multimap.tx;

import com.hazelcast.collection.CollectionContainer;
import com.hazelcast.collection.CollectionProxyId;
import com.hazelcast.collection.CollectionRecord;
import com.hazelcast.collection.CollectionService;
import com.hazelcast.collection.CollectionWrapper;
import com.hazelcast.collection.operations.CollectionKeyBasedOperation;
import com.hazelcast.core.EntryEventType;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.util.Clock;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;

public class TxnRemoveOperation
extends CollectionKeyBasedOperation {
    long recordId;
    Data value;
    transient long begin = -1L;

    public TxnRemoveOperation() {
    }

    public TxnRemoveOperation(CollectionProxyId proxyId, Data dataKey, long recordId, Data value) {
        super(proxyId, dataKey);
        this.recordId = recordId;
        this.value = value;
    }

    @Override
    public void run() throws Exception {
        this.begin = Clock.currentTimeMillis();
        CollectionContainer container = this.getOrCreateContainer();
        CollectionWrapper wrapper = container.getCollectionWrapper(this.dataKey);
        this.response = true;
        if (wrapper == null || !wrapper.containsRecordId(this.recordId)) {
            this.response = false;
            return;
        }
        Collection<CollectionRecord> coll = wrapper.getCollection();
        Iterator<CollectionRecord> iter = coll.iterator();
        while (iter.hasNext()) {
            if (iter.next().getRecordId() != this.recordId) continue;
            iter.remove();
            break;
        }
        if (coll.isEmpty()) {
            this.removeCollection();
        }
    }

    @Override
    public void afterRun() throws Exception {
        long elapsed = Math.max(0L, Clock.currentTimeMillis() - this.begin);
        CollectionService service = (CollectionService)this.getService();
        service.getLocalMultiMapStatsImpl(this.proxyId).incrementRemoves(elapsed);
        if (Boolean.TRUE.equals(this.response)) {
            this.getOrCreateContainer().update();
            this.publishEvent(EntryEventType.REMOVED, this.dataKey, this.value);
        }
    }

    public long getRecordId() {
        return this.recordId;
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeLong(this.recordId);
        this.value.writeData(out);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.recordId = in.readLong();
        this.value = new Data();
        this.value.readData(in);
    }

    @Override
    public int getId() {
        return 35;
    }
}

