/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.transaction;

import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.DataSerializable;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public final class TransactionOptions
implements DataSerializable {
    private long timeoutMillis;
    private int durability;
    private TransactionType transactionType;

    public TransactionOptions() {
        this.setTimeout(2L, TimeUnit.MINUTES).setDurability(1).setTransactionType(TransactionType.TWO_PHASE);
    }

    public TransactionType getTransactionType() {
        return this.transactionType;
    }

    public TransactionOptions setTransactionType(TransactionType transactionType) {
        this.transactionType = transactionType;
        return this;
    }

    public long getTimeoutMillis() {
        return this.timeoutMillis;
    }

    public TransactionOptions setTimeout(long timeout, TimeUnit timeUnit) {
        if (timeout <= 0L) {
            throw new IllegalArgumentException("Timeout must be positive!");
        }
        this.timeoutMillis = timeUnit.toMillis(timeout);
        return this;
    }

    public int getDurability() {
        return this.durability;
    }

    public TransactionOptions setDurability(int durability) {
        if (durability < 0) {
            throw new IllegalArgumentException("Durability cannot be negative!");
        }
        this.durability = durability;
        return this;
    }

    public static TransactionOptions getDefault() {
        return new TransactionOptions();
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeLong(this.timeoutMillis);
        out.writeInt(this.durability);
        out.writeInt(this.transactionType.value);
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.timeoutMillis = in.readLong();
        this.durability = in.readInt();
        this.transactionType = TransactionType.getByValue(in.readInt());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("TransactionOptions");
        sb.append("{timeoutMillis=").append(this.timeoutMillis);
        sb.append(", durability=").append(this.durability);
        sb.append(", txType=").append(this.transactionType.value);
        sb.append('}');
        return sb.toString();
    }

    public static enum TransactionType {
        TWO_PHASE(1),
        LOCAL(2);

        private final int value;

        private TransactionType(int value) {
            this.value = value;
        }

        public static TransactionType getByValue(int value) {
            for (TransactionType type : TransactionType.values()) {
                if (type.value != value) continue;
                return type;
            }
            return TWO_PHASE;
        }
    }
}

