/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.topic.proxy;

import com.hazelcast.config.ListenerConfig;
import com.hazelcast.config.TopicConfig;
import com.hazelcast.core.HazelcastInstanceAware;
import com.hazelcast.core.MessageListener;
import com.hazelcast.monitor.LocalTopicStats;
import com.hazelcast.nio.ClassLoaderUtil;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.spi.AbstractDistributedObject;
import com.hazelcast.spi.NodeEngine;
import com.hazelcast.topic.TopicEvent;
import com.hazelcast.topic.TopicService;
import com.hazelcast.util.ExceptionUtil;
import java.util.List;

abstract class TopicProxySupport
extends AbstractDistributedObject<TopicService> {
    private final String name;

    TopicProxySupport(String name, NodeEngine nodeEngine, TopicService service) {
        super(nodeEngine, service);
        this.name = name;
        this.initializeListeners(nodeEngine);
    }

    private void initializeListeners(NodeEngine nodeEngine) {
        TopicConfig config = nodeEngine.getConfig().getTopicConfig(this.name);
        List<ListenerConfig> messageListenerConfigs = config.getMessageListenerConfigs();
        for (ListenerConfig listenerConfig : messageListenerConfigs) {
            MessageListener listener;
            try {
                listener = (MessageListener)listenerConfig.getImplementation();
                if (listener == null && listenerConfig.getClassName() != null) {
                    listener = (MessageListener)ClassLoaderUtil.newInstance(nodeEngine.getConfigClassLoader(), listenerConfig.getClassName());
                }
            }
            catch (Exception e) {
                throw ExceptionUtil.rethrow(e);
            }
            if (listener == null) continue;
            if (listener instanceof HazelcastInstanceAware) {
                ((HazelcastInstanceAware)((Object)listener)).setHazelcastInstance(nodeEngine.getHazelcastInstance());
            }
            this.addMessageListenerInternal(listener);
        }
    }

    public LocalTopicStats getLocalTopicStatsInternal() {
        return ((TopicService)this.getService()).getLocalTopicStats(this.name);
    }

    public void publishInternal(Data message) {
        TopicEvent topicEvent = new TopicEvent(this.name, message, this.getNodeEngine().getLocalMember());
        ((TopicService)this.getService()).getLocalTopicStats(this.name).incrementPublishes();
        ((TopicService)this.getService()).publishEvent(this.name, topicEvent);
    }

    public String addMessageListenerInternal(MessageListener listener) {
        return ((TopicService)this.getService()).addMessageListener(this.name, listener);
    }

    public boolean removeMessageListenerInternal(String registrationId) {
        return ((TopicService)this.getService()).removeMessageListener(this.name, registrationId);
    }

    @Override
    public String getServiceName() {
        return "hz:impl:topicService";
    }

    @Override
    public Object getId() {
        return this.name;
    }

    @Override
    public String getName() {
        return this.name;
    }
}

