/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.spi.impl;

import com.hazelcast.core.MemberLeftException;
import com.hazelcast.instance.MemberImpl;
import com.hazelcast.nio.Address;
import com.hazelcast.spi.Callback;

final class RemoteCall {
    private final Address target;
    private final String uuid;
    private final Callback<Object> callback;

    RemoteCall(Address target, Callback<Object> callback) {
        this.target = target;
        this.callback = callback;
        this.uuid = null;
    }

    RemoteCall(MemberImpl target, Callback<Object> callback) {
        this.target = target.getAddress();
        this.uuid = target.getUuid();
        this.callback = callback;
    }

    void offerResponse(Object response) {
        this.callback.notify(response);
    }

    void onMemberLeft(MemberImpl leftMember) {
        boolean notify = this.uuid != null ? leftMember.getUuid().equals(this.uuid) : leftMember.getAddress().equals(this.target);
        if (notify) {
            this.callback.notify(new MemberLeftException(leftMember));
        }
    }

    public String toString() {
        return "RemoteCall{target=" + this.target + ", callback=" + this.callback + '}';
    }
}

