/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.spi.impl;

import com.hazelcast.core.DistributedObject;
import com.hazelcast.core.DistributedObjectEvent;
import com.hazelcast.core.DistributedObjectListener;
import com.hazelcast.core.HazelcastInstanceNotActiveException;
import com.hazelcast.instance.MemberImpl;
import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.spi.AbstractDistributedObject;
import com.hazelcast.spi.AbstractOperation;
import com.hazelcast.spi.DistributedObjectAccessor;
import com.hazelcast.spi.EventPublishingService;
import com.hazelcast.spi.EventRegistration;
import com.hazelcast.spi.EventService;
import com.hazelcast.spi.Invocation;
import com.hazelcast.spi.Operation;
import com.hazelcast.spi.ProxyService;
import com.hazelcast.spi.RemoteService;
import com.hazelcast.spi.exception.DistributedObjectDestroyedException;
import com.hazelcast.spi.impl.DistributedObjectEventImpl;
import com.hazelcast.spi.impl.NodeEngineImpl;
import com.hazelcast.util.ConcurrencyUtil;
import com.hazelcast.util.ConstructorFunction;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;

public class ProxyServiceImpl
implements ProxyService,
EventPublishingService<DistributedObjectEvent, Object> {
    static final String SERVICE_NAME = "hz:core:proxyService";
    private final NodeEngineImpl nodeEngine;
    private final ConcurrentMap<String, ProxyRegistry> registries = new ConcurrentHashMap<String, ProxyRegistry>();
    private final ConcurrentMap<String, DistributedObjectListener> listeners = new ConcurrentHashMap<String, DistributedObjectListener>();
    private final ILogger logger;
    private final ConstructorFunction<String, ProxyRegistry> registryConstructor = new ConstructorFunction<String, ProxyRegistry>(){

        @Override
        public ProxyRegistry createNew(String serviceName) {
            return new ProxyRegistry(serviceName);
        }
    };

    ProxyServiceImpl(NodeEngineImpl nodeEngine) {
        this.nodeEngine = nodeEngine;
        this.logger = nodeEngine.getLogger(ProxyService.class.getName());
    }

    void init() {
        this.nodeEngine.getEventService().registerListener(SERVICE_NAME, SERVICE_NAME, new Object());
    }

    @Override
    public void initializeDistributedObject(String serviceName, Object objectId) {
        if (serviceName == null) {
            throw new NullPointerException("Service name is required!");
        }
        if (objectId == null) {
            throw new NullPointerException("Object id is required!");
        }
        this.getDistributedObject(serviceName, objectId);
    }

    @Override
    public DistributedObject getDistributedObject(String serviceName, Object objectId) {
        if (serviceName == null) {
            throw new NullPointerException("Service name is required!");
        }
        if (objectId == null) {
            throw new NullPointerException("Object id is required!");
        }
        ProxyRegistry registry = ConcurrencyUtil.getOrPutIfAbsent(this.registries, serviceName, this.registryConstructor);
        return registry.getProxy(objectId);
    }

    @Override
    public void destroyDistributedObject(String serviceName, Object objectId) {
        if (serviceName == null) {
            throw new NullPointerException("Service name is required!");
        }
        if (objectId == null) {
            throw new NullPointerException("Object id is required!");
        }
        Collection<MemberImpl> members = this.nodeEngine.getClusterService().getMemberList();
        ArrayList<Future> calls = new ArrayList<Future>(members.size());
        for (MemberImpl member : members) {
            if (member.localMember()) continue;
            Invocation inv = this.nodeEngine.getOperationService().createInvocationBuilder(SERVICE_NAME, (Operation)new DistributedObjectDestroyOperation(serviceName, objectId), member.getAddress()).setTryCount(10).build();
            calls.add(inv.invoke());
        }
        this.destroyLocalDistributedObject(serviceName, objectId);
        for (Future f : calls) {
            try {
                f.get(3L, TimeUnit.SECONDS);
            }
            catch (Exception e) {
                this.logger.log(Level.FINEST, e.getMessage(), e);
            }
        }
        ProxyRegistry registry = (ProxyRegistry)this.registries.get(serviceName);
        if (registry != null) {
            registry.destroyProxy(objectId);
        }
    }

    private void destroyLocalDistributedObject(String serviceName, Object objectId) {
        RemoteService service = (RemoteService)this.nodeEngine.getService(serviceName);
        if (service != null) {
            service.destroyDistributedObject(objectId);
        }
        this.nodeEngine.waitNotifyService.cancelWaitingOps(serviceName, objectId, new DistributedObjectDestroyedException(serviceName, objectId));
    }

    @Override
    public Collection<DistributedObject> getDistributedObjects(String serviceName) {
        if (serviceName == null) {
            throw new NullPointerException("Service name is required!");
        }
        LinkedList<DistributedObject> objects = new LinkedList<DistributedObject>();
        ProxyRegistry registry = (ProxyRegistry)this.registries.get(serviceName);
        if (registry != null) {
            objects.addAll(registry.proxies.values());
        }
        return objects;
    }

    @Override
    public Collection<DistributedObject> getAllDistributedObjects() {
        LinkedList<DistributedObject> objects = new LinkedList<DistributedObject>();
        for (ProxyRegistry registry : this.registries.values()) {
            objects.addAll(registry.proxies.values());
        }
        return objects;
    }

    @Override
    public String addProxyListener(DistributedObjectListener distributedObjectListener) {
        String id = UUID.randomUUID().toString();
        this.listeners.put(id, distributedObjectListener);
        return id;
    }

    @Override
    public boolean removeProxyListener(String registrationId) {
        return this.listeners.remove(registrationId) != null;
    }

    @Override
    public void dispatchEvent(final DistributedObjectEvent event, Object ignore) {
        block4: {
            String serviceName;
            block3: {
                serviceName = event.getServiceName();
                if (event.getEventType() != DistributedObjectEvent.EventType.CREATED) break block3;
                final ProxyRegistry registry = ConcurrencyUtil.getOrPutIfAbsent(this.registries, serviceName, this.registryConstructor);
                this.nodeEngine.getExecutionService().execute("hz:system", new Runnable(){

                    @Override
                    public void run() {
                        try {
                            registry.getProxy(event.getObjectId());
                        }
                        catch (HazelcastInstanceNotActiveException hazelcastInstanceNotActiveException) {
                            // empty catch block
                        }
                    }
                });
                if (registry.contains(event.getObjectId())) break block4;
                for (DistributedObjectListener listener : this.listeners.values()) {
                    listener.distributedObjectCreated(event);
                }
                break block4;
            }
            ProxyRegistry registry = (ProxyRegistry)this.registries.get(serviceName);
            if (registry != null) {
                registry.removeProxy(event.getObjectId());
            }
            for (DistributedObjectListener listener : this.listeners.values()) {
                listener.distributedObjectDestroyed(event);
            }
        }
    }

    void shutdown() {
        for (ProxyRegistry registry : this.registries.values()) {
            registry.destroy();
        }
        this.registries.clear();
        this.listeners.clear();
    }

    public static class DistributedObjectDestroyOperation
    extends AbstractOperation {
        private String serviceName;
        private Object objectId;

        public DistributedObjectDestroyOperation() {
        }

        public DistributedObjectDestroyOperation(String serviceName, Object objectId) {
            this.serviceName = serviceName;
            this.objectId = objectId;
        }

        @Override
        public void run() throws Exception {
            ProxyServiceImpl proxyService = (ProxyServiceImpl)this.getService();
            ProxyRegistry registry = (ProxyRegistry)proxyService.registries.get(this.serviceName);
            if (registry != null) {
                registry.removeProxy(this.objectId);
            }
            proxyService.destroyLocalDistributedObject(this.serviceName, this.objectId);
        }

        @Override
        public boolean returnsResponse() {
            return true;
        }

        @Override
        public Object getResponse() {
            return Boolean.TRUE;
        }

        @Override
        protected void writeInternal(ObjectDataOutput out) throws IOException {
            super.writeInternal(out);
            out.writeUTF(this.serviceName);
            out.writeObject(this.objectId);
        }

        @Override
        protected void readInternal(ObjectDataInput in) throws IOException {
            super.readInternal(in);
            this.serviceName = in.readUTF();
            this.objectId = in.readObject();
        }
    }

    private class ProxyRegistry {
        final String serviceName;
        final RemoteService service;
        final ConcurrentMap<Object, DistributedObject> proxies = new ConcurrentHashMap<Object, DistributedObject>();

        private ProxyRegistry(String serviceName) {
            this.serviceName = serviceName;
            this.service = (RemoteService)ProxyServiceImpl.this.nodeEngine.getService(serviceName);
            if (this.service == null) {
                if (ProxyServiceImpl.this.nodeEngine.isActive()) {
                    throw new IllegalArgumentException("Unknown service: " + serviceName);
                }
                throw new HazelcastInstanceNotActiveException();
            }
        }

        DistributedObject getProxy(Object objectId) {
            DistributedObject proxy = (DistributedObject)this.proxies.get(objectId);
            if (proxy == null) {
                if (!ProxyServiceImpl.this.nodeEngine.isActive()) {
                    throw new HazelcastInstanceNotActiveException();
                }
                proxy = this.service.createDistributedObject(objectId);
                DistributedObject current = this.proxies.putIfAbsent(objectId, proxy);
                if (current == null) {
                    final DistributedObjectEvent event = this.createEvent(objectId, DistributedObjectEvent.EventType.CREATED);
                    this.publish(event);
                    ((ProxyServiceImpl)ProxyServiceImpl.this).nodeEngine.eventService.executeEvent(new Runnable(){

                        @Override
                        public void run() {
                            for (DistributedObjectListener listener : ProxyServiceImpl.this.listeners.values()) {
                                listener.distributedObjectCreated(event);
                            }
                        }
                    });
                } else {
                    proxy = current;
                }
            }
            return proxy;
        }

        void destroyProxy(Object objectId) {
            if (this.proxies.remove(objectId) != null) {
                DistributedObjectEvent event = this.createEvent(objectId, DistributedObjectEvent.EventType.DESTROYED);
                this.publish(event);
            }
        }

        void removeProxy(Object objectId) {
            this.proxies.remove(objectId);
        }

        private void publish(DistributedObjectEvent event) {
            EventService eventService = ProxyServiceImpl.this.nodeEngine.getEventService();
            Collection<EventRegistration> registrations = eventService.getRegistrations(ProxyServiceImpl.SERVICE_NAME, ProxyServiceImpl.SERVICE_NAME);
            eventService.publishEvent(ProxyServiceImpl.SERVICE_NAME, registrations, (Object)event);
        }

        private DistributedObjectEvent createEvent(Object objectId, DistributedObjectEvent.EventType type) {
            DistributedObjectEventImpl event = new DistributedObjectEventImpl(type, this.serviceName, objectId);
            event.setHazelcastInstance(((ProxyServiceImpl)ProxyServiceImpl.this).nodeEngine.getNode().hazelcastInstance);
            return event;
        }

        private boolean contains(Object objectId) {
            return this.proxies.containsKey(objectId);
        }

        void destroy() {
            for (DistributedObject distributedObject : this.proxies.values()) {
                if (!(distributedObject instanceof AbstractDistributedObject)) continue;
                DistributedObjectAccessor.onNodeShutdown((AbstractDistributedObject)distributedObject);
            }
            this.proxies.clear();
        }
    }
}

