/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.spi.impl;

import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.partition.PartitionServiceImpl;
import com.hazelcast.partition.PartitionView;
import com.hazelcast.partition.ReplicaErrorLogger;
import com.hazelcast.spi.BackupOperation;
import com.hazelcast.spi.NodeEngine;
import com.hazelcast.spi.Operation;
import com.hazelcast.spi.OperationAccessor;
import com.hazelcast.spi.OperationService;
import com.hazelcast.spi.ResponseHandler;
import com.hazelcast.spi.exception.RetryableException;
import com.hazelcast.spi.impl.BackupResponse;
import com.hazelcast.spi.impl.NodeEngineImpl;
import com.hazelcast.spi.impl.OperationServiceImpl;
import com.hazelcast.spi.impl.SpiDataSerializerHook;
import com.hazelcast.util.Clock;
import java.io.IOException;
import java.util.Arrays;
import java.util.logging.Level;

final class Backup
extends Operation
implements BackupOperation,
IdentifiedDataSerializable {
    private Operation backupOp;
    private Address originalCaller;
    private long[] replicaVersions;
    private boolean sync;
    private transient boolean valid = true;

    Backup() {
    }

    Backup(Operation backupOp, Address originalCaller, long[] replicaVersions, boolean sync) {
        this.backupOp = backupOp;
        this.originalCaller = originalCaller;
        this.sync = sync;
        this.replicaVersions = replicaVersions;
        if (sync && originalCaller == null) {
            throw new IllegalArgumentException("Sync backup requires original caller address, Op: " + backupOp);
        }
    }

    @Override
    public void beforeRun() throws Exception {
        NodeEngine nodeEngine = this.getNodeEngine();
        int partitionId = this.getPartitionId();
        PartitionView partition = nodeEngine.getPartitionService().getPartition(partitionId);
        Address owner = partition.getReplicaAddress(this.getReplicaIndex());
        if (!nodeEngine.getThisAddress().equals(owner)) {
            this.valid = false;
            ILogger logger = this.getLogger();
            Level level = Level.INFO;
            if (owner == null) {
                level = Level.FINEST;
            }
            logger.log(level, "Wrong target! " + this.toString() + " cannot be processed! Target should be: " + owner);
        }
    }

    @Override
    public void run() throws Exception {
        if (this.valid) {
            final NodeEngine nodeEngine = this.getNodeEngine();
            PartitionServiceImpl partitionService = (PartitionServiceImpl)nodeEngine.getPartitionService();
            partitionService.updatePartitionReplicaVersions(this.getPartitionId(), this.replicaVersions, this.getReplicaIndex());
            if (this.backupOp != null) {
                this.backupOp.setNodeEngine(nodeEngine);
                this.backupOp.setResponseHandler(new ResponseHandler(){

                    @Override
                    public void sendResponse(Object obj) {
                        if (obj instanceof Throwable && !(obj instanceof RetryableException)) {
                            Throwable t = (Throwable)obj;
                            nodeEngine.getLogger(this.getClass()).log(Level.SEVERE, t.getMessage(), t);
                        }
                    }
                });
                this.backupOp.setCallerUuid(this.getCallerUuid());
                OperationAccessor.setCallerAddress(this.backupOp, this.getCallerAddress());
                OperationAccessor.setInvocationTime(this.backupOp, Clock.currentTimeMillis());
                OperationService operationService = nodeEngine.getOperationService();
                operationService.runOperation(this.backupOp);
            }
        }
    }

    @Override
    public void afterRun() throws Exception {
        if (this.sync && this.getCallId() != 0L && this.originalCaller != null) {
            NodeEngineImpl nodeEngine = (NodeEngineImpl)this.getNodeEngine();
            long callId = this.getCallId();
            OperationServiceImpl operationService = nodeEngine.operationService;
            if (!nodeEngine.getThisAddress().equals(this.originalCaller)) {
                BackupResponse backupResponse = new BackupResponse();
                OperationAccessor.setCallId(backupResponse, callId);
                operationService.send((Operation)backupResponse, this.originalCaller);
            } else {
                operationService.notifyBackupCall(callId);
            }
        }
    }

    @Override
    public final boolean returnsResponse() {
        return false;
    }

    @Override
    public Object getResponse() {
        return null;
    }

    @Override
    public boolean validatesTarget() {
        return false;
    }

    @Override
    public void logError(Throwable e) {
        ReplicaErrorLogger.log(e, this.getLogger());
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        out.writeObject(this.backupOp);
        if (this.originalCaller != null) {
            out.writeBoolean(true);
            this.originalCaller.writeData(out);
        } else {
            out.writeBoolean(false);
        }
        out.writeLongArray(this.replicaVersions);
        out.writeBoolean(this.sync);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        this.backupOp = (Operation)in.readObject();
        if (in.readBoolean()) {
            this.originalCaller = new Address();
            this.originalCaller.readData(in);
        }
        this.replicaVersions = in.readLongArray();
        this.sync = in.readBoolean();
    }

    @Override
    public int getFactoryId() {
        return SpiDataSerializerHook.F_ID;
    }

    @Override
    public int getId() {
        return 1;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Backup");
        sb.append("{backupOp=").append(this.backupOp);
        sb.append(", originalCaller=").append(this.originalCaller);
        sb.append(", version=").append(Arrays.toString(this.replicaVersions));
        sb.append(", sync=").append(this.sync);
        sb.append('}');
        return sb.toString();
    }
}

