/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.nio.serialization;

import com.hazelcast.nio.BufferObjectDataInput;
import com.hazelcast.nio.BufferObjectDataOutput;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.ClassDefinition;
import com.hazelcast.nio.serialization.ClassDefinitionBuilder;
import com.hazelcast.nio.serialization.DefaultPortableReader;
import com.hazelcast.nio.serialization.DefaultPortableWriter;
import com.hazelcast.nio.serialization.EmptyObjectDataOutput;
import com.hazelcast.nio.serialization.HazelcastSerializationException;
import com.hazelcast.nio.serialization.MorphingPortableReader;
import com.hazelcast.nio.serialization.Portable;
import com.hazelcast.nio.serialization.PortableContextAwareInputStream;
import com.hazelcast.nio.serialization.PortableFactory;
import com.hazelcast.nio.serialization.PortableWriter;
import com.hazelcast.nio.serialization.SerializationConstants;
import com.hazelcast.nio.serialization.SerializationContext;
import com.hazelcast.nio.serialization.StreamSerializer;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

final class PortableSerializer
implements StreamSerializer<Portable> {
    private final SerializationContext context;
    private final Map<Integer, PortableFactory> factories = new HashMap<Integer, PortableFactory>();

    PortableSerializer(SerializationContext context, Map<Integer, ? extends PortableFactory> portableFactories) {
        this.context = context;
        this.factories.putAll(portableFactories);
    }

    @Override
    public int getTypeId() {
        return SerializationConstants.CONSTANT_TYPE_PORTABLE;
    }

    @Override
    public void write(ObjectDataOutput out, Portable p) throws IOException {
        if (p.getClassId() == 0) {
            throw new IllegalArgumentException("Portable class id cannot be zero!");
        }
        this.write(out, p, p.getClassId());
    }

    void write(ObjectDataOutput out, Portable p, int classId) throws IOException {
        if (!(out instanceof BufferObjectDataOutput)) {
            throw new IllegalArgumentException("ObjectDataOutput must be instance of BufferObjectDataOutput!");
        }
        if (classId == 0) {
            throw new IllegalArgumentException("Portable class id cannot be zero!");
        }
        ClassDefinition cd = this.getClassDefinition(p, classId);
        DefaultPortableWriter writer = new DefaultPortableWriter(this, (BufferObjectDataOutput)out, cd);
        p.writePortable(writer);
    }

    private ClassDefinition getClassDefinition(Portable p, int classId) throws IOException {
        ClassDefinition cd = this.context.lookup(p.getFactoryId(), classId);
        if (cd == null) {
            ClassDefinitionWriter classDefinitionWriter = new ClassDefinitionWriter(p.getFactoryId(), classId);
            p.writePortable(classDefinitionWriter);
            cd = classDefinitionWriter.registerAndGet();
        }
        return cd;
    }

    @Override
    public Portable read(ObjectDataInput in) throws IOException {
        DefaultPortableReader reader;
        if (!(in instanceof BufferObjectDataInput)) {
            throw new IllegalArgumentException("ObjectDataInput must be instance of BufferObjectDataInput!");
        }
        if (!(in instanceof PortableContextAwareInputStream)) {
            throw new IllegalArgumentException("ObjectDataInput must be instance of PortableContextAwareInputStream!");
        }
        PortableContextAwareInputStream ctxIn = (PortableContextAwareInputStream)((Object)in);
        int factoryId = ctxIn.getFactoryId();
        int dataClassId = ctxIn.getDataClassId();
        int dataVersion = ctxIn.getDataVersion();
        PortableFactory portableFactory = this.factories.get(factoryId);
        if (portableFactory == null) {
            throw new HazelcastSerializationException("Could not find PortableFactory for factoryId: " + factoryId);
        }
        Portable portable = portableFactory.create(dataClassId);
        if (portable == null) {
            throw new HazelcastSerializationException("Could not create Portable for class-id: " + dataClassId);
        }
        if (this.context.getVersion() == dataVersion) {
            ClassDefinition cd = this.context.lookup(factoryId, dataClassId);
            reader = new DefaultPortableReader(this, (BufferObjectDataInput)in, cd);
        } else {
            ClassDefinition cd = this.context.lookup(factoryId, dataClassId, dataVersion);
            reader = new MorphingPortableReader(this, (BufferObjectDataInput)in, cd);
        }
        portable.readPortable(reader);
        return portable;
    }

    @Override
    public void destroy() {
        this.factories.clear();
    }

    private class ClassDefinitionWriter
    implements PortableWriter {
        final ClassDefinitionBuilder builder;

        ClassDefinitionWriter(int factoryId, int classId) {
            this.builder = new ClassDefinitionBuilder(factoryId, classId);
        }

        private ClassDefinitionWriter(ClassDefinitionBuilder builder) {
            this.builder = builder;
        }

        @Override
        public int getVersion() {
            return PortableSerializer.this.context.getVersion();
        }

        @Override
        public void writeInt(String fieldName, int value) {
            this.builder.addIntField(fieldName);
        }

        @Override
        public void writeLong(String fieldName, long value) {
            this.builder.addLongField(fieldName);
        }

        @Override
        public void writeUTF(String fieldName, String str) {
            this.builder.addUTFField(fieldName);
        }

        @Override
        public void writeBoolean(String fieldName, boolean value) throws IOException {
            this.builder.addBooleanField(fieldName);
        }

        @Override
        public void writeByte(String fieldName, byte value) throws IOException {
            this.builder.addByteField(fieldName);
        }

        @Override
        public void writeChar(String fieldName, int value) throws IOException {
            this.builder.addCharField(fieldName);
        }

        @Override
        public void writeDouble(String fieldName, double value) throws IOException {
            this.builder.addDoubleField(fieldName);
        }

        @Override
        public void writeFloat(String fieldName, float value) throws IOException {
            this.builder.addFloatField(fieldName);
        }

        @Override
        public void writeShort(String fieldName, short value) throws IOException {
            this.builder.addShortField(fieldName);
        }

        @Override
        public void writeByteArray(String fieldName, byte[] bytes) throws IOException {
            this.builder.addByteArrayField(fieldName);
        }

        @Override
        public void writeCharArray(String fieldName, char[] chars) throws IOException {
            this.builder.addCharArrayField(fieldName);
        }

        @Override
        public void writeIntArray(String fieldName, int[] ints) throws IOException {
            this.builder.addIntArrayField(fieldName);
        }

        @Override
        public void writeLongArray(String fieldName, long[] longs) throws IOException {
            this.builder.addLongArrayField(fieldName);
        }

        @Override
        public void writeDoubleArray(String fieldName, double[] values) throws IOException {
            this.builder.addDoubleArrayField(fieldName);
        }

        @Override
        public void writeFloatArray(String fieldName, float[] values) throws IOException {
            this.builder.addFloatArrayField(fieldName);
        }

        @Override
        public void writeShortArray(String fieldName, short[] values) throws IOException {
            this.builder.addShortArrayField(fieldName);
        }

        @Override
        public void writePortable(String fieldName, Portable portable) throws IOException {
            if (portable == null) {
                throw new HazelcastSerializationException("Cannot write null portable without explicitly registering class definition!");
            }
            this.writePortable(fieldName, portable.getFactoryId(), portable.getClassId(), portable);
        }

        private void writePortable(String fieldName, int factoryId, int classId, Portable portable) throws IOException {
            ClassDefinition nestedClassDef;
            if (portable != null) {
                nestedClassDef = this.createNestedClassDef(portable, new ClassDefinitionBuilder(factoryId, classId));
            } else {
                nestedClassDef = PortableSerializer.this.context.lookup(factoryId, classId);
                if (nestedClassDef == null) {
                    throw new HazelcastSerializationException("Cannot write null portable without explicitly registering class definition!");
                }
            }
            this.builder.addPortableField(fieldName, nestedClassDef);
        }

        @Override
        public void writeNullPortable(String fieldName, int factoryId, int classId) throws IOException {
            this.writePortable(fieldName, factoryId, classId, null);
        }

        @Override
        public void writePortableArray(String fieldName, Portable[] portables) throws IOException {
            if (portables == null || portables.length == 0) {
                throw new HazelcastSerializationException("Cannot write null portable array without explicitly registering class definition!");
            }
            Portable p = portables[0];
            int classId = p.getClassId();
            for (int i = 1; i < portables.length; ++i) {
                if (portables[i].getClassId() == classId) continue;
                throw new IllegalArgumentException("Detected different class-ids in portable array!");
            }
            ClassDefinition nestedClassDef = this.createNestedClassDef(p, new ClassDefinitionBuilder(p.getFactoryId(), classId));
            this.builder.addPortableArrayField(fieldName, nestedClassDef);
        }

        @Override
        public ObjectDataOutput getRawDataOutput() {
            return new EmptyObjectDataOutput();
        }

        private ClassDefinition createNestedClassDef(Portable portable, ClassDefinitionBuilder nestedBuilder) throws IOException {
            ClassDefinitionWriter nestedWriter = new ClassDefinitionWriter(nestedBuilder);
            portable.writePortable(nestedWriter);
            return PortableSerializer.this.context.registerClassDefinition(nestedBuilder.build());
        }

        ClassDefinition registerAndGet() {
            ClassDefinition cd = this.builder.build();
            return PortableSerializer.this.context.registerClassDefinition(cd);
        }
    }
}

