/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.nio.serialization;

import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.BinaryClassDefinition;
import com.hazelcast.nio.serialization.ClassDefinition;
import com.hazelcast.nio.serialization.FieldDefinition;
import com.hazelcast.nio.serialization.FieldDefinitionImpl;
import com.hazelcast.nio.serialization.FieldType;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ClassDefinitionImpl
extends BinaryClassDefinition
implements ClassDefinition {
    private List<FieldDefinition> fieldDefinitions = new ArrayList<FieldDefinition>();
    private Map<String, FieldDefinition> fieldDefinitionsMap = new HashMap<String, FieldDefinition>();
    private Set<ClassDefinition> nestedClassDefinitions = new HashSet<ClassDefinition>();

    public ClassDefinitionImpl() {
    }

    public ClassDefinitionImpl(int factoryId, int classId) {
        this.factoryId = factoryId;
        this.classId = classId;
    }

    public void addFieldDef(FieldDefinition fd) {
        this.fieldDefinitions.add(fd);
        this.fieldDefinitionsMap.put(fd.getName(), fd);
    }

    public void addClassDef(ClassDefinition cd) {
        this.nestedClassDefinitions.add(cd);
    }

    @Override
    public FieldDefinition get(String name) {
        return this.fieldDefinitionsMap.get(name);
    }

    @Override
    public FieldDefinition get(int fieldIndex) {
        return this.fieldDefinitions.get(fieldIndex);
    }

    public Set<ClassDefinition> getNestedClassDefinitions() {
        return this.nestedClassDefinitions;
    }

    @Override
    public boolean hasField(String fieldName) {
        return this.fieldDefinitionsMap.containsKey(fieldName);
    }

    @Override
    public Set<String> getFieldNames() {
        return new HashSet<String>(this.fieldDefinitionsMap.keySet());
    }

    @Override
    public FieldType getFieldType(String fieldName) {
        FieldDefinition fd = this.get(fieldName);
        if (fd != null) {
            return fd.getType();
        }
        throw new IllegalArgumentException();
    }

    @Override
    public int getFieldClassId(String fieldName) {
        FieldDefinition fd = this.get(fieldName);
        if (fd != null) {
            return fd.getClassId();
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeInt(this.factoryId);
        out.writeInt(this.classId);
        out.writeInt(this.version);
        out.writeInt(this.fieldDefinitions.size());
        for (FieldDefinition fieldDefinition : this.fieldDefinitions) {
            fieldDefinition.writeData(out);
        }
        out.writeInt(this.nestedClassDefinitions.size());
        for (ClassDefinition classDefinition : this.nestedClassDefinitions) {
            classDefinition.writeData(out);
        }
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        int i;
        this.factoryId = in.readInt();
        this.classId = in.readInt();
        this.version = in.readInt();
        int size = in.readInt();
        for (i = 0; i < size; ++i) {
            FieldDefinitionImpl fieldDefinition = new FieldDefinitionImpl();
            fieldDefinition.readData(in);
            this.addFieldDef(fieldDefinition);
        }
        size = in.readInt();
        for (i = 0; i < size; ++i) {
            ClassDefinitionImpl classDefinition = new ClassDefinitionImpl();
            classDefinition.readData(in);
            this.addClassDef(classDefinition);
        }
    }

    @Override
    public int getFieldCount() {
        return this.fieldDefinitions.size();
    }

    @Override
    public int getClassId() {
        return this.classId;
    }

    @Override
    public int getVersion() {
        return this.version;
    }

    void setBinary(byte[] binary) {
        this.binary = binary;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClassDefinitionImpl that = (ClassDefinitionImpl)o;
        if (this.classId != that.classId) {
            return false;
        }
        return this.version == that.version;
    }

    public int hashCode() {
        int result = this.classId;
        result = 31 * result + this.version;
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ClassDefinition");
        sb.append("{classId=").append(this.classId);
        sb.append(", version=").append(this.version);
        sb.append(", fieldDefinitions=").append(this.fieldDefinitions);
        sb.append('}');
        return sb.toString();
    }
}

