/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.nio.serialization;

import com.hazelcast.nio.BufferObjectDataInput;
import com.hazelcast.nio.UTFUtil;
import com.hazelcast.nio.serialization.ClassDefinition;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.PortableContextAwareInputStream;
import com.hazelcast.nio.serialization.SerializationContext;
import com.hazelcast.nio.serialization.SerializationContextAware;
import com.hazelcast.nio.serialization.SerializationService;
import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteOrder;

class ByteArrayObjectDataInput
extends PortableContextAwareInputStream
implements BufferObjectDataInput,
SerializationContextAware {
    byte[] buffer;
    final int size;
    int pos = 0;
    int mark = 0;
    final SerializationService service;

    ByteArrayObjectDataInput(Data data, SerializationService service) {
        this(data.buffer, service);
        ClassDefinition cd = data.classDefinition;
        this.setFactoryId(cd != null ? cd.getFactoryId() : 0);
        this.setDataClassId(cd != null ? cd.getClassId() : -1);
        this.setDataVersion(cd != null ? cd.getVersion() : -1);
    }

    ByteArrayObjectDataInput(byte[] buffer, SerializationService service) {
        this.buffer = buffer;
        this.size = buffer.length;
        this.service = service;
    }

    @Override
    public int read() throws IOException {
        return this.pos < this.size ? this.buffer[this.pos++] & 0xFF : -1;
    }

    @Override
    public int read(int position) throws IOException {
        return position < this.size ? this.buffer[position] & 0xFF : -1;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || off > b.length || len < 0 || off + len > b.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len <= 0) {
            return 0;
        }
        if (this.pos >= this.size) {
            return -1;
        }
        if (this.pos + len > this.size) {
            len = this.size - this.pos;
        }
        System.arraycopy(this.buffer, this.pos, b, off, len);
        this.pos += len;
        return len;
    }

    @Override
    public boolean readBoolean() throws IOException {
        int ch = this.read();
        if (ch < 0) {
            throw new EOFException();
        }
        return ch != 0;
    }

    @Override
    public boolean readBoolean(int position) throws IOException {
        int ch = this.read(position);
        if (ch < 0) {
            throw new EOFException();
        }
        return ch != 0;
    }

    @Override
    public byte readByte() throws IOException {
        int ch = this.read();
        if (ch < 0) {
            throw new EOFException();
        }
        return (byte)ch;
    }

    @Override
    public byte readByte(int position) throws IOException {
        int ch = this.read(position);
        if (ch < 0) {
            throw new EOFException();
        }
        return (byte)ch;
    }

    @Override
    public char readChar() throws IOException {
        char c = this.readChar(this.pos);
        this.pos += 2;
        return c;
    }

    @Override
    public char readChar(int position) throws IOException {
        int ch2;
        int ch1 = this.read(position);
        if ((ch1 | (ch2 = this.read(position + 1))) < 0) {
            throw new EOFException();
        }
        return (char)((ch1 << 8) + (ch2 << 0));
    }

    @Override
    public double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readLong());
    }

    @Override
    public double readDouble(int position) throws IOException {
        return Double.longBitsToDouble(this.readLong(position));
    }

    @Override
    public float readFloat() throws IOException {
        return Float.intBitsToFloat(this.readInt());
    }

    @Override
    public float readFloat(int position) throws IOException {
        return Float.intBitsToFloat(this.readInt(position));
    }

    @Override
    public void readFully(byte[] b) throws IOException {
        this.read(b);
    }

    @Override
    public void readFully(byte[] b, int off, int len) throws IOException {
        this.read(b, off, len);
    }

    @Override
    public int readInt() throws IOException {
        int i = this.readInt(this.pos);
        this.pos += 4;
        return i;
    }

    @Override
    public int readInt(int position) throws IOException {
        int ch4;
        int ch3;
        int ch2;
        int ch1 = this.read(position);
        if ((ch1 | (ch2 = this.read(position + 1)) | (ch3 = this.read(position + 2)) | (ch4 = this.read(position + 3))) < 0) {
            throw new EOFException();
        }
        return (ch1 << 24) + (ch2 << 16) + (ch3 << 8) + (ch4 << 0);
    }

    @Override
    @Deprecated
    public String readLine() throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public long readLong() throws IOException {
        long l = this.readLong(this.pos);
        this.pos += 8;
        return l;
    }

    @Override
    public long readLong(int position) throws IOException {
        return ((long)this.buffer[position] << 56) + ((long)(this.buffer[position + 1] & 0xFF) << 48) + ((long)(this.buffer[position + 2] & 0xFF) << 40) + ((long)(this.buffer[position + 3] & 0xFF) << 32) + ((long)(this.buffer[position + 4] & 0xFF) << 24) + (long)((this.buffer[position + 5] & 0xFF) << 16) + (long)((this.buffer[position + 6] & 0xFF) << 8) + (long)((this.buffer[position + 7] & 0xFF) << 0);
    }

    @Override
    public short readShort() throws IOException {
        int ch2;
        int ch1 = this.read();
        if ((ch1 | (ch2 = this.read())) < 0) {
            throw new EOFException();
        }
        return (short)((ch1 << 8) + (ch2 << 0));
    }

    @Override
    public short readShort(int position) throws IOException {
        int ch2;
        int ch1 = this.read(position);
        if ((ch1 | (ch2 = this.read(position + 1))) < 0) {
            throw new EOFException();
        }
        return (short)((ch1 << 8) + (ch2 << 0));
    }

    @Override
    public char[] readCharArray() throws IOException {
        int len = this.readInt();
        if (len > 0) {
            char[] values = new char[len];
            for (int i = 0; i < len; ++i) {
                values[i] = this.readChar();
            }
            return values;
        }
        return new char[0];
    }

    @Override
    public int[] readIntArray() throws IOException {
        int len = this.readInt();
        if (len > 0) {
            int[] values = new int[len];
            for (int i = 0; i < len; ++i) {
                values[i] = this.readInt();
            }
            return values;
        }
        return new int[0];
    }

    @Override
    public long[] readLongArray() throws IOException {
        int len = this.readInt();
        if (len > 0) {
            long[] values = new long[len];
            for (int i = 0; i < len; ++i) {
                values[i] = this.readLong();
            }
            return values;
        }
        return new long[0];
    }

    @Override
    public double[] readDoubleArray() throws IOException {
        int len = this.readInt();
        if (len > 0) {
            double[] values = new double[len];
            for (int i = 0; i < len; ++i) {
                values[i] = this.readDouble();
            }
            return values;
        }
        return new double[0];
    }

    @Override
    public float[] readFloatArray() throws IOException {
        int len = this.readInt();
        if (len > 0) {
            float[] values = new float[len];
            for (int i = 0; i < len; ++i) {
                values[i] = this.readFloat();
            }
            return values;
        }
        return new float[0];
    }

    @Override
    public short[] readShortArray() throws IOException {
        int len = this.readInt();
        if (len > 0) {
            short[] values = new short[len];
            for (int i = 0; i < len; ++i) {
                values[i] = this.readShort();
            }
            return values;
        }
        return new short[0];
    }

    @Override
    public int readUnsignedByte() throws IOException {
        return this.readByte();
    }

    @Override
    public int readUnsignedShort() throws IOException {
        return this.readShort();
    }

    @Override
    public String readUTF() throws IOException {
        return UTFUtil.readUTF(this);
    }

    public Object readObject() throws IOException {
        return this.service.readObject(this);
    }

    @Override
    public long skip(long n) {
        if (n <= 0L || n >= Integer.MAX_VALUE) {
            return 0L;
        }
        return this.skipBytes((int)n);
    }

    @Override
    public int skipBytes(int n) {
        if (n <= 0) {
            return 0;
        }
        int skip = n;
        int pos = this.position();
        if (pos + skip > this.size) {
            skip = this.size - pos;
        }
        this.position(pos + skip);
        return skip;
    }

    @Override
    public int position() {
        return this.pos;
    }

    @Override
    public void position(int newPos) {
        if (newPos > this.size || newPos < 0) {
            throw new IllegalArgumentException();
        }
        this.pos = newPos;
        if (this.mark > this.pos) {
            this.mark = -1;
        }
    }

    public byte[] getBuffer() {
        return this.buffer;
    }

    @Override
    public final int available() {
        return this.size - this.pos;
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public void mark(int readlimit) {
        this.mark = this.pos;
    }

    @Override
    public void reset() {
        this.pos = this.mark;
    }

    @Override
    public void close() {
        this.buffer = null;
    }

    @Override
    public SerializationContext getSerializationContext() {
        return this.service.getSerializationContext();
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.service.getClassLoader();
    }

    @Override
    public ByteOrder getByteOrder() {
        return ByteOrder.BIG_ENDIAN;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ByteArrayObjectDataInput");
        sb.append("{size=").append(this.size);
        sb.append(", pos=").append(this.pos);
        sb.append(", mark=").append(this.mark);
        sb.append('}');
        return sb.toString();
    }
}

