/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.tx;

import com.hazelcast.core.TransactionalMap;
import com.hazelcast.map.MapService;
import com.hazelcast.map.tx.TxnMapProxySupport;
import com.hazelcast.map.tx.TxnValueWrapper;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.spi.NodeEngine;
import com.hazelcast.transaction.impl.TransactionSupport;
import java.util.HashMap;
import java.util.Map;

public class TxnMapProxy
extends TxnMapProxySupport
implements TransactionalMap {
    private final Map<Object, TxnValueWrapper> txMap = new HashMap<Object, TxnValueWrapper>();

    public TxnMapProxy(String name, MapService mapService, NodeEngine nodeEngine, TransactionSupport transaction) {
        super(name, mapService, nodeEngine, transaction);
    }

    @Override
    public boolean containsKey(Object key) {
        return this.txMap.containsKey(key) || this.containsKeyInternal(((MapService)this.getService()).toData(key));
    }

    @Override
    public int size() {
        int currentSize = this.sizeInternal();
        for (TxnValueWrapper wrapper : this.txMap.values()) {
            if (wrapper.type == TxnValueWrapper.Type.NEW) {
                ++currentSize;
                continue;
            }
            if (wrapper.type != TxnValueWrapper.Type.REMOVED) continue;
            --currentSize;
        }
        return currentSize;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public Object get(Object key) {
        TxnValueWrapper currentValue = this.txMap.get(key);
        if (currentValue != null) {
            return this.checkIfRemoved(currentValue);
        }
        return ((MapService)this.getService()).toObject(this.getInternal(((MapService)this.getService()).toData(key)));
    }

    private Object checkIfRemoved(TxnValueWrapper wrapper) {
        return wrapper == null || wrapper.type == TxnValueWrapper.Type.REMOVED ? null : wrapper.value;
    }

    @Override
    public Object put(Object key, Object value) {
        Object valueBeforeTxn = ((MapService)this.getService()).toObject(this.putInternal(((MapService)this.getService()).toData(key), ((MapService)this.getService()).toData(value)));
        TxnValueWrapper currentValue = this.txMap.get(key);
        if (value != null) {
            TxnValueWrapper wrapper = valueBeforeTxn == null ? new TxnValueWrapper(value, TxnValueWrapper.Type.NEW) : new TxnValueWrapper(value, TxnValueWrapper.Type.UPDATED);
            this.txMap.put(key, wrapper);
        }
        return currentValue == null ? valueBeforeTxn : this.checkIfRemoved(currentValue);
    }

    @Override
    public void set(Object key, Object value) {
        Data dataBeforeTxn = this.putInternal(((MapService)this.getService()).toData(key), ((MapService)this.getService()).toData(value));
        if (value != null) {
            TxnValueWrapper wrapper = dataBeforeTxn == null ? new TxnValueWrapper(value, TxnValueWrapper.Type.NEW) : new TxnValueWrapper(value, TxnValueWrapper.Type.UPDATED);
            this.txMap.put(key, wrapper);
        }
    }

    @Override
    public Object putIfAbsent(Object key, Object value) {
        boolean haveTxnPast;
        TxnValueWrapper wrapper = this.txMap.get(key);
        boolean bl = haveTxnPast = wrapper != null;
        if (haveTxnPast) {
            if (wrapper.type != TxnValueWrapper.Type.REMOVED) {
                return wrapper.value;
            }
            this.putInternal(((MapService)this.getService()).toData(key), ((MapService)this.getService()).toData(value));
            this.txMap.put(key, new TxnValueWrapper(value, TxnValueWrapper.Type.NEW));
            return null;
        }
        Data oldValue = this.putIfAbsentInternal(((MapService)this.getService()).toData(key), ((MapService)this.getService()).toData(value));
        if (oldValue == null) {
            this.txMap.put(key, new TxnValueWrapper(value, TxnValueWrapper.Type.NEW));
        }
        return ((MapService)this.getService()).toObject(oldValue);
    }

    @Override
    public Object replace(Object key, Object value) {
        boolean haveTxnPast;
        TxnValueWrapper wrapper = this.txMap.get(key);
        boolean bl = haveTxnPast = wrapper != null;
        if (haveTxnPast) {
            if (wrapper.type == TxnValueWrapper.Type.REMOVED) {
                return null;
            }
            this.putInternal(((MapService)this.getService()).toData(key), ((MapService)this.getService()).toData(value));
            this.txMap.put(key, new TxnValueWrapper(value, TxnValueWrapper.Type.UPDATED));
            return wrapper.value;
        }
        Data oldValue = this.replaceInternal(((MapService)this.getService()).toData(key), ((MapService)this.getService()).toData(value));
        if (oldValue != null) {
            this.txMap.put(key, new TxnValueWrapper(value, TxnValueWrapper.Type.UPDATED));
        }
        return ((MapService)this.getService()).toObject(oldValue);
    }

    @Override
    public boolean replace(Object key, Object oldValue, Object newValue) {
        boolean haveTxnPast;
        TxnValueWrapper wrapper = this.txMap.get(key);
        boolean bl = haveTxnPast = wrapper != null;
        if (haveTxnPast) {
            if (!wrapper.value.equals(oldValue)) {
                return false;
            }
            this.putInternal(((MapService)this.getService()).toData(key), ((MapService)this.getService()).toData(newValue));
            this.txMap.put(key, new TxnValueWrapper(wrapper.value, TxnValueWrapper.Type.UPDATED));
            return true;
        }
        boolean success = this.replaceIfSameInternal(((MapService)this.getService()).toData(key), ((MapService)this.getService()).toData(oldValue), ((MapService)this.getService()).toData(newValue));
        if (success) {
            this.txMap.put(key, new TxnValueWrapper(newValue, TxnValueWrapper.Type.UPDATED));
        }
        return success;
    }

    @Override
    public boolean remove(Object key, Object value) {
        TxnValueWrapper wrapper = this.txMap.get(key);
        if (wrapper != null && !((MapService)this.getService()).compare(this.name, wrapper.value, value)) {
            return false;
        }
        boolean removed = this.removeIfSameInternal(((MapService)this.getService()).toData(key), value);
        if (removed) {
            this.txMap.put(key, new TxnValueWrapper(value, TxnValueWrapper.Type.REMOVED));
        }
        return removed;
    }

    @Override
    public Object remove(Object key) {
        Object valueBeforeTxn = ((MapService)this.getService()).toObject(this.removeInternal(((MapService)this.getService()).toData(key)));
        TxnValueWrapper wrapper = null;
        if (valueBeforeTxn != null || this.txMap.containsKey(key)) {
            wrapper = this.txMap.put(key, new TxnValueWrapper(valueBeforeTxn, TxnValueWrapper.Type.REMOVED));
        }
        return wrapper == null ? valueBeforeTxn : this.checkIfRemoved(wrapper);
    }

    @Override
    public void delete(Object key) {
        Data data = this.removeInternal(((MapService)this.getService()).toData(key));
        if (data != null || this.txMap.containsKey(key)) {
            this.txMap.put(key, new TxnValueWrapper(((MapService)this.getService()).toObject(data), TxnValueWrapper.Type.REMOVED));
        }
    }
}

