/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.proxy;

import com.hazelcast.core.EntryListener;
import com.hazelcast.core.EntryView;
import com.hazelcast.map.EntryProcessor;
import com.hazelcast.map.MapInterceptor;
import com.hazelcast.map.MapService;
import com.hazelcast.map.SimpleEntryView;
import com.hazelcast.map.proxy.MapProxy;
import com.hazelcast.map.proxy.MapProxySupport;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.query.Predicate;
import com.hazelcast.spi.Invocation;
import com.hazelcast.spi.NodeEngine;
import com.hazelcast.spi.Operation;
import com.hazelcast.util.IterationType;
import com.hazelcast.util.executor.DelegatingFuture;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;

public class MapProxyImpl<K, V>
extends MapProxySupport
implements MapProxy<K, V> {
    private static final String NULL_KEY_IS_NOT_ALLOWED = "Null key is not allowed!";

    public MapProxyImpl(String name, MapService mapService, NodeEngine nodeEngine) {
        super(name, mapService, nodeEngine);
    }

    @Override
    public V get(Object k) {
        if (k == null) {
            throw new NullPointerException(NULL_KEY_IS_NOT_ALLOWED);
        }
        Data key = ((MapService)this.getService()).toData(k);
        return (V)((MapService)this.getService()).toObject(this.getInternal(key));
    }

    @Override
    public V put(K k, V v) {
        return this.put(k, v, -1L, null);
    }

    @Override
    public V put(K k, V v, long ttl, TimeUnit timeunit) {
        if (k == null) {
            throw new NullPointerException(NULL_KEY_IS_NOT_ALLOWED);
        }
        Data key = ((MapService)this.getService()).toData(k);
        Data value = ((MapService)this.getService()).toData(v);
        Data result = this.putInternal(key, value, ttl, timeunit);
        return (V)((MapService)this.getService()).toObject(result);
    }

    @Override
    public boolean tryPut(K k, V v, long timeout, TimeUnit timeunit) {
        if (k == null) {
            throw new NullPointerException(NULL_KEY_IS_NOT_ALLOWED);
        }
        Data key = ((MapService)this.getService()).toData(k);
        Data value = ((MapService)this.getService()).toData(v);
        return this.tryPutInternal(key, value, timeout, timeunit);
    }

    @Override
    public V putIfAbsent(K k, V v) {
        return this.putIfAbsent(k, v, -1L, null);
    }

    @Override
    public V putIfAbsent(K k, V v, long ttl, TimeUnit timeunit) {
        if (k == null) {
            throw new NullPointerException(NULL_KEY_IS_NOT_ALLOWED);
        }
        Data key = ((MapService)this.getService()).toData(k);
        Data value = ((MapService)this.getService()).toData(v);
        Data result = this.putIfAbsentInternal(key, value, ttl, timeunit);
        return (V)((MapService)this.getService()).toObject(result);
    }

    @Override
    public void putTransient(K k, V v, long ttl, TimeUnit timeunit) {
        if (k == null) {
            throw new NullPointerException(NULL_KEY_IS_NOT_ALLOWED);
        }
        Data key = ((MapService)this.getService()).toData(k);
        Data value = ((MapService)this.getService()).toData(v);
        this.putTransientInternal(key, value, ttl, timeunit);
    }

    @Override
    public boolean replace(K k, V o, V v) {
        if (k == null) {
            throw new NullPointerException(NULL_KEY_IS_NOT_ALLOWED);
        }
        Data key = ((MapService)this.getService()).toData(k);
        Data oldValue = ((MapService)this.getService()).toData(o);
        Data value = ((MapService)this.getService()).toData(v);
        return this.replaceInternal(key, oldValue, value);
    }

    @Override
    public V replace(K k, V v) {
        if (k == null) {
            throw new NullPointerException(NULL_KEY_IS_NOT_ALLOWED);
        }
        Data key = ((MapService)this.getService()).toData(k);
        Data value = ((MapService)this.getService()).toData(v);
        return (V)((MapService)this.getService()).toObject(this.replaceInternal(key, value));
    }

    @Override
    public void set(K key, V value) {
        this.set(key, value, -1L, TimeUnit.MILLISECONDS);
    }

    @Override
    public void set(K k, V v, long ttl, TimeUnit timeunit) {
        if (k == null) {
            throw new NullPointerException(NULL_KEY_IS_NOT_ALLOWED);
        }
        Data key = ((MapService)this.getService()).toData(k);
        Data value = ((MapService)this.getService()).toData(v);
        this.setInternal(key, value, ttl, timeunit);
    }

    @Override
    public V remove(Object k) {
        if (k == null) {
            throw new NullPointerException(NULL_KEY_IS_NOT_ALLOWED);
        }
        Data key = ((MapService)this.getService()).toData(k);
        Data result = this.removeInternal(key);
        return (V)((MapService)this.getService()).toObject(result);
    }

    @Override
    public boolean remove(Object k, Object v) {
        if (k == null) {
            throw new NullPointerException(NULL_KEY_IS_NOT_ALLOWED);
        }
        Data key = ((MapService)this.getService()).toData(k);
        Data value = ((MapService)this.getService()).toData(v);
        return this.removeInternal(key, value);
    }

    @Override
    public void delete(Object k) {
        if (k == null) {
            throw new NullPointerException(NULL_KEY_IS_NOT_ALLOWED);
        }
        Data key = ((MapService)this.getService()).toData(k);
        this.deleteInternal(key);
    }

    @Override
    public boolean containsKey(Object k) {
        if (k == null) {
            throw new NullPointerException(NULL_KEY_IS_NOT_ALLOWED);
        }
        Data key = ((MapService)this.getService()).toData(k);
        return this.containsKeyInternal(key);
    }

    @Override
    public boolean containsValue(Object v) {
        Data value = ((MapService)this.getService()).toData(v);
        return this.containsValueInternal(value);
    }

    @Override
    public void lock(K key) {
        if (key == null) {
            throw new NullPointerException(NULL_KEY_IS_NOT_ALLOWED);
        }
        NodeEngine nodeEngine = this.getNodeEngine();
        Data k = ((MapService)this.getService()).toData(key);
        this.lockSupport.lock(nodeEngine, k);
    }

    @Override
    public void lock(Object key, long leaseTime, TimeUnit timeUnit) {
        if (key == null) {
            throw new NullPointerException(NULL_KEY_IS_NOT_ALLOWED);
        }
        this.lockSupport.lock(this.getNodeEngine(), ((MapService)this.getService()).toData(key), timeUnit.toMillis(leaseTime));
    }

    @Override
    public void unlock(K key) {
        if (key == null) {
            throw new NullPointerException(NULL_KEY_IS_NOT_ALLOWED);
        }
        NodeEngine nodeEngine = this.getNodeEngine();
        Data k = ((MapService)this.getService()).toData(key);
        this.lockSupport.unlock(nodeEngine, k);
    }

    @Override
    public boolean tryRemove(K key, long timeout, TimeUnit timeunit) {
        if (key == null) {
            throw new NullPointerException(NULL_KEY_IS_NOT_ALLOWED);
        }
        Data k = ((MapService)this.getService()).toData(key);
        return this.tryRemoveInternal(k, timeout, timeunit);
    }

    @Override
    public Future<V> getAsync(K k) {
        if (k == null) {
            throw new NullPointerException(NULL_KEY_IS_NOT_ALLOWED);
        }
        Data key = ((MapService)this.getService()).toData(k);
        NodeEngine nodeEngine = this.getNodeEngine();
        return new DelegatingFuture(this.getAsyncInternal(key), nodeEngine.getSerializationService());
    }

    @Override
    public boolean isLocked(K k) {
        if (k == null) {
            throw new NullPointerException(NULL_KEY_IS_NOT_ALLOWED);
        }
        Data key = ((MapService)this.getService()).toData(k);
        NodeEngine nodeEngine = this.getNodeEngine();
        return this.lockSupport.isLocked(nodeEngine, key);
    }

    @Override
    public Future putAsync(K key, V value) {
        if (key == null) {
            throw new NullPointerException(NULL_KEY_IS_NOT_ALLOWED);
        }
        Data k = ((MapService)this.getService()).toData(key);
        Data v = ((MapService)this.getService()).toData(value);
        return new DelegatingFuture(this.putAsyncInternal(k, v), this.getNodeEngine().getSerializationService());
    }

    @Override
    public Future removeAsync(K key) {
        if (key == null) {
            throw new NullPointerException(NULL_KEY_IS_NOT_ALLOWED);
        }
        Data k = ((MapService)this.getService()).toData(key);
        return new DelegatingFuture(this.removeAsyncInternal(k), this.getNodeEngine().getSerializationService());
    }

    @Override
    public Map<K, V> getAll(Set<K> keys) {
        HashSet<Data> ks = new HashSet<Data>(keys.size());
        for (K key : keys) {
            if (key == null) {
                throw new NullPointerException(NULL_KEY_IS_NOT_ALLOWED);
            }
            Data k = ((MapService)this.getService()).toData(key);
            ks.add(k);
        }
        return this.getAllObjectInternal(ks);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        this.putAllInternal(m);
    }

    @Override
    public boolean tryLock(K key) {
        if (key == null) {
            throw new NullPointerException(NULL_KEY_IS_NOT_ALLOWED);
        }
        NodeEngine nodeEngine = this.getNodeEngine();
        return this.lockSupport.tryLock(nodeEngine, ((MapService)this.getService()).toData(key));
    }

    @Override
    public boolean tryLock(K key, long time, TimeUnit timeunit) throws InterruptedException {
        if (key == null) {
            throw new NullPointerException(NULL_KEY_IS_NOT_ALLOWED);
        }
        NodeEngine nodeEngine = this.getNodeEngine();
        return this.lockSupport.tryLock(nodeEngine, ((MapService)this.getService()).toData(key), time, timeunit);
    }

    @Override
    public void forceUnlock(K key) {
        if (key == null) {
            throw new NullPointerException(NULL_KEY_IS_NOT_ALLOWED);
        }
        NodeEngine nodeEngine = this.getNodeEngine();
        Data k = ((MapService)this.getService()).toData(key);
        this.lockSupport.forceUnlock(nodeEngine, k);
    }

    @Override
    public String addInterceptor(MapInterceptor interceptor) {
        if (interceptor == null) {
            throw new NullPointerException("Interceptor should not be null!");
        }
        return this.addMapInterceptorInternal(interceptor);
    }

    @Override
    public void removeInterceptor(String id) {
        if (id == null) {
            throw new NullPointerException("Interceptor id should not be null!");
        }
        this.removeMapInterceptorInternal(id);
    }

    @Override
    public String addEntryListener(EntryListener listener, boolean includeValue) {
        if (listener == null) {
            throw new NullPointerException("Listener should not be null!");
        }
        return this.addEntryListenerInternal(listener, null, includeValue);
    }

    @Override
    public String addEntryListener(EntryListener<K, V> listener, K key, boolean includeValue) {
        if (listener == null) {
            throw new NullPointerException("Listener should not be null!");
        }
        return this.addEntryListenerInternal(listener, ((MapService)this.getService()).toData(key), includeValue);
    }

    @Override
    public String addEntryListener(EntryListener<K, V> listener, Predicate<K, V> predicate, K key, boolean includeValue) {
        if (listener == null) {
            throw new NullPointerException("Listener should not be null!");
        }
        if (predicate == null) {
            throw new NullPointerException("Predicate should not be null!");
        }
        return this.addEntryListenerInternal(listener, predicate, ((MapService)this.getService()).toData(key), includeValue);
    }

    @Override
    public boolean removeEntryListener(String id) {
        if (id == null) {
            throw new NullPointerException("Listener id should not be null!");
        }
        return this.removeEntryListenerInternal(id);
    }

    @Override
    public EntryView<K, V> getEntryView(K key) {
        if (key == null) {
            throw new NullPointerException(NULL_KEY_IS_NOT_ALLOWED);
        }
        SimpleEntryView entryViewInternal = (SimpleEntryView)this.getEntryViewInternal(((MapService)this.getService()).toData(key));
        if (entryViewInternal == null) {
            return null;
        }
        Data value = (Data)entryViewInternal.getValue();
        entryViewInternal.setKey(key);
        entryViewInternal.setValue(((MapService)this.getService()).toObject(value));
        return entryViewInternal;
    }

    @Override
    public boolean evict(Object key) {
        if (key == null) {
            throw new NullPointerException(NULL_KEY_IS_NOT_ALLOWED);
        }
        return this.evictInternal(((MapService)this.getService()).toData(key));
    }

    @Override
    public void clear() {
        this.clearInternal();
    }

    @Override
    public Set<K> keySet() {
        Set<Data> dataSet = this.keySetInternal();
        HashSet<Object> keySet = new HashSet<Object>();
        for (Data data : dataSet) {
            keySet.add(((MapService)this.getService()).toObject(data));
        }
        return keySet;
    }

    @Override
    public Collection<V> values() {
        Collection<Data> dataSet = this.valuesInternal();
        ArrayList<Object> valueSet = new ArrayList<Object>();
        for (Data data : dataSet) {
            valueSet.add(((MapService)this.getService()).toObject(data));
        }
        return valueSet;
    }

    @Override
    public Set entrySet() {
        Set<Map.Entry<Data, Data>> entries = this.entrySetInternal();
        HashSet<AbstractMap.SimpleImmutableEntry<Object, Object>> resultSet = new HashSet<AbstractMap.SimpleImmutableEntry<Object, Object>>();
        for (Map.Entry<Data, Data> entry : entries) {
            resultSet.add(new AbstractMap.SimpleImmutableEntry<Object, Object>(((MapService)this.getService()).toObject(entry.getKey()), ((MapService)this.getService()).toObject(entry.getValue())));
        }
        return resultSet;
    }

    @Override
    public Set<K> keySet(Predicate predicate) {
        if (predicate == null) {
            throw new NullPointerException("Predicate should not be null!");
        }
        return this.query(predicate, IterationType.KEY, false);
    }

    @Override
    public Set entrySet(Predicate predicate) {
        if (predicate == null) {
            throw new NullPointerException("Predicate should not be null!");
        }
        return this.query(predicate, IterationType.ENTRY, false);
    }

    @Override
    public Collection<V> values(Predicate predicate) {
        if (predicate == null) {
            throw new NullPointerException("Predicate should not be null!");
        }
        return this.query(predicate, IterationType.VALUE, false);
    }

    @Override
    public Set<K> localKeySet() {
        Set<Data> dataSet = this.localKeySetInternal();
        HashSet<Object> keySet = new HashSet<Object>(dataSet.size());
        for (Data data : dataSet) {
            keySet.add(((MapService)this.getService()).toObject(data));
        }
        return keySet;
    }

    @Override
    public Set<K> localKeySet(Predicate predicate) {
        if (predicate == null) {
            throw new NullPointerException("Predicate should not be null!");
        }
        return this.queryLocal(predicate, IterationType.KEY, false);
    }

    @Override
    public Object executeOnKey(K key, EntryProcessor entryProcessor) {
        if (key == null) {
            throw new NullPointerException(NULL_KEY_IS_NOT_ALLOWED);
        }
        return ((MapService)this.getService()).toObject(this.executeOnKeyInternal(((MapService)this.getService()).toData(key), entryProcessor));
    }

    protected Object invoke(Operation operation, int partitionId) throws Throwable {
        NodeEngine nodeEngine = this.getNodeEngine();
        Invocation invocation = nodeEngine.getOperationService().createInvocationBuilder("hz:impl:mapService", operation, partitionId).build();
        Future f = invocation.invoke();
        Object response = f.get();
        Object returnObj = ((MapService)this.getService()).toObject(response);
        if (returnObj instanceof Throwable) {
            throw (Throwable)returnObj;
        }
        return returnObj;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("IMap");
        sb.append("{name='").append(this.name).append('\'');
        sb.append('}');
        return sb.toString();
    }
}

