/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.client;

import com.hazelcast.client.CallableClientRequest;
import com.hazelcast.client.InitializingRequest;
import com.hazelcast.core.TransactionalMap;
import com.hazelcast.map.MapPortableHook;
import com.hazelcast.nio.IOUtil;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.Portable;
import com.hazelcast.nio.serialization.PortableReader;
import com.hazelcast.nio.serialization.PortableWriter;
import com.hazelcast.transaction.TransactionContext;
import java.io.IOException;

public class TxnMapRequest
extends CallableClientRequest
implements Portable,
InitializingRequest {
    String name;
    TxnMapRequestType requestType;
    Data key;
    Data value;
    Data newValue;

    public TxnMapRequest() {
    }

    public TxnMapRequest(String name, TxnMapRequestType requestType) {
        this.name = name;
        this.requestType = requestType;
    }

    public TxnMapRequest(String name, TxnMapRequestType requestType, Data key) {
        this(name, requestType);
        this.key = key;
    }

    public TxnMapRequest(String name, TxnMapRequestType requestType, Data key, Data value) {
        this(name, requestType, key);
        this.value = value;
    }

    public TxnMapRequest(String name, TxnMapRequestType requestType, Data key, Data value, Data newValue) {
        this(name, requestType, key, value);
        this.newValue = newValue;
    }

    public Object call() throws Exception {
        TransactionContext context = this.getEndpoint().getTransactionContext();
        TransactionalMap<Data, Data> map = context.getMap(this.name);
        switch (this.requestType) {
            case CONTAINS_KEY: {
                return map.containsKey(this.key);
            }
            case GET: {
                return map.get(this.key);
            }
            case SIZE: {
                return map.size();
            }
            case PUT: {
                return map.put(this.key, this.value);
            }
            case PUT_IF_ABSENT: {
                return map.putIfAbsent(this.key, this.value);
            }
            case REPLACE: {
                return map.replace(this.key, this.value);
            }
            case REPLACE_IS_SAME: {
                return map.replace(this.key, this.value, this.newValue);
            }
            case SET: {
                map.set(this.key, this.value);
                break;
            }
            case REMOVE: {
                return map.remove(this.key);
            }
            case DELETE: {
                map.delete(this.key);
                break;
            }
            case REMOVE_IF_SAME: {
                return map.remove(this.key, this.value);
            }
        }
        return null;
    }

    @Override
    public String getServiceName() {
        return "hz:impl:mapService";
    }

    @Override
    public Object getObjectId() {
        return this.name;
    }

    @Override
    public int getFactoryId() {
        return MapPortableHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 42;
    }

    @Override
    public void writePortable(PortableWriter writer) throws IOException {
        writer.writeUTF("n", this.name);
        writer.writeInt("t", this.requestType.type);
        ObjectDataOutput out = writer.getRawDataOutput();
        IOUtil.writeNullableData(out, this.key);
        IOUtil.writeNullableData(out, this.value);
        IOUtil.writeNullableData(out, this.newValue);
    }

    @Override
    public void readPortable(PortableReader reader) throws IOException {
        this.name = reader.readUTF("n");
        this.requestType = TxnMapRequestType.getByType(reader.readInt("t"));
        ObjectDataInput in = reader.getRawDataInput();
        this.key = IOUtil.readNullableData(in);
        this.value = IOUtil.readNullableData(in);
        this.newValue = IOUtil.readNullableData(in);
    }

    public static enum TxnMapRequestType {
        CONTAINS_KEY(1),
        GET(2),
        SIZE(3),
        PUT(4),
        PUT_IF_ABSENT(5),
        REPLACE(6),
        REPLACE_IS_SAME(7),
        SET(8),
        REMOVE(9),
        DELETE(10),
        REMOVE_IF_SAME(11);

        int type;

        private TxnMapRequestType(int i) {
            this.type = i;
        }

        public static TxnMapRequestType getByType(int type) {
            for (TxnMapRequestType requestType : TxnMapRequestType.values()) {
                if (requestType.type != type) continue;
                return requestType;
            }
            return null;
        }
    }
}

