/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map;

import com.hazelcast.map.MapContainer;
import com.hazelcast.map.MapService;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.util.scheduler.EntryTaskScheduler;
import com.hazelcast.util.scheduler.ScheduledEntry;
import com.hazelcast.util.scheduler.ScheduledEntryProcessor;
import java.util.Collection;
import java.util.HashSet;

public class MapStoreDeleteProcessor
implements ScheduledEntryProcessor<Data, Object> {
    MapContainer mapContainer;
    MapService mapService;

    public MapStoreDeleteProcessor(MapContainer mapContainer, MapService mapService) {
        this.mapContainer = mapContainer;
        this.mapService = mapService;
    }

    @Override
    public void process(EntryTaskScheduler<Data, Object> scheduler, Collection<ScheduledEntry<Data, Object>> entries) {
        if (entries.isEmpty()) {
            return;
        }
        if (entries.size() == 1) {
            this.mapContainer.getStore().delete(this.mapService.toObject(entries.iterator().next().getKey()));
            return;
        }
        HashSet<Object> keys = new HashSet<Object>();
        for (ScheduledEntry<Data, Object> entry : entries) {
            keys.add(this.mapService.toObject(entry.getKey()));
        }
        this.mapContainer.getStore().deleteAll(keys);
    }
}

