/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map;

import com.hazelcast.logging.ILogger;
import com.hazelcast.map.MapService;
import com.hazelcast.map.operation.EvictOperation;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.spi.Invocation;
import com.hazelcast.spi.NodeEngine;
import com.hazelcast.spi.Operation;
import com.hazelcast.util.scheduler.EntryTaskScheduler;
import com.hazelcast.util.scheduler.ScheduledEntry;
import com.hazelcast.util.scheduler.ScheduledEntryProcessor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;

public class EvictionProcessor
implements ScheduledEntryProcessor<Data, Object> {
    final NodeEngine nodeEngine;
    final MapService mapService;
    final String mapName;

    public EvictionProcessor(NodeEngine nodeEngine, MapService mapService, String mapName) {
        this.nodeEngine = nodeEngine;
        this.mapService = mapService;
        this.mapName = mapName;
    }

    @Override
    public void process(EntryTaskScheduler<Data, Object> scheduler, Collection<ScheduledEntry<Data, Object>> entries) {
        ArrayList<Future> futures = new ArrayList<Future>(entries.size());
        ILogger logger = this.nodeEngine.getLogger(this.getClass());
        for (ScheduledEntry<Data, Object> entry : entries) {
            Data key = entry.getKey();
            EvictOperation operation = new EvictOperation(this.mapName, key, true);
            int partitionId = this.nodeEngine.getPartitionService().getPartitionId(key);
            try {
                Invocation invocation = this.nodeEngine.getOperationService().createInvocationBuilder("hz:impl:mapService", (Operation)operation, partitionId).build();
                Future f = invocation.invoke();
                futures.add(f);
            }
            catch (Throwable t) {
                logger.log(Level.WARNING, t.getMessage(), t);
            }
        }
        for (Future future : futures) {
            try {
                future.get(30L, TimeUnit.SECONDS);
            }
            catch (TimeoutException e) {
                logger.log(Level.FINEST, e.getMessage(), e);
            }
            catch (Exception e) {
                logger.log(Level.WARNING, e.getMessage(), e);
            }
        }
    }
}

