/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.hibernate.instance;

import com.hazelcast.client.HazelcastClient;
import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.config.XmlClientConfigBuilder;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.hibernate.CacheEnvironment;
import com.hazelcast.hibernate.instance.HazelcastInstanceFactory;
import com.hazelcast.hibernate.instance.IHazelcastInstanceLoader;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import org.hibernate.cache.CacheException;
import org.hibernate.util.PropertiesHelper;

class HazelcastClientLoader
implements IHazelcastInstanceLoader {
    private static final ILogger logger = Logger.getLogger(HazelcastInstanceFactory.class);
    private final Properties props = new Properties();
    private HazelcastInstance client;

    HazelcastClientLoader() {
    }

    @Override
    public void configure(Properties props) {
        this.props.putAll((Map<?, ?>)props);
    }

    @Override
    public HazelcastInstance loadInstance() throws CacheException {
        if (this.client != null && this.client.getLifecycleService().isRunning()) {
            logger.log(Level.WARNING, "Current HazelcastClient is already active! Shutting it down...");
            this.unloadInstance();
        }
        String address = PropertiesHelper.getString((String)"hibernate.cache.hazelcast.native_client_address", (Properties)this.props, null);
        String group = PropertiesHelper.getString((String)"hibernate.cache.hazelcast.native_client_group", (Properties)this.props, null);
        String pass = PropertiesHelper.getString((String)"hibernate.cache.hazelcast.native_client_password", (Properties)this.props, null);
        String configResourcePath = CacheEnvironment.getConfigFilePath(this.props);
        ClientConfig clientConfig = null;
        if (configResourcePath != null) {
            try {
                clientConfig = new XmlClientConfigBuilder(configResourcePath).build();
            }
            catch (IOException e) {
                logger.log(Level.WARNING, "Could not load client configuration: " + configResourcePath, e);
            }
        }
        if (clientConfig == null) {
            clientConfig = new ClientConfig();
            clientConfig.setSmart(true);
            clientConfig.setConnectionAttemptLimit(3);
        }
        if (group != null) {
            clientConfig.getGroupConfig().setName(group);
        }
        if (pass != null) {
            clientConfig.getGroupConfig().setPassword(pass);
        }
        if (address != null) {
            clientConfig.addAddress(address);
        }
        this.client = HazelcastClient.newHazelcastClient(clientConfig);
        return this.client;
    }

    @Override
    public void unloadInstance() throws CacheException {
        if (this.client == null) {
            return;
        }
        try {
            this.client.getLifecycleService().shutdown();
            this.client = null;
        }
        catch (Exception e) {
            throw new CacheException((Throwable)e);
        }
    }
}

