/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.config;

public class SemaphoreConfig {
    public static final int DEFAULT_SYNC_BACKUP_COUNT = 1;
    public static final int DEFAULT_ASYNC_BACKUP_COUNT = 0;
    private String name;
    private int initialPermits;
    private int backupCount = 1;
    private int asyncBackupCount = 0;

    public SemaphoreConfig() {
    }

    public SemaphoreConfig(SemaphoreConfig config) {
        this.name = config.getName();
        this.initialPermits = config.getInitialPermits();
        this.backupCount = config.getBackupCount();
        this.asyncBackupCount = config.getAsyncBackupCount();
    }

    public String getName() {
        return this.name;
    }

    public SemaphoreConfig setName(String name) {
        this.name = name;
        return this;
    }

    public int getInitialPermits() {
        return this.initialPermits;
    }

    public SemaphoreConfig setInitialPermits(int initialPermits) {
        this.initialPermits = initialPermits;
        return this;
    }

    public int getBackupCount() {
        return this.backupCount;
    }

    public SemaphoreConfig setBackupCount(int backupCount) {
        this.backupCount = backupCount;
        return this;
    }

    public int getAsyncBackupCount() {
        return this.asyncBackupCount;
    }

    public SemaphoreConfig setAsyncBackupCount(int asyncBackupCount) {
        this.asyncBackupCount = asyncBackupCount;
        return this;
    }

    public int getTotalBackupCount() {
        return this.asyncBackupCount + this.backupCount;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("SemaphoreConfig{");
        sb.append("name='").append(this.name).append('\'');
        sb.append(", initialPermits=").append(this.initialPermits);
        sb.append(", backupCount=").append(this.backupCount);
        sb.append(", asyncBackupCount=").append(this.asyncBackupCount);
        sb.append('}');
        return sb.toString();
    }
}

