/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.config;

import com.hazelcast.config.InterfacesConfig;
import com.hazelcast.config.JoinConfig;
import com.hazelcast.config.SSLConfig;
import com.hazelcast.config.SocketInterceptorConfig;
import com.hazelcast.config.SymmetricEncryptionConfig;
import java.util.Collection;
import java.util.HashSet;

public class NetworkConfig {
    public static final int DEFAULT_PORT = 5701;
    private int port = 5701;
    private int portCount = 100;
    private boolean portAutoIncrement = true;
    private boolean reuseAddress = false;
    private String publicAddress = null;
    private Collection<String> outboundPortDefinitions;
    private Collection<Integer> outboundPorts;
    private InterfacesConfig interfaces = new InterfacesConfig();
    private JoinConfig join = new JoinConfig();
    private SymmetricEncryptionConfig symmetricEncryptionConfig = null;
    private SocketInterceptorConfig socketInterceptorConfig = null;
    private SSLConfig sslConfig = null;

    public NetworkConfig() {
        String os = System.getProperty("os.name").toLowerCase();
        this.reuseAddress = !os.contains("win");
    }

    public int getPort() {
        return this.port;
    }

    public NetworkConfig setPort(int port) {
        this.port = port;
        return this;
    }

    public int getPortCount() {
        return this.portCount;
    }

    public void setPortCount(int portCount) {
        this.portCount = portCount;
    }

    public boolean isPortAutoIncrement() {
        return this.portAutoIncrement;
    }

    public NetworkConfig setPortAutoIncrement(boolean portAutoIncrement) {
        this.portAutoIncrement = portAutoIncrement;
        return this;
    }

    public boolean isReuseAddress() {
        return this.reuseAddress;
    }

    public NetworkConfig setReuseAddress(boolean reuseAddress) {
        this.reuseAddress = reuseAddress;
        return this;
    }

    public Collection<String> getOutboundPortDefinitions() {
        return this.outboundPortDefinitions;
    }

    public NetworkConfig setOutboundPortDefinitions(Collection<String> outboundPortDefs) {
        this.outboundPortDefinitions = outboundPortDefs;
        return this;
    }

    public NetworkConfig addOutboundPortDefinition(String portDef) {
        if (this.outboundPortDefinitions == null) {
            this.outboundPortDefinitions = new HashSet<String>();
        }
        this.outboundPortDefinitions.add(portDef);
        return this;
    }

    public Collection<Integer> getOutboundPorts() {
        return this.outboundPorts;
    }

    public NetworkConfig setOutboundPorts(Collection<Integer> outboundPorts) {
        this.outboundPorts = outboundPorts;
        return this;
    }

    public NetworkConfig addOutboundPort(int port) {
        if (this.outboundPorts == null) {
            this.outboundPorts = new HashSet<Integer>();
        }
        this.outboundPorts.add(port);
        return this;
    }

    public InterfacesConfig getInterfaces() {
        return this.interfaces;
    }

    public NetworkConfig setInterfaces(InterfacesConfig interfaces) {
        this.interfaces = interfaces;
        return this;
    }

    public JoinConfig getJoin() {
        return this.join;
    }

    public NetworkConfig setJoin(JoinConfig join) {
        this.join = join;
        return this;
    }

    public String getPublicAddress() {
        return this.publicAddress;
    }

    public NetworkConfig setPublicAddress(String publicAddress) {
        this.publicAddress = publicAddress;
        return this;
    }

    public NetworkConfig setSocketInterceptorConfig(SocketInterceptorConfig socketInterceptorConfig) {
        this.socketInterceptorConfig = socketInterceptorConfig;
        return this;
    }

    public SocketInterceptorConfig getSocketInterceptorConfig() {
        return this.socketInterceptorConfig;
    }

    public SymmetricEncryptionConfig getSymmetricEncryptionConfig() {
        return this.symmetricEncryptionConfig;
    }

    public NetworkConfig setSymmetricEncryptionConfig(SymmetricEncryptionConfig symmetricEncryptionConfig) {
        this.symmetricEncryptionConfig = symmetricEncryptionConfig;
        return this;
    }

    public SSLConfig getSSLConfig() {
        return this.sslConfig;
    }

    public NetworkConfig setSSLConfig(SSLConfig sslConfig) {
        this.sslConfig = sslConfig;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("NetworkConfig {");
        sb.append("publicAddress='").append(this.publicAddress).append('\'');
        sb.append(", port=").append(this.port);
        sb.append(", portCount=").append(this.portCount);
        sb.append(", portAutoIncrement=").append(this.portAutoIncrement);
        sb.append(", join=").append(this.join);
        sb.append(", interfaces=").append(this.interfaces);
        sb.append(", sslConfig=").append(this.sslConfig);
        sb.append(", socketInterceptorConfig=").append(this.socketInterceptorConfig);
        sb.append(", symmetricEncryptionConfig=").append(this.symmetricEncryptionConfig);
        sb.append('}');
        return sb.toString();
    }
}

