/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.collection.operations.client;

import com.hazelcast.client.InitializingRequest;
import com.hazelcast.collection.CollectionProxyId;
import com.hazelcast.collection.operations.CompareAndRemoveOperation;
import com.hazelcast.collection.operations.client.CollectionKeyBasedRequest;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.PortableReader;
import com.hazelcast.nio.serialization.PortableWriter;
import com.hazelcast.spi.Operation;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class CompareAndRemoveRequest
extends CollectionKeyBasedRequest
implements InitializingRequest {
    List<Data> dataList;
    boolean retain;
    int threadId;

    public CompareAndRemoveRequest() {
    }

    public CompareAndRemoveRequest(CollectionProxyId proxyId, Data key, List<Data> dataList, boolean retain, int threadId) {
        super(proxyId, key);
        this.dataList = dataList;
        this.retain = retain;
        this.threadId = threadId;
    }

    @Override
    protected Operation prepareOperation() {
        return new CompareAndRemoveOperation(this.proxyId, this.key, this.threadId, this.dataList, this.retain);
    }

    @Override
    public int getClassId() {
        return 3;
    }

    @Override
    public void writePortable(PortableWriter writer) throws IOException {
        writer.writeBoolean("r", this.retain);
        writer.writeInt("t", this.threadId);
        writer.writeInt("s", this.dataList.size());
        ObjectDataOutput out = writer.getRawDataOutput();
        for (Data data : this.dataList) {
            data.writeData(out);
        }
        super.writePortable(writer);
    }

    @Override
    public void readPortable(PortableReader reader) throws IOException {
        this.retain = reader.readBoolean("r");
        this.threadId = reader.readInt("t");
        int size = reader.readInt("s");
        ObjectDataInput in = reader.getRawDataInput();
        this.dataList = new ArrayList<Data>(size);
        for (int i = 0; i < size; ++i) {
            Data data = new Data();
            data.readData(in);
            this.dataList.add(data);
        }
        super.readPortable(reader);
    }
}

