/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client;

import com.hazelcast.client.ClientEndpoint;
import com.hazelcast.client.ClientEngineImpl;
import com.hazelcast.client.ClientPrincipal;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.spi.AbstractOperation;
import java.io.IOException;

public class ClientReAuthOperation
extends AbstractOperation {
    private String clientUuid;
    private boolean firstConnection;

    public ClientReAuthOperation() {
    }

    public ClientReAuthOperation(String clientUuid, boolean firstConnection) {
        this.clientUuid = clientUuid;
        this.firstConnection = firstConnection;
    }

    @Override
    public void run() throws Exception {
        ClientEngineImpl service = (ClientEngineImpl)this.getService();
        ClientEndpoint endpoint = service.getEndpoint(this.clientUuid);
        if (endpoint != null) {
            endpoint.authenticated(new ClientPrincipal(this.clientUuid, this.getCallerUuid()), this.firstConnection);
        }
    }

    @Override
    public boolean returnsResponse() {
        return true;
    }

    @Override
    public Object getResponse() {
        return Boolean.TRUE;
    }

    @Override
    public String getServiceName() {
        return "hz:core:clientEngine";
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeUTF(this.clientUuid);
        out.writeBoolean(this.firstConnection);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.clientUuid = in.readUTF();
        this.firstConnection = in.readBoolean();
    }
}

