/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.impl.wan;

import com.hazelcast.impl.ClusterOperation;
import com.hazelcast.impl.Node;
import com.hazelcast.impl.Record;
import com.hazelcast.impl.base.DataRecordEntry;
import com.hazelcast.impl.wan.WanReplicationEndpoint;
import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.Connection;
import com.hazelcast.nio.ConnectionManager;
import com.hazelcast.nio.IOUtil;
import com.hazelcast.nio.Packet;
import com.hazelcast.util.AddressUtil;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.logging.Level;

public class WanNoDelayReplication
implements Runnable,
WanReplicationEndpoint {
    private Node node;
    private ILogger logger;
    private String groupName;
    private String password;
    private final LinkedBlockingQueue<String> addressQueue = new LinkedBlockingQueue();
    private final LinkedList<RecordUpdate> failureQ = new LinkedList();
    private final BlockingQueue<RecordUpdate> q = new ArrayBlockingQueue<RecordUpdate>(100000);
    private volatile boolean running = true;

    public void init(Node node, String groupName, String password, String ... targets) {
        this.node = node;
        this.logger = node.getLogger(WanNoDelayReplication.class.getName());
        this.groupName = groupName;
        this.password = password;
        this.addressQueue.addAll(Arrays.asList(targets));
        node.executorManager.executeNow(this);
    }

    public void recordUpdated(Record record) {
        DataRecordEntry dataRecordEntry = new DataRecordEntry(record);
        RecordUpdate ru = new RecordUpdate(dataRecordEntry, record.getName());
        if (!this.q.offer(ru)) {
            this.q.poll();
            this.q.offer(ru);
        }
    }

    public void shutdown() {
        this.running = false;
    }

    public void run() {
        Connection conn = null;
        while (this.running) {
            try {
                boolean authorized;
                RecordUpdate ru;
                RecordUpdate recordUpdate = ru = this.failureQ.size() > 0 ? this.failureQ.removeFirst() : this.q.take();
                if (conn == null && (conn = this.getConnection()) != null && !(authorized = this.node.clusterManager.checkAuthorization(this.groupName, this.password, conn.getEndPoint()))) {
                    conn.close();
                    conn = null;
                    if (this.logger != null) {
                        this.logger.log(Level.SEVERE, "Invalid groupName or groupPassword! ");
                    }
                }
                if (conn != null && conn.live()) {
                    conn.getWriteHandler().enqueueSocketWritable(ru.toNewPacket());
                    continue;
                }
                this.failureQ.addFirst(ru);
                conn = null;
            }
            catch (InterruptedException e) {
                this.running = false;
            }
            catch (Throwable e) {
                if (this.logger != null) {
                    this.logger.log(Level.WARNING, e.getMessage(), e);
                }
                conn = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Connection getConnection() throws InterruptedException {
        int defaultPort = this.node.getConfig().getNetworkConfig().getPort();
        while (this.running) {
            String targetStr = this.addressQueue.take();
            try {
                AddressUtil.AddressHolder addressHolder = AddressUtil.getAddressHolder(targetStr, defaultPort);
                Address target = new Address(addressHolder.address, addressHolder.port);
                ConnectionManager connectionManager = this.node.getConnectionManager();
                Connection conn = connectionManager.getOrConnect(target);
                for (int i = 0; i < 10; ++i) {
                    if (conn != null) {
                        Connection connection = conn;
                        return connection;
                    }
                    Thread.sleep(1000L);
                    conn = connectionManager.getConnection(target);
                }
            }
            catch (Throwable e) {
                Thread.sleep(1000L);
            }
            finally {
                this.addressQueue.offer(targetStr);
            }
        }
        return null;
    }

    class RecordUpdate {
        final DataRecordEntry dataRecordEntry;
        final String name;

        RecordUpdate(DataRecordEntry dataRecordEntry, String name) {
            this.dataRecordEntry = dataRecordEntry;
            this.name = name;
        }

        public Packet toNewPacket() {
            Packet packet = new Packet();
            packet.name = this.name;
            packet.operation = ClusterOperation.CONCURRENT_MAP_ASYNC_MERGE;
            packet.setKey(this.dataRecordEntry.getKeyData());
            packet.setValue(IOUtil.toData(this.dataRecordEntry));
            return packet;
        }
    }
}

