/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.nio;

import com.hazelcast.nio.DataSerializable;
import com.hazelcast.nio.Evolvable;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;

public abstract class AbstractEvolvableDataSerializable
implements DataSerializable,
Evolvable {
    private byte[] futureData;

    public byte[] getFutureData() {
        return this.futureData;
    }

    public final void writeData(DataOutput out) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        this.writeKnownData(dos);
        dos.close();
        baos.close();
        byte[] knownData = baos.toByteArray();
        int futureSize = this.futureData == null ? 0 : this.futureData.length;
        out.writeInt(knownData.length + futureSize);
        out.write(knownData);
        if (this.futureData != null) {
            out.write(this.futureData);
        }
    }

    public final void readData(DataInput in) throws IOException {
        int totalLength = in.readInt();
        byte[] allData = new byte[totalLength];
        in.readFully(allData);
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(allData);
            DataInputStream dis = new DataInputStream(bais);
            this.readKnownData(dis);
            this.futureData = new byte[dis.available()];
            dis.readFully(this.futureData);
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
    }

    public abstract void writeKnownData(DataOutput var1) throws IOException;

    public abstract void readKnownData(DataInput var1) throws IOException;
}

