/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.impl.concurrentmap;

import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.HazelcastInstanceAware;
import com.hazelcast.core.MapLoader;
import com.hazelcast.impl.CMap;
import com.hazelcast.impl.CallContext;
import com.hazelcast.impl.ConcurrentMapManager;
import com.hazelcast.impl.FactoryImpl;
import com.hazelcast.impl.Keys;
import com.hazelcast.impl.MProxy;
import com.hazelcast.impl.Processable;
import com.hazelcast.impl.Record;
import com.hazelcast.impl.ThreadContext;
import com.hazelcast.impl.base.KeyValue;
import com.hazelcast.impl.base.Pairs;
import com.hazelcast.nio.Data;
import com.hazelcast.nio.DataSerializable;
import com.hazelcast.nio.IOUtil;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.Callable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GetAllCallable
implements Callable<Pairs>,
HazelcastInstanceAware,
DataSerializable {
    private String mapName;
    private Keys keys;
    private FactoryImpl factory = null;

    public GetAllCallable() {
    }

    public GetAllCallable(String mapName, Keys keys) {
        this.mapName = mapName;
        this.keys = keys;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Pairs call() throws Exception {
        final ConcurrentMapManager c = this.factory.node.concurrentMapManager;
        Pairs pairs = new Pairs();
        CMap cmap = c.getMap(this.mapName);
        if (cmap == null) {
            c.enqueueAndWait(new Processable(){

                public void process() {
                    c.getOrCreateMap(GetAllCallable.this.mapName);
                }
            });
            cmap = c.getMap(this.mapName);
        }
        if (cmap != null) {
            Map mapLoadedEntries;
            Data value;
            MapLoader loader = cmap.getMapLoader();
            HashSet<Object> keysToLoad = loader != null ? new HashSet<Object>() : null;
            HashSet<Data> missingKeys = new HashSet<Data>(1);
            for (Data key : this.keys.getKeys()) {
                boolean missing = true;
                Record record = cmap.getRecord(key);
                if (record != null) {
                    if (record.isActive() && record.isValid() && (value = record.getValueData()) != null) {
                        pairs.addKeyValue(new KeyValue(key, value));
                        record.setLastAccessed();
                        missing = false;
                    }
                    if (!record.isActive() && record.getRemoveTime() > 0L) {
                        missing = false;
                    }
                }
                if (!missing) continue;
                missingKeys.add(key);
                if (keysToLoad == null) continue;
                keysToLoad.add(IOUtil.toObject(key));
            }
            if (keysToLoad != null && keysToLoad.size() > 0 && loader != null && (mapLoadedEntries = loader.loadAll(keysToLoad)) != null) {
                for (Object key : mapLoadedEntries.keySet()) {
                    Data dKey = IOUtil.toData(key);
                    value = mapLoadedEntries.get(key);
                    Data dValue = IOUtil.toData(value);
                    if (dKey != null && dValue != null) {
                        pairs.addKeyValue(new KeyValue(dKey, dValue));
                        c.putTransient(this.mapName, key, value, -1L);
                        continue;
                    }
                    missingKeys.add(dKey);
                }
            }
            if (loader == null && !missingKeys.isEmpty()) {
                ThreadContext threadContext = ThreadContext.get();
                CallContext realCallContext = threadContext.getCallContext();
                try {
                    threadContext.setCallContext(CallContext.DUMMY_CLIENT);
                    MProxy mproxy = (MProxy)this.factory.getOrCreateProxyByName(this.mapName);
                    for (Data key : missingKeys) {
                        Data value2 = (Data)mproxy.get(key);
                        if (value2 == null) continue;
                        pairs.addKeyValue(new KeyValue(key, value2));
                    }
                    Object var14_16 = null;
                    threadContext.setCallContext(realCallContext);
                }
                catch (Throwable throwable) {
                    Object var14_17 = null;
                    threadContext.setCallContext(realCallContext);
                    throw throwable;
                }
            }
        }
        return pairs;
    }

    @Override
    public void readData(DataInput in) throws IOException {
        this.mapName = in.readUTF();
        this.keys = new Keys();
        this.keys.readData(in);
    }

    @Override
    public void writeData(DataOutput out) throws IOException {
        out.writeUTF(this.mapName);
        this.keys.writeData(out);
    }

    @Override
    public void setHazelcastInstance(HazelcastInstance hazelcastInstance) {
        this.factory = (FactoryImpl)hazelcastInstance;
    }
}

