/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.impl.base;

import com.hazelcast.impl.Node;
import com.hazelcast.impl.base.CallKey;
import com.hazelcast.impl.base.CallState;
import com.hazelcast.impl.base.CallStateAware;
import com.hazelcast.impl.base.SystemArgsLog;
import com.hazelcast.impl.base.SystemLog;
import com.hazelcast.impl.base.SystemLogRecord;
import com.hazelcast.impl.base.SystemObjectLog;
import com.hazelcast.nio.Address;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Queue;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.LinkedBlockingQueue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SystemLogService {
    private static final int MAX_LOG_ENTRIES = 10000;
    private final ConcurrentMap<CallKey, CallState> mapCallStates = new ConcurrentHashMap<CallKey, CallState>(100, 0.75f, 32);
    private final Queue<SystemLog> joinLogs = new LinkedBlockingQueue<SystemLog>(10000);
    private final Queue<SystemLog> connectionLogs = new LinkedBlockingQueue<SystemLog>(10000);
    private final Queue<SystemLog> partitionLogs = new LinkedBlockingQueue<SystemLog>(10000);
    private final Queue<SystemLog> nodeLogs = new LinkedBlockingQueue<SystemLog>(10000);
    private volatile Level currentLevel = Level.DEFAULT;
    private final Node node;
    private final boolean SYSTEM_LOG_ENABLED;

    public SystemLogService(Node node) {
        this.node = node;
        this.SYSTEM_LOG_ENABLED = node.groupProperties.SYSTEM_LOG_ENABLED.getBoolean();
    }

    public String getCurrentLevel() {
        return this.currentLevel.getValue();
    }

    public void setCurrentLevel(String level) {
        this.currentLevel = Level.toLevel(level);
    }

    public List<SystemLogRecord> getLogBundle() {
        ArrayList<SystemLogRecord> systemLogList = new ArrayList<SystemLogRecord>();
        String node = this.node.getThisAddress().getHost() + ":" + this.node.getThisAddress().getPort();
        for (SystemLog log : this.joinLogs) {
            systemLogList.add(new SystemLogRecord(0L, node, log.getDate(), log.toString(), log.getType().toString()));
        }
        for (SystemLog log : this.nodeLogs) {
            systemLogList.add(new SystemLogRecord(0L, node, log.getDate(), log.toString(), log.getType().toString()));
        }
        for (SystemLog log : this.connectionLogs) {
            systemLogList.add(new SystemLogRecord(0L, node, log.getDate(), log.toString(), log.getType().toString()));
        }
        for (SystemLog log : this.partitionLogs) {
            systemLogList.add(new SystemLogRecord(0L, node, log.getDate(), log.toString(), log.getType().toString()));
        }
        for (CallState callState : this.mapCallStates.values()) {
            for (Object log : callState.getLogs()) {
                SystemLog systemLog = (SystemLog)log;
                systemLogList.add(new SystemLogRecord(callState.getCallId(), node, systemLog.getDate(), systemLog.toString(), systemLog.getType().toString()));
            }
        }
        return systemLogList;
    }

    public CallState getOrCreateCallState(long callId, Address callerAddress, int callerThreadId) {
        if (!this.SYSTEM_LOG_ENABLED || this.currentLevel == Level.NONE || callerAddress == null) {
            return null;
        }
        CallKey callKey = new CallKey(callerAddress, callerThreadId);
        CallState callBefore = (CallState)this.mapCallStates.get(callKey);
        if (callBefore == null) {
            CallState callStateNew = new CallState(callId, callerAddress, callerThreadId);
            int size = this.mapCallStates.size();
            if (size < 10000) {
                this.mapCallStates.put(callKey, callStateNew);
            } else {
                String msg = " CallStates created! You might have too many threads accessing Hazelcast!";
                this.logNode(size + msg);
            }
            return callStateNew;
        }
        if (callBefore.getCallId() != callId) {
            callBefore.reset(callId);
        }
        return callBefore;
    }

    public CallState getCallState(Address callerAddress, int callerThreadId) {
        if (!this.SYSTEM_LOG_ENABLED || this.currentLevel == Level.NONE) {
            return null;
        }
        return (CallState)this.mapCallStates.get(new CallKey(callerAddress, callerThreadId));
    }

    public CallState getCallStateForCallId(long callId, Address callerAddress, int callerThreadId) {
        if (!this.SYSTEM_LOG_ENABLED || this.currentLevel == Level.NONE) {
            return null;
        }
        CallState callState = (CallState)this.mapCallStates.get(new CallKey(callerAddress, callerThreadId));
        if (callState != null && callState.getCallId() == callId) {
            return callState;
        }
        return null;
    }

    public void shutdown() {
        this.mapCallStates.clear();
        this.connectionLogs.clear();
        this.nodeLogs.clear();
        this.joinLogs.clear();
        this.partitionLogs.clear();
    }

    public String dump() {
        StringBuilder sb = new StringBuilder();
        TreeSet<SystemLog> sorted = new TreeSet<SystemLog>(new Comparator<SystemLog>(){

            @Override
            public int compare(SystemLog o1, SystemLog o2) {
                long thisVal = o1.date;
                long anotherVal = o2.date;
                return thisVal < anotherVal ? -1 : (thisVal == anotherVal ? 0 : 1);
            }
        });
        sorted.addAll(this.joinLogs);
        sorted.addAll(this.nodeLogs);
        sorted.addAll(this.connectionLogs);
        sorted.addAll(this.partitionLogs);
        for (SystemLog systemLog : sorted) {
            sb.append(systemLog.getType().toString());
            sb.append(" - ");
            sb.append(new Date(systemLog.getDate()).toString());
            sb.append(" - ");
            sb.append(systemLog.toString());
            sb.append("\n");
        }
        for (CallState callState : this.mapCallStates.values()) {
            sb.append(callState.toString());
            sb.append("\n");
        }
        sb.append(this.node.concurrentMapManager.getPartitionManager().toString());
        sb.append("\n");
        return sb.toString();
    }

    private void dumpToFile(String log) throws IOException {
        String fileName = "hazelcast-" + this.node.getThisAddress() + ".dump.txt";
        File file = new File(fileName);
        FileWriter fileWriter = new FileWriter(file);
        BufferedWriter out = new BufferedWriter(fileWriter);
        out.write(log);
        out.close();
    }

    public void logConnection(String str) {
        if (this.SYSTEM_LOG_ENABLED && this.currentLevel != Level.NONE) {
            SystemObjectLog systemLog = new SystemObjectLog(str);
            systemLog.setType(SystemLog.Type.CONNECTION);
            this.connectionLogs.offer(systemLog);
        }
    }

    public void logPartition(String str) {
        if (this.SYSTEM_LOG_ENABLED && this.currentLevel != Level.NONE) {
            SystemObjectLog systemLog = new SystemObjectLog(str);
            systemLog.setType(SystemLog.Type.PARTITION);
            this.partitionLogs.offer(systemLog);
        }
    }

    public void logNode(String str) {
        if (this.SYSTEM_LOG_ENABLED && this.currentLevel != Level.NONE) {
            SystemObjectLog systemLog = new SystemObjectLog(str);
            systemLog.setType(SystemLog.Type.NODE);
            this.nodeLogs.offer(systemLog);
        }
    }

    public void logJoin(String str) {
        if (this.SYSTEM_LOG_ENABLED && this.currentLevel != Level.NONE) {
            SystemObjectLog systemLog = new SystemObjectLog(str);
            systemLog.setType(SystemLog.Type.JOIN);
            this.joinLogs.offer(systemLog);
        }
    }

    public boolean shouldLog(Level level) {
        return this.SYSTEM_LOG_ENABLED && this.currentLevel != Level.NONE && this.currentLevel.ordinal() >= level.ordinal();
    }

    public boolean shouldTrace() {
        return this.SYSTEM_LOG_ENABLED && this.currentLevel != Level.NONE && this.currentLevel.ordinal() >= Level.TRACE.ordinal();
    }

    public boolean shouldInfo() {
        return this.SYSTEM_LOG_ENABLED && this.currentLevel != Level.NONE && this.currentLevel.ordinal() >= Level.INFO.ordinal();
    }

    public void info(CallStateAware callStateAware, SystemLog callStateLog) {
        this.logState(callStateAware, Level.INFO, callStateLog);
    }

    public void trace(CallStateAware callStateAware, SystemLog callStateLog) {
        this.logState(callStateAware, Level.TRACE, callStateLog);
    }

    public void info(CallStateAware callStateAware, String msg) {
        this.logObject(callStateAware, Level.INFO, msg);
    }

    public void trace(CallStateAware callStateAware, String msg) {
        this.logObject(callStateAware, Level.TRACE, msg);
    }

    public void info(CallStateAware callStateAware, String msg, Object arg1) {
        if (this.shouldInfo()) {
            this.logState(callStateAware, Level.INFO, new SystemArgsLog(msg, arg1));
        }
    }

    public void info(CallStateAware callStateAware, String msg, Object arg1, Object arg2) {
        if (this.shouldInfo()) {
            this.logState(callStateAware, Level.INFO, new SystemArgsLog(msg, arg1, arg2));
        }
    }

    public void trace(CallStateAware callStateAware, String msg, Object arg1) {
        if (this.shouldTrace()) {
            this.logState(callStateAware, Level.TRACE, new SystemArgsLog(msg, arg1));
        }
    }

    public void trace(CallStateAware callStateAware, String msg, Object arg1, Object arg2) {
        if (this.shouldTrace()) {
            this.logState(callStateAware, Level.TRACE, new SystemArgsLog(msg, arg1, arg2));
        }
    }

    public void logObject(CallStateAware callStateAware, Level level, Object obj) {
        CallState callState;
        if (this.SYSTEM_LOG_ENABLED && this.currentLevel.ordinal() >= level.ordinal() && callStateAware != null && (callState = callStateAware.getCallState()) != null) {
            callState.logObject(obj);
        }
    }

    public void logState(CallStateAware callStateAware, Level level, SystemLog callStateLog) {
        CallState callState;
        if (this.SYSTEM_LOG_ENABLED && this.currentLevel.ordinal() >= level.ordinal() && callStateAware != null && (callState = callStateAware.getCallState()) != null) {
            callState.log(callStateLog);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Level {
        NONE("none"),
        DEFAULT("default"),
        INFO("info"),
        TRACE("trace");

        private String value;

        public String getValue() {
            return this.value;
        }

        private Level(String value) {
            this.value = value;
        }

        public static Level toLevel(String level) {
            if (level.equals("trace")) {
                return TRACE;
            }
            if (level.equals("default")) {
                return DEFAULT;
            }
            if (level.equals("info")) {
                return INFO;
            }
            return NONE;
        }
    }
}

