/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.impl;

import com.hazelcast.cluster.JoinInfo;
import com.hazelcast.config.Config;
import com.hazelcast.impl.MulticastListener;
import com.hazelcast.impl.Node;
import com.hazelcast.impl.OutOfMemoryErrorDispatcher;
import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.Packet;
import com.hazelcast.nio.PipedZipBufferFactory;
import java.io.EOFException;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.zip.DataFormatException;

public class MulticastService
implements Runnable {
    private static final int DATAGRAM_BUFFER_SIZE = 65536;
    private final ILogger logger;
    private final MulticastSocket multicastSocket;
    private final DatagramPacket datagramPacketSend;
    private final DatagramPacket datagramPacketReceive;
    private final Object sendLock = new Object();
    private volatile boolean running = true;
    private final CountDownLatch stopLatch = new CountDownLatch(1);
    private List<MulticastListener> lsListeners = new CopyOnWriteArrayList<MulticastListener>();
    final Node node;
    private final PipedZipBufferFactory.InflatingPipedBuffer inflatingBuffer = PipedZipBufferFactory.createInflatingBuffer(65536);
    private final PipedZipBufferFactory.DeflatingPipedBuffer deflatingBuffer = PipedZipBufferFactory.createDeflatingBuffer(65536, 1);

    public MulticastService(Node node, MulticastSocket multicastSocket) throws Exception {
        this.node = node;
        this.logger = node.getLogger(MulticastService.class.getName());
        Config config = node.getConfig();
        this.multicastSocket = multicastSocket;
        this.datagramPacketReceive = new DatagramPacket(this.inflatingBuffer.getInputBuffer().array(), 65536);
        this.datagramPacketSend = new DatagramPacket(this.deflatingBuffer.getOutputBuffer().array(), 65536, InetAddress.getByName(config.getNetworkConfig().getJoin().getMulticastConfig().getMulticastGroup()), config.getNetworkConfig().getJoin().getMulticastConfig().getMulticastPort());
        this.running = true;
    }

    public void addMulticastListener(MulticastListener multicastListener) {
        this.lsListeners.add(multicastListener);
    }

    public void removeMulticastListener(MulticastListener multicastListener) {
        this.lsListeners.remove(multicastListener);
    }

    public void stop() {
        try {
            if (!this.running && this.multicastSocket.isClosed()) {
                return;
            }
            try {
                this.multicastSocket.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.running = false;
            if (!this.stopLatch.await(5L, TimeUnit.SECONDS)) {
                this.logger.log(Level.WARNING, "Failed to shutdown MulticastService in 5 seconds!");
            }
        }
        catch (Throwable e) {
            this.logger.log(Level.WARNING, e.getMessage(), e);
        }
    }

    private void cleanup() {
        this.running = false;
        try {
            this.inflatingBuffer.destroy();
            this.deflatingBuffer.destroy();
            this.datagramPacketReceive.setData(new byte[0]);
            this.datagramPacketSend.setData(new byte[0]);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.stopLatch.countDown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        try {
            while (true) lbl-1000:
            // 5 sources

            {
                if (!this.running) {
                    var6_7 = null;
                    this.cleanup();
                    return;
                }
                try {
                    joinInfo = this.receive();
                    if (joinInfo == null) ** GOTO lbl-1000
                    i$ = this.lsListeners.iterator();
                    while (true) {
                        if (!i$.hasNext()) ** GOTO lbl-1000
                        multicastListener = i$.next();
                        try {
                            multicastListener.onMessage(joinInfo);
                        }
                        catch (Exception e) {
                            this.logger.log(Level.WARNING, e.getMessage(), e);
                        }
                    }
                }
                catch (OutOfMemoryError e) {
                    OutOfMemoryErrorDispatcher.onOutOfMemory(e);
                }
                catch (Exception e) {
                    this.logger.log(Level.WARNING, e.getMessage(), e);
                    continue;
                }
                break;
            }
        }
        catch (Throwable var5_9) {
            var6_8 = null;
            this.cleanup();
            throw var5_9;
        }
        ** GOTO lbl-1000
    }

    private JoinInfo receive() {
        this.inflatingBuffer.reset();
        try {
            this.multicastSocket.receive(this.datagramPacketReceive);
        }
        catch (IOException ignore) {
            return null;
        }
        try {
            this.inflatingBuffer.inflate(this.datagramPacketReceive.getLength());
            byte packetVersion = this.inflatingBuffer.getDataInput().readByte();
            if (packetVersion != Packet.PACKET_VERSION) {
                this.logger.log(Level.FINEST, "Received a JoinRequest with different packet version: " + packetVersion);
                return null;
            }
            JoinInfo joinInfo = new JoinInfo();
            joinInfo.readData(this.inflatingBuffer.getDataInput());
            return joinInfo;
        }
        catch (Exception e) {
            try {
                if (!(e instanceof EOFException) && !(e instanceof DataFormatException)) {
                    throw e;
                }
                this.logger.log(Level.FINEST, "Received data format is invalid. (An old version of Hazelcast may be running here.)", e);
            }
            catch (Exception e2) {
                this.logger.log(Level.WARNING, e2.getMessage(), e2);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(JoinInfo joinInfo) {
        if (!this.running) {
            return;
        }
        Object object = this.sendLock;
        synchronized (object) {
            try {
                this.deflatingBuffer.reset();
                this.deflatingBuffer.getDataOutput().writeByte(Packet.PACKET_VERSION);
                joinInfo.writeData(this.deflatingBuffer.getDataOutput());
                int count = this.deflatingBuffer.deflate();
                this.datagramPacketSend.setData(this.deflatingBuffer.getOutputBuffer().array(), 0, count);
                this.multicastSocket.send(this.datagramPacketSend);
            }
            catch (IOException e) {
                this.logger.log(Level.WARNING, "You probably have too long Hazelcast configuration!", e);
            }
        }
    }
}

