/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.impl;

import com.hazelcast.core.EntryListener;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.Instance;
import com.hazelcast.core.MapEntry;
import com.hazelcast.impl.AsyncCall;
import com.hazelcast.impl.ClusterOperation;
import com.hazelcast.impl.ConcurrentMapManager;
import com.hazelcast.impl.FactoryImpl;
import com.hazelcast.impl.ListenerManager;
import com.hazelcast.impl.MProxy;
import com.hazelcast.impl.Processable;
import com.hazelcast.impl.ThreadContext;
import com.hazelcast.impl.TransactionImpl;
import com.hazelcast.impl.Util;
import com.hazelcast.impl.base.FactoryAwareNamedProxy;
import com.hazelcast.impl.concurrentmap.AddMapIndex;
import com.hazelcast.impl.monitor.LocalMapStatsImpl;
import com.hazelcast.impl.monitor.MapOperationsCounter;
import com.hazelcast.monitor.LocalMapStats;
import com.hazelcast.nio.Data;
import com.hazelcast.nio.DataSerializable;
import com.hazelcast.nio.IOUtil;
import com.hazelcast.query.Expression;
import com.hazelcast.query.Predicate;
import com.hazelcast.query.Predicates;
import com.hazelcast.util.Clock;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class MProxyImpl
extends FactoryAwareNamedProxy
implements MProxy,
DataSerializable {
    private transient MProxy mproxyReal = null;
    private transient ConcurrentMapManager concurrentMapManager = null;
    private transient ListenerManager listenerManager = null;
    private volatile transient MProxy dynamicProxy;

    public MProxyImpl() {
    }

    MProxyImpl(String name, FactoryImpl factory) {
        this.setName(name);
        this.setHazelcastInstance(factory);
        this.mproxyReal = new MProxyReal();
    }

    public MapOperationsCounter getMapOperationCounter() {
        return this.mproxyReal.getMapOperationCounter();
    }

    public void setHazelcastInstance(HazelcastInstance hazelcastInstance) {
        super.setHazelcastInstance(hazelcastInstance);
        this.concurrentMapManager = this.factory.node.concurrentMapManager;
        this.listenerManager = this.factory.node.listenerManager;
        ClassLoader cl = MProxy.class.getClassLoader();
        this.dynamicProxy = (MProxy)Proxy.newProxyInstance(cl, new Class[]{MProxy.class}, (InvocationHandler)new DynamicInvoker());
    }

    private void beforeCall() {
        this.factory.initialChecks();
        if (this.mproxyReal == null) {
            this.mproxyReal = (MProxy)this.factory.getOrCreateProxyByName(this.name);
        }
    }

    private void afterCall() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object get(Object key) {
        this.beforeCall();
        try {
            Object v = this.mproxyReal.get(key);
            Object var5_4 = null;
            this.afterCall();
            return v;
        }
        catch (Throwable e) {
            try {
                Util.throwUncheckedException(e);
                Object var3_7 = null;
                Object var5_5 = null;
                this.afterCall();
                return var3_7;
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                this.afterCall();
                throw throwable;
            }
        }
    }

    public Object put(Object key, Object value) {
        return this.put(key, value, 0L, TimeUnit.SECONDS);
    }

    public Future getAsync(Object key) {
        this.beforeCall();
        final MProxyImpl mProxy = this;
        final Data dataKey = IOUtil.toData(key);
        AsyncCall call = new AsyncCall(){

            protected void call() {
                this.setResult(mProxy.get(dataKey));
            }
        };
        this.factory.node.executorManager.executeAsync(call);
        return call;
    }

    public Future putAsync(Object key, Object value) {
        this.beforeCall();
        final MProxyImpl mProxy = this;
        final Data dataKey = IOUtil.toData(key);
        final Data dataValue = IOUtil.toData(value);
        AsyncCall call = new AsyncCall(){

            protected void call() {
                this.setResult(mProxy.put(dataKey, dataValue));
            }
        };
        this.factory.node.executorManager.executeAsync(call);
        return call;
    }

    public Future removeAsync(Object key) {
        this.beforeCall();
        final MProxyImpl mProxy = this;
        final Data dataKey = IOUtil.toData(key);
        AsyncCall call = new AsyncCall(){

            protected void call() {
                this.setResult(mProxy.remove(dataKey));
            }
        };
        this.factory.node.executorManager.executeAsync(call);
        return call;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object put(Object key, Object value, long ttl, TimeUnit timeunit) {
        this.beforeCall();
        try {
            Object object = this.mproxyReal.put(key, value, ttl, timeunit);
            Object var9_7 = null;
            this.afterCall();
            return object;
        }
        catch (Throwable e) {
            try {
                Util.throwUncheckedException(e);
                Object var7_10 = null;
                Object var9_8 = null;
                this.afterCall();
                return var7_10;
            }
            catch (Throwable throwable) {
                Object var9_9 = null;
                this.afterCall();
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object remove(Object key) {
        this.beforeCall();
        try {
            Object v = this.mproxyReal.remove(key);
            Object var5_4 = null;
            this.afterCall();
            return v;
        }
        catch (Throwable e) {
            try {
                Util.throwUncheckedException(e);
                Object var3_7 = null;
                Object var5_5 = null;
                this.afterCall();
                return var3_7;
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                this.afterCall();
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object tryRemove(Object key, long time, TimeUnit timeunit) throws TimeoutException {
        this.beforeCall();
        try {
            Object object = this.mproxyReal.tryRemove(key, time, timeunit);
            Object var8_6 = null;
            this.afterCall();
            return object;
        }
        catch (Throwable e) {
            try {
                if (e instanceof TimeoutException) {
                    throw (TimeoutException)e;
                }
                Util.throwUncheckedException(e);
                Object var6_9 = null;
                Object var8_7 = null;
                this.afterCall();
                return var6_9;
            }
            catch (Throwable throwable) {
                Object var8_8 = null;
                this.afterCall();
                throw throwable;
            }
        }
    }

    public void putAndUnlock(Object key, Object value) {
        this.dynamicProxy.putAndUnlock(key, value);
    }

    public Object tryLockAndGet(Object key, long time, TimeUnit timeunit) throws TimeoutException {
        return this.dynamicProxy.tryLockAndGet(key, time, timeunit);
    }

    public Map getAll(Set keys) {
        return this.dynamicProxy.getAll(keys);
    }

    public void flush() {
        this.dynamicProxy.flush();
    }

    public void putForSync(Object key, Object value) {
        this.dynamicProxy.putForSync(key, value);
    }

    public void removeForSync(Object key) {
        this.dynamicProxy.removeForSync(key);
    }

    public void putTransient(Object key, Object value, long time, TimeUnit timeunit) {
        this.dynamicProxy.putTransient(key, value, time, timeunit);
    }

    public boolean tryPut(Object key, Object value, long time, TimeUnit timeunit) {
        return this.dynamicProxy.tryPut(key, value, time, timeunit);
    }

    public void set(Object key, Object value, long time, TimeUnit timeunit) {
        this.dynamicProxy.set(key, value, time, timeunit);
    }

    public Object putIfAbsent(Object key, Object value, long ttl, TimeUnit timeunit) {
        return this.dynamicProxy.putIfAbsent(key, value, ttl, timeunit);
    }

    public Object putIfAbsent(Object key, Object value) {
        return this.dynamicProxy.putIfAbsent(key, value);
    }

    public LocalMapStats getLocalMapStats() {
        return this.dynamicProxy.getLocalMapStats();
    }

    public void addIndex(String attribute, boolean ordered) {
        this.dynamicProxy.addIndex(attribute, ordered);
    }

    public void addIndex(Expression expression, boolean ordered) {
        this.dynamicProxy.addIndex(expression, ordered);
    }

    public Object getId() {
        return this.dynamicProxy.getId();
    }

    public String toString() {
        return "Map [" + this.getName() + "] ";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MProxyImpl mProxy = (MProxyImpl)o;
        return this.name.equals(mProxy.name);
    }

    public int hashCode() {
        return this.name != null ? this.name.hashCode() : 0;
    }

    public void destroy() {
        this.dynamicProxy.destroy();
    }

    public Instance.InstanceType getInstanceType() {
        return this.dynamicProxy.getInstanceType();
    }

    public boolean removeKey(Object key) {
        return this.dynamicProxy.removeKey(key);
    }

    public int size() {
        return this.dynamicProxy.size();
    }

    public boolean isEmpty() {
        return this.dynamicProxy.isEmpty();
    }

    public boolean containsKey(Object key) {
        return this.dynamicProxy.containsKey(key);
    }

    public boolean containsValue(Object value) {
        return this.dynamicProxy.containsValue(value);
    }

    public MapEntry getMapEntry(Object key) {
        return this.dynamicProxy.getMapEntry(key);
    }

    public void putAll(Map t) {
        this.dynamicProxy.putAll(t);
    }

    public void clear() {
        this.dynamicProxy.clear();
    }

    public int valueCount(Object key) {
        return this.dynamicProxy.valueCount(key);
    }

    public Set allKeys() {
        return this.dynamicProxy.allKeys();
    }

    public Set localKeySet() {
        return this.dynamicProxy.localKeySet();
    }

    public Set localKeySet(Predicate predicate) {
        return this.dynamicProxy.localKeySet(predicate);
    }

    public Set keySet() {
        return this.dynamicProxy.keySet();
    }

    public Collection values() {
        return this.dynamicProxy.values();
    }

    public Set entrySet() {
        return this.dynamicProxy.entrySet();
    }

    public Set keySet(Predicate predicate) {
        return this.dynamicProxy.keySet(predicate);
    }

    public Collection values(Predicate predicate) {
        return this.dynamicProxy.values(predicate);
    }

    public Set entrySet(Predicate predicate) {
        return this.dynamicProxy.entrySet(predicate);
    }

    public boolean remove(Object key, Object value) {
        return this.dynamicProxy.remove(key, value);
    }

    public boolean replace(Object key, Object oldValue, Object newValue) {
        return this.dynamicProxy.replace(key, oldValue, newValue);
    }

    public Object replace(Object key, Object value) {
        return this.dynamicProxy.replace(key, value);
    }

    public String getName() {
        return this.name.substring("c:".length());
    }

    public boolean lockMap(long time, TimeUnit timeunit) {
        return this.dynamicProxy.lockMap(time, timeunit);
    }

    public void unlockMap() {
        this.dynamicProxy.unlockMap();
    }

    public void lock(Object key) {
        this.dynamicProxy.lock(key);
    }

    public boolean isLocked(Object key) {
        return this.dynamicProxy.isLocked(key);
    }

    public boolean tryLock(Object key) {
        return this.dynamicProxy.tryLock(key);
    }

    public boolean tryLock(Object key, long time, TimeUnit timeunit) {
        return this.dynamicProxy.tryLock(key, time, timeunit);
    }

    public void unlock(Object key) {
        this.dynamicProxy.unlock(key);
    }

    public void forceUnlock(Object key) {
        this.dynamicProxy.forceUnlock(key);
    }

    public String getLongName() {
        return this.dynamicProxy.getLongName();
    }

    public void addGenericListener(Object listener, Object key, boolean includeValue, Instance.InstanceType instanceType) {
        this.dynamicProxy.addGenericListener(listener, key, includeValue, instanceType);
    }

    public void removeGenericListener(Object listener, Object key) {
        this.dynamicProxy.removeGenericListener(listener, key);
    }

    public void addLocalEntryListener(EntryListener entryListener) {
        this.dynamicProxy.addLocalEntryListener(entryListener);
    }

    public void addEntryListener(EntryListener listener, boolean includeValue) {
        this.dynamicProxy.addEntryListener(listener, includeValue);
    }

    public void addEntryListener(EntryListener listener, Object key, boolean includeValue) {
        this.dynamicProxy.addEntryListener(listener, key, includeValue);
    }

    public void removeEntryListener(EntryListener listener) {
        this.dynamicProxy.removeEntryListener(listener);
    }

    public void removeEntryListener(EntryListener listener, Object key) {
        this.dynamicProxy.removeEntryListener(listener, key);
    }

    public boolean containsEntry(Object key, Object value) {
        return this.dynamicProxy.containsEntry(key, value);
    }

    public boolean putMulti(Object key, Object value) {
        return this.dynamicProxy.putMulti(key, value);
    }

    public boolean removeMulti(Object key, Object value) {
        return this.dynamicProxy.removeMulti(key, value);
    }

    public boolean add(Object value) {
        return this.dynamicProxy.add(value);
    }

    public boolean evict(Object key) {
        return this.dynamicProxy.evict(key);
    }

    private static void check(Object obj) {
        Util.checkSerializable(obj);
    }

    private class MProxyReal
    implements MProxy {
        private final transient MapOperationsCounter mapOperationCounter = new MapOperationsCounter();

        public String toString() {
            return MProxyImpl.this.toString();
        }

        public Instance.InstanceType getInstanceType() {
            return Instance.InstanceType.MAP;
        }

        public Object getId() {
            return MProxyImpl.this.name;
        }

        public boolean equals(Object o) {
            return MProxyImpl.this.equals(o);
        }

        public int hashCode() {
            return MProxyImpl.this.hashCode();
        }

        public String getLongName() {
            return MProxyImpl.this.name;
        }

        public String getName() {
            return MProxyImpl.this.getName();
        }

        public void addIndex(String attribute, boolean ordered) {
            this.addIndex((Expression)Predicates.get(attribute), ordered);
        }

        public void addIndex(final Expression expression, final boolean ordered) {
            final CountDownLatch latch = new CountDownLatch(1);
            MProxyImpl.this.concurrentMapManager.enqueueAndReturn(new Processable(){

                public void process() {
                    AddMapIndex addMapIndexProcess = new AddMapIndex(MProxyImpl.this.name, expression, ordered);
                    MProxyImpl.this.concurrentMapManager.sendProcessableToAll(addMapIndexProcess, true);
                    latch.countDown();
                }
            });
            try {
                latch.await();
            }
            catch (InterruptedException ignored) {
                // empty catch block
            }
        }

        public void flush() {
            MProxyImpl.this.concurrentMapManager.flush(MProxyImpl.this.name);
        }

        public MapEntry getMapEntry(Object key) {
            long begin = Clock.currentTimeMillis();
            MProxyImpl.check(key);
            ConcurrentMapManager.MGetMapEntry mgetMapEntry = MProxyImpl.this.concurrentMapManager.new ConcurrentMapManager.MGetMapEntry();
            MapEntry mapEntry = mgetMapEntry.get(MProxyImpl.this.name, key);
            this.mapOperationCounter.incrementGets(Clock.currentTimeMillis() - begin);
            return mapEntry;
        }

        public boolean putMulti(Object key, Object value) {
            MProxyImpl.check(key);
            MProxyImpl.check(value);
            ConcurrentMapManager.MPutMulti mput = MProxyImpl.this.concurrentMapManager.new ConcurrentMapManager.MPutMulti();
            return mput.put(MProxyImpl.this.name, key, value);
        }

        public Object put(Object key, Object value) {
            return this.put(key, value, 0L, TimeUnit.SECONDS);
        }

        public void putForSync(Object key, Object value) {
            long begin = Clock.currentTimeMillis();
            MProxyImpl.check(key);
            MProxyImpl.check(value);
            ConcurrentMapManager.MPut mput = ThreadContext.get().getCallCache(MProxyImpl.this.factory).getMPut();
            mput.putForSync(MProxyImpl.this.name, key, value);
            mput.clearRequest();
            this.mapOperationCounter.incrementPuts(Clock.currentTimeMillis() - begin);
        }

        public void removeForSync(Object key) {
            long begin = Clock.currentTimeMillis();
            MProxyImpl.check(key);
            ConcurrentMapManager.MRemove mremove = ThreadContext.get().getCallCache(MProxyImpl.this.factory).getMRemove();
            mremove.removeForSync(MProxyImpl.this.name, key);
            mremove.clearRequest();
            this.mapOperationCounter.incrementRemoves(Clock.currentTimeMillis() - begin);
        }

        public Map getAll(Set keys) {
            if (keys == null) {
                throw new NullPointerException();
            }
            return MProxyImpl.this.concurrentMapManager.getAll(MProxyImpl.this.name, keys);
        }

        public Future getAsync(Object key) {
            throw new UnsupportedOperationException();
        }

        public Future putAsync(Object key, Object value) {
            throw new UnsupportedOperationException();
        }

        public Future removeAsync(Object key) {
            throw new UnsupportedOperationException();
        }

        public Object put(Object key, Object value, long ttl, TimeUnit timeunit) {
            if (ttl < 0L) {
                throw new IllegalArgumentException("ttl value cannot be negative. " + ttl);
            }
            ttl = ttl == 0L ? -1L : Util.toMillis(ttl, timeunit);
            return this.put(key, value, ttl);
        }

        public void putTransient(Object key, Object value, long ttl, TimeUnit timeunit) {
            if (ttl < 0L) {
                throw new IllegalArgumentException("ttl value cannot be negative. " + ttl);
            }
            ttl = ttl == 0L ? -1L : Util.toMillis(ttl, timeunit);
            this.mapOperationCounter.incrementOtherOperations();
            MProxyImpl.this.concurrentMapManager.putTransient(MProxyImpl.this.name, key, value, ttl);
        }

        public Object put(Object key, Object value, long ttl) {
            long begin = Clock.currentTimeMillis();
            MProxyImpl.check(key);
            MProxyImpl.check(value);
            ConcurrentMapManager.MPut mput = ThreadContext.get().getCallCache(MProxyImpl.this.factory).getMPut();
            Object result = mput.put(MProxyImpl.this.name, key, value, ttl);
            mput.clearRequest();
            this.mapOperationCounter.incrementPuts(Clock.currentTimeMillis() - begin);
            return result;
        }

        public void set(Object key, Object value, long ttl, TimeUnit timeunit) {
            long begin = Clock.currentTimeMillis();
            if (ttl < 0L) {
                throw new IllegalArgumentException("ttl value cannot be negative. " + ttl);
            }
            ttl = ttl == 0L ? -1L : Util.toMillis(ttl, timeunit);
            MProxyImpl.check(key);
            MProxyImpl.check(value);
            ConcurrentMapManager.MPut mput = ThreadContext.get().getCallCache(MProxyImpl.this.factory).getMPut();
            mput.set(MProxyImpl.this.name, key, value, ttl);
            mput.clearRequest();
            this.mapOperationCounter.incrementPuts(Clock.currentTimeMillis() - begin);
        }

        public boolean tryPut(Object key, Object value, long timeout, TimeUnit timeunit) {
            long begin = Clock.currentTimeMillis();
            if (timeout < 0L) {
                throw new IllegalArgumentException("timeout value cannot be negative. " + timeout);
            }
            timeout = Util.toMillis(timeout, timeunit);
            MProxyImpl.check(key);
            MProxyImpl.check(value);
            ConcurrentMapManager.MPut mput = ThreadContext.get().getCallCache(MProxyImpl.this.factory).getMPut();
            Boolean result = mput.tryPut(MProxyImpl.this.name, key, value, timeout, -1L);
            mput.clearRequest();
            this.mapOperationCounter.incrementPuts(Clock.currentTimeMillis() - begin);
            return result;
        }

        public Object tryLockAndGet(Object key, long timeout, TimeUnit timeunit) throws TimeoutException {
            long begin = Clock.currentTimeMillis();
            if (timeout < 0L) {
                throw new IllegalArgumentException("timeout value cannot be negative. " + timeout);
            }
            timeout = Util.toMillis(timeout, timeunit);
            MProxyImpl.check(key);
            Object result = MProxyImpl.this.concurrentMapManager.tryLockAndGet(MProxyImpl.this.name, key, timeout);
            this.mapOperationCounter.incrementGets(Clock.currentTimeMillis() - begin);
            return result;
        }

        public boolean lockMap(long time, TimeUnit timeunit) {
            if (((MProxyImpl)MProxyImpl.this).factory.locksMapProxy.tryLock("map_lock_" + MProxyImpl.this.name, time, timeunit)) {
                ConcurrentMapManager concurrentMapManager = MProxyImpl.this.concurrentMapManager;
                concurrentMapManager.getClass();
                ConcurrentMapManager.MLockMap mLockMap = concurrentMapManager.new ConcurrentMapManager.MLockMap(MProxyImpl.this.name, true);
                mLockMap.call();
                return true;
            }
            return false;
        }

        public void unlockMap() {
            ConcurrentMapManager concurrentMapManager = MProxyImpl.this.concurrentMapManager;
            concurrentMapManager.getClass();
            ConcurrentMapManager.MLockMap mLockMap = concurrentMapManager.new ConcurrentMapManager.MLockMap(MProxyImpl.this.name, false);
            mLockMap.call();
            ((MProxyImpl)MProxyImpl.this).factory.locksMapProxy.unlock("map_lock_" + MProxyImpl.this.name);
        }

        public void lock(Object key) {
            MProxyImpl.check(key);
            this.mapOperationCounter.incrementOtherOperations();
            MProxyImpl.this.concurrentMapManager.lock(MProxyImpl.this.name, key, -1L);
        }

        public boolean isLocked(Object key) {
            MProxyImpl.check(key);
            this.mapOperationCounter.incrementOtherOperations();
            ConcurrentMapManager.MLock mlock = MProxyImpl.this.concurrentMapManager.new ConcurrentMapManager.MLock();
            return mlock.isLocked(MProxyImpl.this.name, key);
        }

        public boolean tryLock(Object key) {
            MProxyImpl.check(key);
            this.mapOperationCounter.incrementOtherOperations();
            return MProxyImpl.this.concurrentMapManager.lock(MProxyImpl.this.name, key, 0L);
        }

        public boolean tryLock(Object key, long time, TimeUnit timeunit) {
            MProxyImpl.check(key);
            if (time < 0L) {
                throw new IllegalArgumentException("Time cannot be negative. time = " + time);
            }
            this.mapOperationCounter.incrementOtherOperations();
            long timeoutMillis = Util.toMillis(time, timeunit);
            return MProxyImpl.this.concurrentMapManager.lock(MProxyImpl.this.name, key, timeoutMillis);
        }

        public void unlock(Object key) {
            MProxyImpl.check(key);
            this.mapOperationCounter.incrementOtherOperations();
            ConcurrentMapManager.MLock mlock = MProxyImpl.this.concurrentMapManager.new ConcurrentMapManager.MLock();
            if (!mlock.unlock(MProxyImpl.this.name, key, 0L)) {
                throw new IllegalMonitorStateException("Current thread is not owner of the lock!");
            }
        }

        public void forceUnlock(Object key) {
            MProxyImpl.check(key);
            this.mapOperationCounter.incrementOtherOperations();
            ConcurrentMapManager.MLock mlock = MProxyImpl.this.concurrentMapManager.new ConcurrentMapManager.MLock();
            mlock.forceUnlock(MProxyImpl.this.name, key);
        }

        public void putAndUnlock(Object key, Object value) {
            long begin = Clock.currentTimeMillis();
            MProxyImpl.check(key);
            MProxyImpl.check(value);
            MProxyImpl.this.concurrentMapManager.putAndUnlock(MProxyImpl.this.name, key, value);
            this.mapOperationCounter.incrementPuts(Clock.currentTimeMillis() - begin);
        }

        public Object putIfAbsent(Object key, Object value) {
            return this.putIfAbsent(key, value, -1L);
        }

        public Object putIfAbsent(Object key, Object value, long ttl, TimeUnit timeunit) {
            if (ttl < 0L) {
                throw new IllegalArgumentException("ttl value cannot be negative. " + ttl);
            }
            ttl = ttl == 0L ? -1L : Util.toMillis(ttl, timeunit);
            return this.putIfAbsent(key, value, ttl);
        }

        private Object putIfAbsent(Object key, Object value, long ttl) {
            long begin = Clock.currentTimeMillis();
            MProxyImpl.check(key);
            MProxyImpl.check(value);
            ConcurrentMapManager.MPut mput = MProxyImpl.this.concurrentMapManager.new ConcurrentMapManager.MPut();
            Object result = mput.putIfAbsent(MProxyImpl.this.name, key, value, ttl);
            mput.clearRequest();
            this.mapOperationCounter.incrementPuts(Clock.currentTimeMillis() - begin);
            return result;
        }

        public Object get(Object key) {
            MProxyImpl.check(key);
            long begin = Clock.currentTimeMillis();
            ConcurrentMapManager.MGet mget = ThreadContext.get().getCallCache(MProxyImpl.this.factory).getMGet();
            Object result = mget.get(MProxyImpl.this.name, key, -1L);
            mget.clearRequest();
            this.mapOperationCounter.incrementGets(Clock.currentTimeMillis() - begin);
            return result;
        }

        public Object remove(Object key) {
            long begin = Clock.currentTimeMillis();
            MProxyImpl.check(key);
            ConcurrentMapManager.MRemove mremove = ThreadContext.get().getCallCache(MProxyImpl.this.factory).getMRemove();
            Object result = mremove.remove(MProxyImpl.this.name, key);
            mremove.clearRequest();
            this.mapOperationCounter.incrementRemoves(Clock.currentTimeMillis() - begin);
            return result;
        }

        public Object tryRemove(Object key, long timeout, TimeUnit timeunit) throws TimeoutException {
            long begin = Clock.currentTimeMillis();
            MProxyImpl.check(key);
            ConcurrentMapManager.MRemove mremove = ThreadContext.get().getCallCache(MProxyImpl.this.factory).getMRemove();
            Object result = mremove.tryRemove(MProxyImpl.this.name, key, Util.toMillis(timeout, timeunit));
            mremove.clearRequest();
            this.mapOperationCounter.incrementRemoves(Clock.currentTimeMillis() - begin);
            return result;
        }

        public int size() {
            this.mapOperationCounter.incrementOtherOperations();
            return MProxyImpl.this.concurrentMapManager.size(MProxyImpl.this.name);
        }

        public int valueCount(Object key) {
            this.mapOperationCounter.incrementOtherOperations();
            ConcurrentMapManager.MValueCount mcount = MProxyImpl.this.concurrentMapManager.new ConcurrentMapManager.MValueCount();
            int count = ((Number)mcount.count(MProxyImpl.this.name, key, -1L)).intValue();
            return count;
        }

        public boolean removeMulti(Object key, Object value) {
            MProxyImpl.check(key);
            MProxyImpl.check(value);
            ConcurrentMapManager.MRemoveMulti mremove = MProxyImpl.this.concurrentMapManager.new ConcurrentMapManager.MRemoveMulti();
            return mremove.remove(MProxyImpl.this.name, key, value);
        }

        public boolean remove(Object key, Object value) {
            long begin = Clock.currentTimeMillis();
            MProxyImpl.check(key);
            MProxyImpl.check(value);
            ConcurrentMapManager.MRemove mremove = MProxyImpl.this.concurrentMapManager.new ConcurrentMapManager.MRemove();
            boolean result = mremove.removeIfSame(MProxyImpl.this.name, key, value);
            this.mapOperationCounter.incrementRemoves(Clock.currentTimeMillis() - begin);
            return result;
        }

        public Object replace(Object key, Object value) {
            long begin = Clock.currentTimeMillis();
            MProxyImpl.check(key);
            MProxyImpl.check(value);
            ConcurrentMapManager.MPut mput = MProxyImpl.this.concurrentMapManager.new ConcurrentMapManager.MPut();
            Object result = mput.replace(MProxyImpl.this.name, key, value);
            this.mapOperationCounter.incrementPuts(Clock.currentTimeMillis() - begin);
            return result;
        }

        public boolean replace(Object key, Object oldValue, Object newValue) {
            long begin = Clock.currentTimeMillis();
            MProxyImpl.check(key);
            MProxyImpl.check(oldValue);
            MProxyImpl.check(newValue);
            ConcurrentMapManager.MPut mput = MProxyImpl.this.concurrentMapManager.new ConcurrentMapManager.MPut();
            Boolean result = mput.replace(MProxyImpl.this.name, key, oldValue, newValue);
            this.mapOperationCounter.incrementPuts(Clock.currentTimeMillis() - begin);
            return result;
        }

        public LocalMapStats getLocalMapStats() {
            this.mapOperationCounter.incrementOtherOperations();
            LocalMapStatsImpl localMapStats = MProxyImpl.this.concurrentMapManager.getLocalMapStats(MProxyImpl.this.name);
            localMapStats.setOperationStats(this.mapOperationCounter.getPublishedStats());
            return localMapStats;
        }

        public void addGenericListener(Object listener, Object key, boolean includeValue, Instance.InstanceType instanceType) {
            if (listener == null) {
                throw new IllegalArgumentException("Listener cannot be null");
            }
            MProxyImpl.this.listenerManager.addListener(MProxyImpl.this.name, listener, key, includeValue, instanceType);
        }

        public void removeGenericListener(Object listener, Object key) {
            if (listener == null) {
                throw new IllegalArgumentException("Listener cannot be null");
            }
            MProxyImpl.this.listenerManager.removeListener(MProxyImpl.this.name, listener, key);
        }

        public void addLocalEntryListener(EntryListener listener) {
            if (listener == null) {
                throw new IllegalArgumentException("Listener cannot be null");
            }
            MProxyImpl.this.listenerManager.addLocalListener(MProxyImpl.this.name, listener, this.getInstanceType());
        }

        public void addEntryListener(EntryListener listener, boolean includeValue) {
            if (listener == null) {
                throw new IllegalArgumentException("Listener cannot be null");
            }
            this.addGenericListener(listener, null, includeValue, this.getInstanceType());
        }

        public void addEntryListener(EntryListener listener, Object key, boolean includeValue) {
            if (listener == null) {
                throw new IllegalArgumentException("Listener cannot be null");
            }
            MProxyImpl.check(key);
            this.addGenericListener(listener, key, includeValue, this.getInstanceType());
        }

        public void removeEntryListener(EntryListener listener) {
            if (listener == null) {
                throw new IllegalArgumentException("Listener cannot be null");
            }
            this.removeGenericListener(listener, null);
        }

        public void removeEntryListener(EntryListener listener, Object key) {
            if (listener == null) {
                throw new IllegalArgumentException("Listener cannot be null");
            }
            MProxyImpl.check(key);
            this.removeGenericListener(listener, key);
        }

        public boolean containsEntry(Object key, Object value) {
            MProxyImpl.check(key);
            MProxyImpl.check(value);
            this.mapOperationCounter.incrementOtherOperations();
            TransactionImpl txn = ThreadContext.get().getCallContext().getTransaction();
            if (txn != null && txn.has(MProxyImpl.this.name, key) && txn.containsEntry(MProxyImpl.this.name, key, value)) {
                return true;
            }
            ConcurrentMapManager.MContainsKey mContainsKey = MProxyImpl.this.concurrentMapManager.new ConcurrentMapManager.MContainsKey();
            return mContainsKey.containsEntry(MProxyImpl.this.name, key, value);
        }

        public boolean containsKey(Object key) {
            MProxyImpl.check(key);
            this.mapOperationCounter.incrementOtherOperations();
            TransactionImpl txn = ThreadContext.get().getCallContext().getTransaction();
            if (txn != null && txn.has(MProxyImpl.this.name, key)) {
                Data value = txn.get(MProxyImpl.this.name, key);
                return value != null;
            }
            ConcurrentMapManager.MContainsKey mContainsKey = MProxyImpl.this.concurrentMapManager.new ConcurrentMapManager.MContainsKey();
            return mContainsKey.containsKey(MProxyImpl.this.name, key);
        }

        public boolean containsValue(Object value) {
            MProxyImpl.check(value);
            this.mapOperationCounter.incrementOtherOperations();
            TransactionImpl txn = ThreadContext.get().getCallContext().getTransaction();
            if (txn != null && txn.containsValue(MProxyImpl.this.name, value)) {
                return true;
            }
            ConcurrentMapManager concurrentMapManager = MProxyImpl.this.concurrentMapManager;
            concurrentMapManager.getClass();
            ConcurrentMapManager.MContainsValue mContainsValue = concurrentMapManager.new ConcurrentMapManager.MContainsValue(MProxyImpl.this.name, value);
            return (Boolean)mContainsValue.call();
        }

        public boolean isEmpty() {
            this.mapOperationCounter.incrementOtherOperations();
            ConcurrentMapManager.MEmpty mempty = MProxyImpl.this.concurrentMapManager.new ConcurrentMapManager.MEmpty();
            return mempty.isEmpty(MProxyImpl.this.name);
        }

        public void putAll(Map map) {
            Set entries = map.entrySet();
            TransactionImpl txn = ThreadContext.get().getCallContext().getTransaction();
            if (txn != null && txn.getStatus() == 1) {
                for (Map.Entry entry : entries) {
                    this.put(entry.getKey(), entry.getValue());
                }
            } else {
                MProxyImpl.this.concurrentMapManager.doPutAll(MProxyImpl.this.name, map);
            }
        }

        public boolean add(Object value) {
            MProxyImpl.check(value);
            Object old = this.putIfAbsent(value, IOUtil.toData(Boolean.TRUE));
            return old == null;
        }

        public boolean removeKey(Object key) {
            long begin = Clock.currentTimeMillis();
            MProxyImpl.check(key);
            ConcurrentMapManager.MRemoveItem mRemoveItem = MProxyImpl.this.concurrentMapManager.new ConcurrentMapManager.MRemoveItem();
            boolean result = mRemoveItem.removeItem(MProxyImpl.this.name, key);
            this.mapOperationCounter.incrementRemoves(Clock.currentTimeMillis() - begin);
            return result;
        }

        public void clear() {
            Set keys = this.keySet();
            for (Object key : keys) {
                this.removeKey(key);
            }
        }

        public Set localKeySet() {
            return this.localKeySet(null);
        }

        public Set localKeySet(Predicate predicate) {
            this.mapOperationCounter.incrementOtherOperations();
            return MProxyImpl.this.concurrentMapManager.queryLocal(MProxyImpl.this.name, ClusterOperation.CONCURRENT_MAP_ITERATE_KEYS, predicate);
        }

        public Set entrySet(Predicate predicate) {
            return (Set)this.query(ClusterOperation.CONCURRENT_MAP_ITERATE_ENTRIES, predicate);
        }

        public Set keySet(Predicate predicate) {
            return (Set)this.query(ClusterOperation.CONCURRENT_MAP_ITERATE_KEYS, predicate);
        }

        public Collection values(Predicate predicate) {
            return this.query(ClusterOperation.CONCURRENT_MAP_ITERATE_VALUES, predicate);
        }

        public Set entrySet() {
            return (Set)this.query(ClusterOperation.CONCURRENT_MAP_ITERATE_ENTRIES, null);
        }

        public Set keySet() {
            return (Set)this.query(ClusterOperation.CONCURRENT_MAP_ITERATE_KEYS, null);
        }

        public Set allKeys() {
            return (Set)this.query(ClusterOperation.CONCURRENT_MAP_ITERATE_KEYS_ALL, null);
        }

        public MapOperationsCounter getMapOperationCounter() {
            return this.mapOperationCounter;
        }

        public Collection values() {
            return this.query(ClusterOperation.CONCURRENT_MAP_ITERATE_VALUES, null);
        }

        private Collection query(ClusterOperation iteratorType, Predicate predicate) {
            this.mapOperationCounter.incrementOtherOperations();
            return MProxyImpl.this.concurrentMapManager.query(MProxyImpl.this.name, iteratorType, predicate);
        }

        public void destroy() {
            MProxyImpl.this.factory.destroyInstanceClusterWide(MProxyImpl.this.name, null);
        }

        public boolean evict(Object key) {
            this.mapOperationCounter.incrementOtherOperations();
            ConcurrentMapManager.MEvict mevict = ThreadContext.get().getCallCache(MProxyImpl.this.factory).getMEvict();
            boolean result = mevict.evict(MProxyImpl.this.name, key);
            mevict.clearRequest();
            return result;
        }

        public void setHazelcastInstance(HazelcastInstance hazelcastInstance) {
        }
    }

    class DynamicInvoker
    implements InvocationHandler {
        DynamicInvoker() {
        }

        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            Object object;
            MProxyImpl.this.beforeCall();
            try {
                object = method.invoke((Object)MProxyImpl.this.mproxyReal, args);
                Object var7_6 = null;
            }
            catch (Throwable e) {
                try {
                    if (e instanceof InvocationTargetException) {
                        InvocationTargetException ite = (InvocationTargetException)e;
                        throw ite.getCause();
                    }
                    throw e;
                }
                catch (Throwable throwable) {
                    Object var7_7 = null;
                    MProxyImpl.this.afterCall();
                    throw throwable;
                }
            }
            MProxyImpl.this.afterCall();
            return object;
        }
    }
}

