/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.impl.ascii;

import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.impl.Node;
import com.hazelcast.impl.ThreadContext;
import com.hazelcast.impl.ascii.AbstractTextCommand;
import com.hazelcast.impl.ascii.NoOpCommandProcessor;
import com.hazelcast.impl.ascii.TextCommand;
import com.hazelcast.impl.ascii.TextCommandConstants;
import com.hazelcast.impl.ascii.TextCommandProcessor;
import com.hazelcast.impl.ascii.TextCommandService;
import com.hazelcast.impl.ascii.memcache.DeleteCommandProcessor;
import com.hazelcast.impl.ascii.memcache.ErrorCommandProcessor;
import com.hazelcast.impl.ascii.memcache.GetCommandProcessor;
import com.hazelcast.impl.ascii.memcache.SetCommandProcessor;
import com.hazelcast.impl.ascii.memcache.SimpleCommandProcessor;
import com.hazelcast.impl.ascii.memcache.Stats;
import com.hazelcast.impl.ascii.memcache.StatsCommandProcessor;
import com.hazelcast.impl.ascii.rest.HttpDeleteCommandProcessor;
import com.hazelcast.impl.ascii.rest.HttpGetCommandProcessor;
import com.hazelcast.impl.ascii.rest.HttpPostCommandProcessor;
import com.hazelcast.impl.ascii.rest.RestValue;
import com.hazelcast.impl.executor.ParallelExecutor;
import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.ascii.SocketTextWriter;
import com.hazelcast.util.Clock;
import com.hazelcast.util.SimpleBlockingQueue;
import java.nio.ByteBuffer;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;

public class TextCommandServiceImpl
implements TextCommandService,
TextCommandConstants {
    private final Node node;
    private final ParallelExecutor parallelExecutor;
    private final TextCommandProcessor[] textCommandProcessors = new TextCommandProcessor[100];
    private final HazelcastInstance hazelcast;
    private final AtomicLong gets = new AtomicLong();
    private final AtomicLong sets = new AtomicLong();
    private final AtomicLong deletes = new AtomicLong();
    private final AtomicLong getHits = new AtomicLong();
    private final long startTime = Clock.currentTimeMillis();
    private volatile ResponseThreadRunnable responseThreadRunnable;
    private volatile boolean running = true;
    private final ILogger logger;

    public TextCommandServiceImpl(Node node) {
        this.node = node;
        this.hazelcast = node.factory;
        this.logger = node.getLogger(this.getClass().getName());
        this.parallelExecutor = this.node.executorManager.newParallelExecutor(40);
        this.textCommandProcessors[TextCommandConstants.TextCommandType.GET.getValue()] = new GetCommandProcessor(this, true);
        this.textCommandProcessors[TextCommandConstants.TextCommandType.PARTIAL_GET.getValue()] = new GetCommandProcessor(this, false);
        this.textCommandProcessors[TextCommandConstants.TextCommandType.SET.getValue()] = new SetCommandProcessor(this);
        this.textCommandProcessors[TextCommandConstants.TextCommandType.ADD.getValue()] = new SetCommandProcessor(this);
        this.textCommandProcessors[TextCommandConstants.TextCommandType.REPLACE.getValue()] = new SetCommandProcessor(this);
        this.textCommandProcessors[TextCommandConstants.TextCommandType.GET_END.getValue()] = new NoOpCommandProcessor(this);
        this.textCommandProcessors[TextCommandConstants.TextCommandType.DELETE.getValue()] = new DeleteCommandProcessor(this);
        this.textCommandProcessors[TextCommandConstants.TextCommandType.QUIT.getValue()] = new SimpleCommandProcessor(this);
        this.textCommandProcessors[TextCommandConstants.TextCommandType.STATS.getValue()] = new StatsCommandProcessor(this);
        this.textCommandProcessors[TextCommandConstants.TextCommandType.UNKNOWN.getValue()] = new ErrorCommandProcessor(this);
        this.textCommandProcessors[TextCommandConstants.TextCommandType.ERROR_CLIENT.getValue()] = new ErrorCommandProcessor(this);
        this.textCommandProcessors[TextCommandConstants.TextCommandType.ERROR_SERVER.getValue()] = new ErrorCommandProcessor(this);
        this.textCommandProcessors[TextCommandConstants.TextCommandType.HTTP_GET.getValue()] = new HttpGetCommandProcessor(this);
        this.textCommandProcessors[TextCommandConstants.TextCommandType.HTTP_POST.getValue()] = new HttpPostCommandProcessor(this);
        this.textCommandProcessors[TextCommandConstants.TextCommandType.HTTP_PUT.getValue()] = new HttpPostCommandProcessor(this);
        this.textCommandProcessors[TextCommandConstants.TextCommandType.HTTP_DELETE.getValue()] = new HttpDeleteCommandProcessor(this);
        this.textCommandProcessors[TextCommandConstants.TextCommandType.NO_OP.getValue()] = new NoOpCommandProcessor(this);
    }

    public Node getNode() {
        return this.node;
    }

    public Stats getStats() {
        Stats stats = new Stats();
        stats.uptime = (int)((Clock.currentTimeMillis() - this.startTime) / 1000L);
        stats.threads = this.parallelExecutor.getActiveCount();
        stats.waiting_requests = this.parallelExecutor.getPoolSize();
        stats.cmd_get = this.gets.get();
        stats.cmd_set = this.sets.get();
        stats.cmd_delete = this.deletes.get();
        stats.get_hits = this.getHits.get();
        stats.get_misses = this.gets.get() - this.getHits.get();
        stats.curr_connections = this.node.connectionManager.getCurrentClientConnections();
        stats.total_connections = this.node.connectionManager.getAllTextConnections();
        return stats;
    }

    public long incrementDeleteCount() {
        return this.deletes.incrementAndGet();
    }

    public long incrementGetCount() {
        return this.gets.incrementAndGet();
    }

    public long incrementSetCount() {
        return this.sets.incrementAndGet();
    }

    public long incrementHitCount() {
        return this.getHits.incrementAndGet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processRequest(TextCommand command) {
        if (this.responseThreadRunnable == null) {
            TextCommandServiceImpl textCommandServiceImpl = this;
            synchronized (textCommandServiceImpl) {
                if (this.responseThreadRunnable == null) {
                    this.responseThreadRunnable = new ResponseThreadRunnable();
                    Thread thread = new Thread(this.node.threadGroup, this.responseThreadRunnable, "hz.ascii.service.response.thread");
                    thread.start();
                }
            }
        }
        this.parallelExecutor.execute(new CommandExecutor(command));
    }

    public Object get(String mapName, String key) {
        return this.hazelcast.getMap(mapName).get(key);
    }

    public int getAdjustedTTLSeconds(int ttl) {
        if (ttl <= 2592000) {
            return ttl;
        }
        return ttl - (int)(Clock.currentTimeMillis() / 1000L);
    }

    public byte[] getByteArray(String mapName, String key) {
        Object value = this.hazelcast.getMap(mapName).get(key);
        byte[] result = null;
        if (value != null) {
            if (value instanceof RestValue) {
                RestValue restValue = (RestValue)value;
                result = restValue.getValue();
            } else {
                result = value instanceof byte[] ? (byte[])value : ThreadContext.get().toByteArray(value);
            }
        }
        return result;
    }

    public Object put(String mapName, String key, Object value, int ttlSeconds) {
        return this.hazelcast.getMap(mapName).put(key, value, ttlSeconds, TimeUnit.SECONDS);
    }

    public Object putIfAbsent(String mapName, String key, Object value, int ttlSeconds) {
        return this.hazelcast.getMap(mapName).putIfAbsent(key, value, ttlSeconds, TimeUnit.SECONDS);
    }

    public Object replace(String mapName, String key, Object value) {
        return this.hazelcast.getMap(mapName).replace(key, value);
    }

    public Object delete(String mapName, String key) {
        return this.hazelcast.getMap(mapName).remove(key);
    }

    public boolean offer(String queueName, Object value) {
        return this.hazelcast.getQueue(queueName).offer(value);
    }

    public Object poll(String queueName, int seconds) {
        try {
            return this.hazelcast.getQueue(queueName).poll(seconds, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            return null;
        }
    }

    public Object poll(String queueName) {
        return this.hazelcast.getQueue(queueName).poll();
    }

    public void sendResponse(TextCommand textCommand) {
        if (!textCommand.shouldReply() || textCommand.getRequestId() == -1L) {
            throw new RuntimeException("Shouldn't reply " + textCommand);
        }
        this.responseThreadRunnable.sendResponse(textCommand);
    }

    public void stop() {
        if (this.responseThreadRunnable != null) {
            this.responseThreadRunnable.stop();
        }
    }

    class ResponseThreadRunnable
    implements Runnable {
        private final BlockingQueue<TextCommand> blockingQueue = new SimpleBlockingQueue<TextCommand>();
        private final Object stopObject = new Object();

        ResponseThreadRunnable() {
        }

        public void sendResponse(TextCommand textCommand) {
            this.blockingQueue.offer(textCommand);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (TextCommandServiceImpl.this.running) {
                try {
                    TextCommand textCommand = this.blockingQueue.take();
                    if (TextCommandConstants.TextCommandType.STOP == textCommand.getType()) {
                        Object object = this.stopObject;
                        synchronized (object) {
                            this.stopObject.notify();
                            continue;
                        }
                    }
                    SocketTextWriter socketTextWriter = textCommand.getSocketTextWriter();
                    socketTextWriter.enqueue(textCommand);
                }
                catch (InterruptedException e) {
                    return;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void stop() {
            TextCommandServiceImpl.this.running = false;
            Object object = this.stopObject;
            synchronized (object) {
                try {
                    this.blockingQueue.offer(new AbstractTextCommand(TextCommandConstants.TextCommandType.STOP){

                        public boolean doRead(ByteBuffer cb) {
                            return true;
                        }

                        public boolean writeTo(ByteBuffer bb) {
                            return true;
                        }
                    });
                    this.stopObject.wait(1000L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    class CommandExecutor
    implements Runnable {
        final TextCommand command;

        CommandExecutor(TextCommand command) {
            this.command = command;
        }

        public void run() {
            try {
                TextCommandConstants.TextCommandType type = this.command.getType();
                TextCommandServiceImpl.this.textCommandProcessors[type.getValue()].handle(this.command);
            }
            catch (Throwable e) {
                TextCommandServiceImpl.this.logger.log(Level.WARNING, e.getMessage(), e);
            }
        }
    }
}

