/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.impl;

import com.hazelcast.cluster.ClusterImpl;
import com.hazelcast.config.EntryListenerConfig;
import com.hazelcast.config.MapConfig;
import com.hazelcast.config.MapIndexConfig;
import com.hazelcast.config.MapStoreConfig;
import com.hazelcast.config.MaxSizeConfig;
import com.hazelcast.config.MergePolicyConfig;
import com.hazelcast.config.MultiMapConfig;
import com.hazelcast.config.NearCacheConfig;
import com.hazelcast.config.QueueConfig;
import com.hazelcast.config.WanReplicationRef;
import com.hazelcast.core.EntryEvent;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.HazelcastInstanceAware;
import com.hazelcast.core.Instance;
import com.hazelcast.core.MapEntry;
import com.hazelcast.core.MapLoader;
import com.hazelcast.core.MapStore;
import com.hazelcast.core.MapStoreFactory;
import com.hazelcast.core.Member;
import com.hazelcast.impl.ClusterOperation;
import com.hazelcast.impl.ConcurrentMapManager;
import com.hazelcast.impl.DefaultRecord;
import com.hazelcast.impl.FactoryImpl;
import com.hazelcast.impl.LocalUpdateListener;
import com.hazelcast.impl.MProxy;
import com.hazelcast.impl.MapMaxSizePolicy;
import com.hazelcast.impl.MemberImpl;
import com.hazelcast.impl.NearCache;
import com.hazelcast.impl.Node;
import com.hazelcast.impl.PartitionManager;
import com.hazelcast.impl.PartitionServiceImpl;
import com.hazelcast.impl.Processable;
import com.hazelcast.impl.Record;
import com.hazelcast.impl.Request;
import com.hazelcast.impl.VersionedBackupOp;
import com.hazelcast.impl.base.DataRecordEntry;
import com.hazelcast.impl.base.DistributedLock;
import com.hazelcast.impl.base.ScheduledAction;
import com.hazelcast.impl.base.Values;
import com.hazelcast.impl.concurrentmap.LFUMapEntryComparator;
import com.hazelcast.impl.concurrentmap.LRUMapEntryComparator;
import com.hazelcast.impl.concurrentmap.LocalLock;
import com.hazelcast.impl.concurrentmap.MapStoreWrapper;
import com.hazelcast.impl.concurrentmap.ValueHolder;
import com.hazelcast.impl.monitor.LocalMapStatsImpl;
import com.hazelcast.impl.partition.PartitionInfo;
import com.hazelcast.logging.ILogger;
import com.hazelcast.merge.MergePolicy;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.Data;
import com.hazelcast.nio.DataSerializable;
import com.hazelcast.nio.IOUtil;
import com.hazelcast.nio.Packet;
import com.hazelcast.nio.Serializer;
import com.hazelcast.query.Expression;
import com.hazelcast.query.MapIndexService;
import com.hazelcast.query.Predicates;
import com.hazelcast.util.Clock;
import com.hazelcast.util.ConcurrentHashSet;
import com.hazelcast.util.SortedHashMap;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CMap {
    private static final Comparator<MapEntry> LRU_COMPARATOR = new LRUMapEntryComparator();
    private static final Comparator<MapEntry> LFU_COMPARATOR = new LFUMapEntryComparator();
    private final ILogger logger;
    private final Object initLock = new Object();
    private volatile InitializationState initState = InitializationState.NONE;
    private final Node node;
    private final Address thisAddress;
    private final MapConfig mapConfig;
    private final MultiMapConfig multiMapConfig;
    private final Map<Address, Boolean> mapListeners = new HashMap<Address, Boolean>(1);
    private int backupCount;
    private int asyncBackupCount;
    private EvictionPolicy evictionPolicy;
    private Comparator<MapEntry> evictionComparator;
    private MapMaxSizePolicy maxSizePolicy;
    private float evictionRate;
    private long ttl;
    private long maxIdle;
    private final Instance.InstanceType instanceType;
    private boolean readBackupData;
    private boolean cacheValue;
    private volatile boolean ttlPerRecord = false;
    private volatile boolean dirty = false;
    private volatile long lastCleanup = Clock.currentTimeMillis();
    private volatile long lastEvictionTime = 0L;
    private DistributedLock lockEntireMap = null;
    private final LocalUpdateListener localUpdateListener;
    private final AtomicBoolean cleanupActive = new AtomicBoolean(false);
    private volatile long totalCostOfRecords = 0L;
    private MapStoreWrapper mapStoreWrapper;
    final MapLoader loader;
    final MapStore store;
    final ConcurrentMapManager concurrentMapManager;
    final ConcurrentMap<Data, Record> mapRecords = new ConcurrentHashMap<Data, Record>(10000, 0.75f, 1);
    final String name;
    final MergePolicy mergePolicy;
    final long writeDelayMillis;
    final long removeDelayMillis;
    final long cleanupDelayMillis;
    final MapIndexService mapIndexService;
    final NearCache nearCache;
    final long creationTime;
    final boolean multiMapSet;
    final boolean mapForQueue;
    final MergePolicy wanMergePolicy;
    final ConcurrentMap<Data, LocalLock> mapLocalLocks = new ConcurrentHashMap<Data, LocalLock>(10000);
    int count = 0;

    CMap(ConcurrentMapManager concurrentMapManager, String name) {
        this.concurrentMapManager = concurrentMapManager;
        this.logger = concurrentMapManager.node.getLogger(CMap.class.getName());
        this.node = concurrentMapManager.node;
        this.thisAddress = concurrentMapManager.thisAddress;
        this.name = name;
        this.mapForQueue = name.startsWith("c:q:");
        this.instanceType = ConcurrentMapManager.getInstanceType(name);
        String mapConfigName = name.substring(2);
        if (this.isMultiMap() || mapConfigName.startsWith("__hz_") || mapConfigName.startsWith("l:") || mapConfigName.startsWith("s:")) {
            this.mapConfig = new MapConfig();
        } else if (this.mapForQueue) {
            String queueShortName = name.substring(4);
            QueueConfig qConfig = this.node.getConfig().findMatchingQueueConfig(queueShortName);
            this.mapConfig = this.node.getConfig().findMatchingMapConfig(qConfig.getBackingMapRef());
        } else {
            this.mapConfig = this.node.getConfig().findMatchingMapConfig(mapConfigName);
        }
        this.mapIndexService = new MapIndexService(this.mapConfig.isValueIndexed());
        this.setRuntimeConfig(this.mapConfig);
        if (this.mapForQueue || this.node.groupProperties.ELASTIC_MEMORY_ENABLED.getBoolean()) {
            this.cacheValue = false;
        }
        MapStoreConfig mapStoreConfig = this.mapConfig.getMapStoreConfig();
        int writeDelaySeconds = -1;
        if (!this.node.isLiteMember() && mapStoreConfig != null) {
            try {
                MapLoader storeInstance;
                String factoryClassName;
                MapStoreFactory factory = (MapStoreFactory)mapStoreConfig.getFactoryImplementation();
                if (factory == null && (factoryClassName = mapStoreConfig.getFactoryClassName()) != null && !"".equals(factoryClassName)) {
                    factory = (MapStoreFactory)Serializer.loadClass(this.node.getConfig().getClassLoader(), factoryClassName).newInstance();
                }
                MapLoader mapLoader = storeInstance = factory == null ? mapStoreConfig.getImplementation() : factory.newMapStore(name, mapStoreConfig.getProperties());
                if (storeInstance == null) {
                    String mapStoreClassName = mapStoreConfig.getClassName();
                    storeInstance = Serializer.loadClass(this.node.getConfig().getClassLoader(), mapStoreClassName).newInstance();
                }
                this.mapStoreWrapper = new MapStoreWrapper(storeInstance, this.node.factory.getHazelcastInstanceProxy(), mapStoreConfig.getProperties(), mapConfigName, mapStoreConfig.isEnabled());
                if (!this.mapStoreWrapper.isMapLoader() && !this.mapStoreWrapper.isMapStore()) {
                    throw new Exception("MapStore class [" + storeInstance.getClass().getName() + "] should implement either MapLoader or MapStore!");
                }
            }
            catch (Exception e) {
                this.logger.log(Level.SEVERE, e.getMessage(), e);
            }
            writeDelaySeconds = mapStoreConfig.getWriteDelaySeconds();
        }
        this.writeDelayMillis = writeDelaySeconds == -1 ? -1L : (long)writeDelaySeconds * 1000L;
        this.removeDelayMillis = writeDelaySeconds > 0 ? concurrentMapManager.GLOBAL_REMOVE_DELAY_MILLIS + this.writeDelayMillis : concurrentMapManager.GLOBAL_REMOVE_DELAY_MILLIS;
        this.loader = this.mapStoreWrapper == null || !this.mapStoreWrapper.isMapLoader() ? null : this.mapStoreWrapper;
        this.store = this.mapStoreWrapper == null || !this.mapStoreWrapper.isMapStore() ? null : this.mapStoreWrapper;
        NearCacheConfig nearCacheConfig = this.mapConfig.getNearCacheConfig();
        if (nearCacheConfig == null) {
            this.nearCache = null;
        } else {
            NearCache nearCache = new NearCache(this, SortedHashMap.getOrderingTypeByName(nearCacheConfig.getEvictionPolicy()), nearCacheConfig.getMaxSize(), (long)nearCacheConfig.getTimeToLiveSeconds() * 1000L, (long)nearCacheConfig.getMaxIdleSeconds() * 1000L, nearCacheConfig.isInvalidateOnChange());
            NearCache anotherNearCache = concurrentMapManager.mapCaches.putIfAbsent(name, nearCache);
            if (anotherNearCache != null) {
                nearCache = anotherNearCache;
            }
            this.nearCache = nearCache;
        }
        int CLEANUP_DELAY_SECONDS = this.node.groupProperties.CLEANUP_DELAY_SECONDS.getInteger();
        if (CLEANUP_DELAY_SECONDS <= 0) {
            this.logger.log(Level.WARNING, "hazelcast.map.cleanup.delay.seconds must be greater than zero. Setting to 1.");
            CLEANUP_DELAY_SECONDS = 1;
        }
        this.cleanupDelayMillis = CLEANUP_DELAY_SECONDS * 1000;
        this.mergePolicy = this.getMergePolicy(this.mapConfig.getMergePolicy());
        this.creationTime = Clock.currentTimeMillis();
        WanReplicationRef wanReplicationRef = this.mapConfig.getWanReplicationRef();
        if (wanReplicationRef != null) {
            this.localUpdateListener = this.node.wanReplicationService.getWanReplication(wanReplicationRef.getName());
            this.wanMergePolicy = this.getMergePolicy(wanReplicationRef.getMergePolicy());
        } else {
            this.localUpdateListener = null;
            this.wanMergePolicy = null;
        }
        if (this.instanceType.isMultiMap()) {
            String shortMultiMapName = name.substring(4);
            this.multiMapConfig = this.node.getConfig().getMultiMapConfig(shortMultiMapName);
            this.multiMapSet = this.multiMapConfig.getValueCollectionType() == MultiMapConfig.ValueCollectionType.SET;
        } else {
            this.multiMapConfig = null;
            this.multiMapSet = false;
        }
        if (!this.mapForQueue) {
            this.initializeIndexes();
            this.initializeListeners();
        }
    }

    private void initializeIndexes() {
        for (MapIndexConfig index : this.mapConfig.getMapIndexConfigs()) {
            if (index.getAttribute() != null) {
                this.addIndex(Predicates.get(index.getAttribute()), index.isOrdered(), -1);
                continue;
            }
            if (index.getExpression() == null) continue;
            this.addIndex(index.getExpression(), index.isOrdered(), -1);
        }
    }

    private void initializeListeners() {
        List<EntryListenerConfig> listenerConfigs = null;
        listenerConfigs = this.isMultiMap() ? this.multiMapConfig.getEntryListenerConfigs() : this.mapConfig.getEntryListenerConfigs();
        if (listenerConfigs != null && !listenerConfigs.isEmpty()) {
            for (EntryListenerConfig lc : listenerConfigs) {
                try {
                    this.node.listenerManager.createAndAddListenerItem(this.name, lc, this.instanceType);
                    if (lc.isLocal()) {
                        this.addListener(null, this.thisAddress, lc.isIncludeValue());
                        continue;
                    }
                    for (MemberImpl member : this.node.clusterManager.getMembers()) {
                        this.addListener(null, member.getAddress(), lc.isIncludeValue());
                    }
                }
                catch (Throwable e) {
                    this.logger.log(Level.SEVERE, e.getMessage(), e);
                }
            }
        }
    }

    MergePolicy getMergePolicy(String mergePolicyName) {
        MergePolicyConfig mergePolicyConfig;
        MergePolicy mergePolicyTemp = null;
        if (mergePolicyName != null && !"hz.NO_MERGE".equalsIgnoreCase(mergePolicyName) && (mergePolicyConfig = this.node.getConfig().getMergePolicyConfig(mergePolicyName)) != null && (mergePolicyTemp = mergePolicyConfig.getImplementation()) == null) {
            String mergeClassName = mergePolicyConfig.getClassName();
            try {
                mergePolicyTemp = (MergePolicy)Serializer.loadClass(this.node.getConfig().getClassLoader(), mergeClassName).newInstance();
            }
            catch (Exception e) {
                this.logger.log(Level.SEVERE, e.getMessage(), e);
            }
        }
        return mergePolicyTemp;
    }

    public void setRuntimeConfig(MapConfig mapConfig) {
        this.backupCount = mapConfig.getBackupCount();
        this.asyncBackupCount = mapConfig.getAsyncBackupCount();
        this.ttl = (long)mapConfig.getTimeToLiveSeconds() * 1000L;
        this.maxIdle = (long)mapConfig.getMaxIdleSeconds() * 1000L;
        this.evictionPolicy = mapConfig.getEvictionPolicy() != null ? EvictionPolicy.valueOf(mapConfig.getEvictionPolicy()) : EvictionPolicy.NONE;
        this.readBackupData = mapConfig.isReadBackupData();
        this.cacheValue = mapConfig.isCacheValue();
        MaxSizeConfig maxSizeConfig = mapConfig.getMaxSizeConfig();
        this.maxSizePolicy = "map_size_per_jvm".equals(maxSizeConfig.getMaxSizePolicy()) ? new MaxSizePerJVMPolicy(maxSizeConfig) : ("cluster_wide_map_size".equals(maxSizeConfig.getMaxSizePolicy()) ? new MaxSizeClusterWidePolicy(maxSizeConfig) : ("partitions_wide_map_size".equals(maxSizeConfig.getMaxSizePolicy()) ? new MaxSizePartitionsWidePolicy(maxSizeConfig) : ("used_heap_size".equals(maxSizeConfig.getMaxSizePolicy()) ? new MaxSizeHeapPolicy(maxSizeConfig) : ("used_heap_percentage".equals(maxSizeConfig.getMaxSizePolicy()) ? new MaxSizeHeapPercentagePolicy(maxSizeConfig) : null))));
        this.evictionComparator = this.evictionPolicy == EvictionPolicy.NONE ? null : (this.evictionPolicy == EvictionPolicy.LRU ? new ComparatorWrapper(LRU_COMPARATOR) : new ComparatorWrapper(LFU_COMPARATOR));
        this.evictionRate = (float)mapConfig.getEvictionPercentage() / 100.0f;
    }

    public MapConfig getRuntimeConfig() {
        MapConfig mapConfig = new MapConfig(this.name);
        mapConfig.setBackupCounts(this.backupCount, this.asyncBackupCount);
        mapConfig.setTimeToLiveSeconds((int)(this.ttl / 1000L));
        mapConfig.setMaxIdleSeconds((int)(this.maxIdle / 1000L));
        mapConfig.setEvictionPolicy(this.evictionPolicy.toString());
        mapConfig.setReadBackupData(this.readBackupData);
        mapConfig.setCacheValue(this.cacheValue);
        if (this.maxSizePolicy != null) {
            mapConfig.getMaxSizeConfig().setMaxSizePolicy(this.maxSizePolicy.getMaxSizeConfig().getMaxSizePolicy());
            mapConfig.getMaxSizeConfig().setSize(this.maxSizePolicy.getMaxSizeConfig().getSize());
        }
        mapConfig.setEvictionPercentage((int)(this.evictionRate * 100.0f));
        return mapConfig;
    }

    public MapLoader getMapLoader() {
        return this.loader;
    }

    public Object getInitLock() {
        return this.initLock;
    }

    boolean isUserMap() {
        return !this.name.startsWith("c:__hz_");
    }

    final boolean isNotLocked(Request request) {
        return this.lockEntireMap == null || !this.lockEntireMap.isLocked() || this.lockEntireMap.isLockedBy(request.lockAddress, request.lockThreadId);
    }

    final boolean overCapacity() {
        if (this.maxSizePolicy != null && this.maxSizePolicy.overCapacity()) {
            this.concurrentMapManager.executeCleanup(this, true);
            return true;
        }
        return false;
    }

    public void lockMap(Request request) {
        if (request.operation == ClusterOperation.CONCURRENT_MAP_LOCK_MAP) {
            if (this.lockEntireMap == null) {
                this.lockEntireMap = new DistributedLock();
            }
            if (!this.lockEntireMap.isLockedBy(request.lockAddress, request.lockThreadId)) {
                this.lockEntireMap.lock(request.lockAddress, request.lockThreadId);
            }
            request.clearForResponse();
            request.response = Boolean.TRUE;
        } else if (request.operation == ClusterOperation.CONCURRENT_MAP_UNLOCK_MAP) {
            request.response = this.lockEntireMap != null ? Boolean.valueOf(this.lockEntireMap.unlock(request.lockAddress, request.lockThreadId)) : Boolean.TRUE;
        }
    }

    public void addIndex(Expression expression, boolean ordered, int attributeIndex) {
        this.mapIndexService.addIndex(expression, ordered, attributeIndex);
    }

    public Record getRecord(Data key) {
        return (Record)this.mapRecords.get(key);
    }

    public int getBackupCount() {
        return this.backupCount;
    }

    public int getAsyncBackupCount() {
        return this.asyncBackupCount;
    }

    public int getTotalBackupCount() {
        return this.backupCount + this.asyncBackupCount;
    }

    public boolean isCacheValue() {
        return this.cacheValue;
    }

    public boolean isReadBackupData() {
        return this.readBackupData;
    }

    public void own(DataRecordEntry dataRecordEntry) {
        Record record = this.storeDataRecordEntry(dataRecordEntry);
        if (record != null) {
            Map<Address, Boolean> keyListeners;
            if (record.valueCount() > 0) {
                this.updateIndexes(record);
            }
            if ((keyListeners = dataRecordEntry.getListeners()) != null) {
                record.setMapListeners(keyListeners);
            }
        }
    }

    public void storeAsBackup(DataRecordEntry dataRecordEntry) {
        this.storeDataRecordEntry(dataRecordEntry);
    }

    private Record storeDataRecordEntry(DataRecordEntry dataRecordEntry) {
        Record record;
        Record existing = this.getRecord(dataRecordEntry.getKeyData());
        if (existing != null) {
            this.mapIndexService.remove(existing);
        }
        if (this.isMultiMap()) {
            record = this.getRecord(dataRecordEntry.getKeyData());
            if (record == null) {
                record = this.createAndAddNewRecord(dataRecordEntry.getKeyData(), null);
            }
            if (record.getMultiValues() == null) {
                record.setMultiValues(this.createMultiValuesCollection());
            }
            record.getMultiValues().add(new ValueHolder(dataRecordEntry.getValueData()));
        } else {
            record = this.createAndAddNewRecord(dataRecordEntry.getKeyData(), dataRecordEntry.getValueData());
            record.setCreationTime(dataRecordEntry.getCreationTime());
            record.setExpirationTime(dataRecordEntry.getExpirationTime());
            record.setMaxIdle(dataRecordEntry.getRemainingIdle());
            record.setIndexes(dataRecordEntry.getIndexes(), dataRecordEntry.getIndexTypes());
            if (dataRecordEntry.getLockAddress() != null && dataRecordEntry.getLockThreadId() != -1) {
                record.lock(dataRecordEntry.getLockThreadId(), dataRecordEntry.getLockAddress());
            }
        }
        record.setVersion(dataRecordEntry.getVersion());
        this.markAsActive(record);
        return record;
    }

    public boolean isMultiMap() {
        return this.instanceType == Instance.InstanceType.MULTIMAP;
    }

    public boolean isSet() {
        return this.instanceType == Instance.InstanceType.SET;
    }

    public boolean isList() {
        return this.instanceType == Instance.InstanceType.LIST;
    }

    public boolean isMap() {
        return this.instanceType == Instance.InstanceType.MAP;
    }

    public boolean backup(Request req) {
        if (req.key == null || req.key.size() == 0) {
            throw new RuntimeException("Backup key size cannot be 0: " + req.key);
        }
        if (this.isMap() || this.isSet()) {
            return this.backupOneValue(req);
        }
        return this.backupMultiValue(req);
    }

    private boolean backupOneValue(Request req) {
        Record record = this.getRecord(req);
        if (record != null && req.version < record.getVersion()) {
            return false;
        }
        this.doBackup(req);
        if (record != null) {
            record.setVersion(req.version);
        }
        return true;
    }

    private boolean backupMultiValue(Request req) {
        Record record = this.getRecord(req);
        if (record != null) {
            record.setActive();
            if (req.version > record.getVersion() + 1L) {
                Request reqCopy = Request.copyFromRequest(req);
                record.addBackupOp(new VersionedBackupOp(this, reqCopy));
                return true;
            }
        }
        this.doBackup(req);
        if (record != null) {
            record.setVersion(req.version);
            record.runBackupOps();
        }
        return true;
    }

    public void doBackup(Request req) {
        if (req.key == null || req.key.size() == 0) {
            throw new RuntimeException("Backup key size cannot be zero! " + req.key);
        }
        if (req.operation == ClusterOperation.CONCURRENT_MAP_BACKUP_PUT || req.operation == ClusterOperation.CONCURRENT_MAP_BACKUP_PUT_AND_UNLOCK) {
            Record record = this.toRecord(req);
            if (req.operation == ClusterOperation.CONCURRENT_MAP_BACKUP_PUT_AND_UNLOCK || req.txnId != -1L) {
                this.unlock(record, req);
            }
            this.markAsActive(record);
            record.setVersion(req.version);
            if (req.indexes != null) {
                if (req.indexTypes == null) {
                    throw new RuntimeException("index types cannot be null!");
                }
                if (req.indexes.length != req.indexTypes.length) {
                    throw new RuntimeException("index and type lengths do not match");
                }
                record.setIndexes(req.indexes, req.indexTypes);
            }
            if (req.ttl > 0L && req.ttl < Long.MAX_VALUE) {
                record.setTTL(req.ttl);
                this.ttlPerRecord = true;
            }
        } else if (req.operation == ClusterOperation.CONCURRENT_MAP_BACKUP_REMOVE) {
            Record record = this.toRecord(req);
            if (record.isActive()) {
                this.markAsEvicted(record);
            }
            if (req.txnId != -1L) {
                this.unlock(record, req);
            }
            record.setVersion(req.version);
        } else if (req.operation == ClusterOperation.CONCURRENT_MAP_BACKUP_LOCK) {
            if (req.lockCount == 0) {
                Record record = this.getRecord(req);
                if (record != null) {
                    record.clearLock();
                    if (record.valueCount() == 0) {
                        this.markAsEvicted(record);
                    }
                }
            } else {
                Record record = this.toRecord(req);
                if (record.getVersion() == 0L) {
                    record.setVersion(req.version);
                }
            }
        } else if (req.operation == ClusterOperation.CONCURRENT_MAP_BACKUP_ADD) {
            this.add(req, true);
        } else if (req.operation == ClusterOperation.CONCURRENT_MAP_BACKUP_REMOVE_MULTI) {
            Record record = this.getRecord(req);
            if (record != null) {
                if (req.value == null || record.valueCount() == 0) {
                    this.markAsEvicted(record);
                } else {
                    Collection<ValueHolder> multiValues = record.getMultiValues();
                    if (multiValues != null) {
                        multiValues.remove(new ValueHolder(req.value));
                    }
                    if (record.valueCount() == 0) {
                        this.markAsEvicted(record);
                    }
                }
            }
        } else {
            this.logger.log(Level.SEVERE, "Unknown backup operation " + (Object)((Object)req.operation));
        }
    }

    public boolean containsKey(Request req) {
        Record record = this.getRecord(req);
        if (record == null) {
            return false;
        }
        if (record.isActive() && record.isValid()) {
            return record.valueCount() > 0;
        }
        return false;
    }

    public CMapEntry getMapEntry(Request req) {
        Record record = this.getRecord(req);
        if (record == null || !record.isActive() || !record.isValid()) {
            return null;
        }
        return new CMapEntry(record);
    }

    public Data get(Request req) {
        Record record = this.getRecord(req);
        if (record == null) {
            return null;
        }
        if (!record.isActive()) {
            return null;
        }
        if (!record.isValid() && record.isEvictable()) {
            return null;
        }
        record.setLastAccessed();
        Data data = record.getValueData();
        Data returnValue = null;
        if (data != null) {
            returnValue = data;
        } else if (record.getMultiValues() != null && record.getMultiValues().size() > 0) {
            Values values = new Values(record.getMultiValues());
            returnValue = IOUtil.toData(values);
        }
        return returnValue;
    }

    public boolean add(Request req, boolean backup) {
        Record record = this.getRecord(req);
        if (record == null) {
            record = this.toRecord(req);
        } else if (record.isActive() && req.operation == ClusterOperation.CONCURRENT_MAP_ADD_TO_SET) {
            return false;
        }
        record.setActive(true);
        record.incrementVersion();
        if (!backup) {
            this.updateIndexes(record);
            this.concurrentMapManager.fireMapEvent(this.mapListeners, EntryEvent.TYPE_ADDED, null, record, req.caller);
        }
        return true;
    }

    void lock(Request request) {
        DistributedLock lock;
        Data reqValue = request.value;
        Record rec = this.concurrentMapManager.ensureRecord(request);
        if (request.operation == ClusterOperation.CONCURRENT_MAP_TRY_LOCK_AND_GET && reqValue == null) {
            request.value = rec.getValueData();
            if (rec.getMultiValues() != null) {
                Values values = new Values(rec.getMultiValues());
                request.value = IOUtil.toData(values);
            }
        }
        Long response = (lock = rec.getLock()) == null || !lock.isLocked() ? 0L : 1L;
        rec.lock(request.lockThreadId, request.lockAddress);
        rec.incrementVersion();
        request.version = rec.getVersion();
        request.lockCount = rec.getLockCount();
        this.markAsActive(rec);
        request.response = response;
    }

    void unlock(Record record, Request request) {
        record.unlock(request.lockThreadId, request.lockAddress);
        this.fireScheduledActions(record);
    }

    void clearLock(Record record) {
        record.clearLock();
        this.fireScheduledActions(record);
    }

    void fireScheduledActions(Record record) {
        this.concurrentMapManager.checkServiceThread();
        if (record.getLockCount() == 0) {
            record.clearLock();
            while (record.hasScheduledAction()) {
                ScheduledAction sa = record.getScheduledActions().remove(0);
                this.node.clusterManager.deregisterScheduledAction(sa);
                if (!sa.expired()) {
                    sa.consume();
                    if (!record.isLocked()) continue;
                    return;
                }
                sa.onExpire();
            }
        }
    }

    public void onMigrate(Record record) {
        if (record == null) {
            return;
        }
        List<ScheduledAction> lsScheduledActions = record.getScheduledActions();
        if (lsScheduledActions != null && lsScheduledActions.size() > 0) {
            Iterator<ScheduledAction> it = lsScheduledActions.iterator();
            while (it.hasNext()) {
                ScheduledAction sa = it.next();
                if (sa.isValid() && !sa.expired()) {
                    sa.onMigrate();
                }
                sa.setValid(false);
                this.node.clusterManager.deregisterScheduledAction(sa);
                it.remove();
            }
        }
    }

    public void onDisconnect(Address deadAddress) {
        if (deadAddress == null) {
            return;
        }
        if (this.lockEntireMap != null && deadAddress.equals(this.lockEntireMap.getLockAddress())) {
            this.lockEntireMap = null;
        }
    }

    public void onDisconnect(Record record, Address deadAddress) {
        List<ScheduledAction> lsScheduledActions;
        if (record == null || deadAddress == null) {
            return;
        }
        if (record.isLocked() && this.isMapForQueue() && deadAddress.equals(record.getLock().getLockAddress())) {
            this.sendKeyToMaster(record.getKeyData());
        }
        if ((lsScheduledActions = record.getScheduledActions()) != null && lsScheduledActions.size() > 0) {
            Iterator<ScheduledAction> it = lsScheduledActions.iterator();
            while (it.hasNext()) {
                ScheduledAction sa = it.next();
                if (!deadAddress.equals(sa.getRequest().caller)) continue;
                this.node.clusterManager.deregisterScheduledAction(sa);
                sa.setValid(false);
                it.remove();
            }
        }
        if (record.getLockCount() > 0 && deadAddress.equals(record.getLockAddress())) {
            this.clearLock(record);
        }
    }

    public void onRemoveMulti(Request req, Record record) {
        if (req.txnId != -1L) {
            this.unlock(record, req);
        }
        record.incrementVersion();
        this.concurrentMapManager.fireMapEvent(this.mapListeners, this.getName(), EntryEvent.TYPE_REMOVED, record.getKeyData(), null, req.value, record.getListeners(), req.caller);
        req.version = record.getVersion();
        if (record.valueCount() == 0) {
            this.markAsRemoved(record);
        }
    }

    public void putMulti(Request req) {
        Record record = this.getRecord(req);
        if (record == null) {
            record = this.toRecord(req);
        } else {
            if (!record.isActive()) {
                this.markAsActive(record);
            }
            if (record.getMultiValues() == null) {
                record.setMultiValues(this.createMultiValuesCollection());
            }
            record.getMultiValues().add(new ValueHolder(req.value));
        }
        this.updateIndexes(record);
        record.incrementVersion();
        this.concurrentMapManager.fireMapEvent(this.mapListeners, this.getName(), EntryEvent.TYPE_ADDED, record.getKeyData(), null, req.value, record.getListeners(), req.caller);
        if (req.txnId != -1L) {
            this.unlock(record, req);
        }
        req.clearForResponse();
        req.version = record.getVersion();
    }

    boolean isApplicable(ClusterOperation operation, Request req, long now) {
        Record record = this.getRecord(req);
        if (ClusterOperation.CONCURRENT_MAP_PUT_IF_ABSENT.equals((Object)operation)) {
            return record == null || !record.isActive() || !record.isValid(now) || !record.hasValueData();
        }
        if (ClusterOperation.CONCURRENT_MAP_REPLACE_IF_NOT_NULL.equals((Object)operation)) {
            return record != null && record.isActive() && record.isValid(now) && record.hasValueData();
        }
        return true;
    }

    public void put(Request req) {
        Record record;
        long now = Clock.currentTimeMillis();
        boolean sendEvictEvent = false;
        Record evictedRecord = null;
        if (req.value == null) {
            req.value = new Data();
        }
        if ((record = this.getRecord(req)) != null && !record.isValid(now)) {
            if (record.isActive() && record.isEvictable()) {
                sendEvictEvent = true;
                evictedRecord = this.createNewTransientRecord(record.getKeyData(), record.getValueData());
            }
            record.setValueData(null);
            record.setMultiValues(null);
        }
        if (req.operation == ClusterOperation.CONCURRENT_MAP_PUT_IF_ABSENT) {
            if (!this.isApplicable(ClusterOperation.CONCURRENT_MAP_PUT_IF_ABSENT, req, now)) {
                req.clearForResponse();
                req.response = record.getValueData();
                return;
            }
        } else if (req.operation == ClusterOperation.CONCURRENT_MAP_REPLACE_IF_NOT_NULL && !this.isApplicable(ClusterOperation.CONCURRENT_MAP_REPLACE_IF_NOT_NULL, req, now)) {
            req.value = null;
            return;
        }
        Data oldValue = null;
        if (record == null) {
            record = this.createAndAddNewRecord(req.key, req.value);
        } else {
            this.markAsActive(record);
            oldValue = record.isValid(now) ? record.getValueData() : null;
            record.setValueData(req.value);
            record.incrementVersion();
            record.setLastUpdated();
        }
        if (req.ttl > 0L && req.ttl < Long.MAX_VALUE) {
            record.setTTL(req.ttl);
            this.ttlPerRecord = true;
        }
        if (sendEvictEvent) {
            this.concurrentMapManager.fireMapEvent(this.mapListeners, EntryEvent.TYPE_EVICTED, null, evictedRecord, req.caller);
        }
        if (oldValue == null) {
            this.concurrentMapManager.fireMapEvent(this.mapListeners, EntryEvent.TYPE_ADDED, null, record, req.caller);
        } else {
            this.fireInvalidation(record);
            this.concurrentMapManager.fireMapEvent(this.mapListeners, EntryEvent.TYPE_UPDATED, oldValue, record, req.caller);
        }
        if (req.txnId != -1L || req.operation == ClusterOperation.CONCURRENT_MAP_PUT_AND_UNLOCK) {
            this.unlock(record, req);
        }
        record.setIndexes(req.indexes, req.indexTypes);
        this.updateIndexes(record);
        this.markAsDirty(record, false);
        req.clearForResponse();
        req.version = record.getVersion();
        if (this.localUpdateListener != null && req.txnId != Long.MIN_VALUE) {
            this.localUpdateListener.recordUpdated(record);
        }
        req.response = req.operation == ClusterOperation.CONCURRENT_MAP_REPLACE_IF_SAME || req.operation == ClusterOperation.CONCURRENT_MAP_SET ? Boolean.TRUE : oldValue;
    }

    boolean isMapForQueue() {
        return this.mapForQueue;
    }

    void sendKeyToMaster(Data key) {
        String queueName = this.name.substring(2);
        if (this.concurrentMapManager.isMaster()) {
            this.node.blockingQueueManager.doAddKey(queueName, key, 0);
        } else {
            Packet packet = this.concurrentMapManager.obtainPacket();
            packet.name = queueName;
            packet.setKey(key);
            packet.operation = ClusterOperation.BLOCKING_OFFER_KEY;
            packet.longValue = 0L;
            this.concurrentMapManager.sendOrReleasePacket(packet, this.concurrentMapManager.getMasterAddress());
        }
    }

    private void executeStoreUpdate(final Set<Record> dirtyRecords) {
        if (dirtyRecords.size() > 0) {
            this.concurrentMapManager.storeExecutor.execute(new Runnable(){

                public void run() {
                    try {
                        HashSet<Object> keysToDelete = new HashSet<Object>();
                        HashSet<Record> toStore = new HashSet<Record>();
                        HashMap<Object, Object> updates = new HashMap<Object, Object>();
                        for (Record dirtyRecord : dirtyRecords) {
                            if (!dirtyRecord.isActive()) {
                                keysToDelete.add(dirtyRecord.getKey());
                                continue;
                            }
                            toStore.add(dirtyRecord);
                            updates.put(dirtyRecord.getKey(), dirtyRecord.getValue());
                        }
                        if (keysToDelete.size() == 1) {
                            CMap.this.store.delete(keysToDelete.iterator().next());
                        } else if (keysToDelete.size() > 1) {
                            CMap.this.store.deleteAll(keysToDelete);
                        }
                        if (updates.size() == 1) {
                            Map.Entry entry = updates.entrySet().iterator().next();
                            CMap.this.store.store(entry.getKey(), entry.getValue());
                        } else if (updates.size() > 1) {
                            CMap.this.store.storeAll(updates);
                        }
                        for (Record stored : toStore) {
                            stored.setLastStoredTime(Clock.currentTimeMillis());
                        }
                    }
                    catch (Exception e) {
                        for (Record dirtyRecord : dirtyRecords) {
                            dirtyRecord.setDirty(true);
                        }
                    }
                }
            });
        }
    }

    private void purgeIfNotOwnedOrBackup(Collection<Record> records) {
        PartitionManager partitionManager = this.concurrentMapManager.getPartitionManager();
        for (Record record : records) {
            if (!partitionManager.shouldPurge(record.getBlockId(), this.getTotalBackupCount())) continue;
            this.mapIndexService.remove(record);
            this.mapRecords.remove(record.getKeyData());
        }
    }

    Record getOwnedRecord(Data key) {
        PartitionServiceImpl partitionService = this.concurrentMapManager.partitionServiceImpl;
        PartitionServiceImpl.PartitionProxy partition = partitionService.getPartition(this.concurrentMapManager.getPartitionId(key));
        Member ownerNow = partition.getOwner();
        if (ownerNow != null && !this.concurrentMapManager.partitionManager.isOwnedPartitionMigrating(partition.getPartitionId()) && ownerNow.localMember()) {
            return this.getRecord(key);
        }
        return null;
    }

    public int size() {
        if (this.maxIdle > 0L || this.ttl > 0L || this.ttlPerRecord || this.isList() || this.isMultiMap()) {
            long now = Clock.currentTimeMillis();
            int size = 0;
            Collection<Record> records = this.mapIndexService.getOwnedRecords();
            for (Record record : records) {
                if (!record.isActive() || !record.isValid(now)) continue;
                size += record.valueCount();
            }
            return size;
        }
        return this.mapIndexService.size();
    }

    public int size(int expectedPartitionVersion) {
        PartitionManager partitionManager = this.concurrentMapManager.partitionManager;
        if (partitionManager.getVersion() != expectedPartitionVersion) {
            return -1;
        }
        long now = Clock.currentTimeMillis();
        int size = 0;
        Collection records = this.mapRecords.values();
        for (Record record : records) {
            Member owner = this.concurrentMapManager.partitionServiceImpl.getPartition(record.getBlockId()).getOwner();
            if (owner == null || !owner.localMember() || !record.isActive() || !record.isValid(now)) continue;
            size += record.valueCount();
        }
        if (partitionManager.getVersion() != expectedPartitionVersion) {
            return -1;
        }
        return size;
    }

    public void collectScheduledLocks(Map<Object, DistributedLock> lockOwners, Map<Object, DistributedLock> lockRequested) {
        Collection records = this.mapRecords.values();
        for (Record record : records) {
            DistributedLock dLock = record.getLock();
            if (dLock == null || !dLock.isLocked()) continue;
            lockOwners.put(record.getKey(), dLock);
            List<ScheduledAction> scheduledActions = record.getScheduledActions();
            if (scheduledActions == null) continue;
            for (ScheduledAction scheduledAction : scheduledActions) {
                Request request = scheduledAction.getRequest();
                if (!ClusterOperation.CONCURRENT_MAP_LOCK.equals((Object)request.operation)) continue;
                lockRequested.put(record.getKey(), new DistributedLock(request.lockAddress, request.lockThreadId));
            }
        }
    }

    public int valueCount(Data key) {
        long now = Clock.currentTimeMillis();
        int count = 0;
        Record record = (Record)this.mapRecords.get(key);
        if (record != null && record.isValid(now)) {
            count = record.valueCount();
        }
        return count;
    }

    LocalMapStatsImpl getLocalMapStats() {
        LocalMapStatsImpl localMapStats = new LocalMapStatsImpl();
        long now = Clock.currentTimeMillis();
        long ownedEntryCount = 0L;
        long backupEntryCount = 0L;
        long markedAsRemovedEntryCount = 0L;
        long dirtyCount = 0L;
        long ownedEntryMemoryCost = 0L;
        long backupEntryMemoryCost = 0L;
        long markedAsRemovedMemoryCost = 0L;
        long hits = 0L;
        long lockedEntryCount = 0L;
        long lockWaitCount = 0L;
        ClusterImpl clusterImpl = this.node.getClusterImpl();
        Collection records = this.mapRecords.values();
        PartitionManager partitionManager = this.concurrentMapManager.partitionManager;
        for (Record record : records) {
            if (!record.isActive() || !record.isValid(now)) {
                ++markedAsRemovedEntryCount;
                markedAsRemovedMemoryCost += record.getCost();
                continue;
            }
            PartitionInfo partition = partitionManager.getPartition(record.getBlockId());
            Address owner = partition.getOwner();
            if (owner != null && this.thisAddress.equals(owner)) {
                if (this.store != null && record.getLastStoredTime() < Math.max(record.getLastUpdateTime(), record.getCreationTime())) {
                    ++dirtyCount;
                }
                ownedEntryCount += (long)record.valueCount();
                ownedEntryMemoryCost += record.getCost();
                localMapStats.setLastAccessTime(record.getLastAccessTime());
                localMapStats.setLastUpdateTime(record.getLastUpdateTime());
                hits += (long)record.getHits();
                if (!record.isLocked()) continue;
                ++lockedEntryCount;
                lockWaitCount += (long)record.getScheduledActionCount();
                continue;
            }
            if (!partition.isBackup(this.thisAddress, this.getTotalBackupCount()) || record.valueCount() <= 0) continue;
            backupEntryCount += (long)record.valueCount();
            backupEntryMemoryCost += record.getCost();
        }
        localMapStats.setDirtyEntryCount(CMap.zeroOrPositive(dirtyCount));
        localMapStats.setMarkedAsRemovedEntryCount(CMap.zeroOrPositive(markedAsRemovedEntryCount));
        localMapStats.setMarkedAsRemovedMemoryCost(CMap.zeroOrPositive(markedAsRemovedMemoryCost));
        localMapStats.setLockWaitCount(CMap.zeroOrPositive(lockWaitCount));
        localMapStats.setLockedEntryCount(CMap.zeroOrPositive(lockedEntryCount));
        localMapStats.setHits(CMap.zeroOrPositive(hits));
        localMapStats.setOwnedEntryCount(CMap.zeroOrPositive(ownedEntryCount));
        localMapStats.setBackupEntryCount(CMap.zeroOrPositive(backupEntryCount));
        localMapStats.setOwnedEntryMemoryCost(CMap.zeroOrPositive(ownedEntryMemoryCost));
        localMapStats.setBackupEntryMemoryCost(CMap.zeroOrPositive(backupEntryMemoryCost));
        localMapStats.setLastEvictionTime(CMap.zeroOrPositive(clusterImpl.getClusterTimeFor(this.lastEvictionTime)));
        localMapStats.setCreationTime(CMap.zeroOrPositive(clusterImpl.getClusterTimeFor(this.creationTime)));
        return localMapStats;
    }

    private static long zeroOrPositive(long value) {
        return value > 0L ? value : 0L;
    }

    void evict(int percentage) {
        long now = Clock.currentTimeMillis();
        Collection records = this.mapRecords.values();
        ComparatorWrapper comparator = this.evictionComparator;
        if (comparator == null) {
            comparator = new ComparatorWrapper(LRU_COMPARATOR);
        }
        PartitionServiceImpl partitionService = this.concurrentMapManager.partitionServiceImpl;
        PartitionManager partitionManager = this.concurrentMapManager.partitionManager;
        TreeSet<MapEntry> sortedRecords = new TreeSet<MapEntry>(new ComparatorWrapper(comparator));
        HashSet<Record> recordsToEvict = new HashSet<Record>();
        for (Record record : records) {
            boolean owned;
            PartitionServiceImpl.PartitionProxy partition = partitionService.getPartition(record.getBlockId());
            Member member = partition.getOwner();
            if (member == null || partitionManager.isOwnedPartitionMigrating(partition.getPartitionId()) || !(owned = member.localMember()) || this.store != null && this.writeDelayMillis > 0L && record.isDirty() || this.shouldPurgeRecord(record, now)) continue;
            if (record.isActive() && !record.isValid(now)) {
                recordsToEvict.add(record);
                continue;
            }
            if (!record.isActive() || !record.isEvictable()) continue;
            sortedRecords.add(record);
        }
        int numberOfRecordsToEvict = sortedRecords.size() * percentage / 100;
        int evictedCount = 0;
        for (Record record : sortedRecords) {
            recordsToEvict.add(record);
            if (++evictedCount < numberOfRecordsToEvict) continue;
            break;
        }
        this.executeEviction(recordsToEvict);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean startCleanup(boolean forced) {
        boolean shouldRun;
        long now = Clock.currentTimeMillis();
        long dirtyAge = now - this.lastCleanup;
        boolean bl = shouldRun = forced || this.store != null && this.dirty && dirtyAge >= this.writeDelayMillis || dirtyAge > this.cleanupDelayMillis;
        if (shouldRun && this.cleanupActive.compareAndSet(false, true)) {
            this.lastCleanup = now;
            try {
                Level levelLog;
                if (this.nearCache != null) {
                    this.nearCache.evict(now, false);
                }
                this.dirty = false;
                HashSet<Record> recordsDirty = new HashSet<Record>();
                HashSet<Record> recordsUnknown = new HashSet<Record>();
                HashSet<Record> recordsToPurge = new HashSet<Record>();
                HashSet<Record> recordsToEvict = new HashSet<Record>();
                TreeSet<MapEntry> sortedRecords = new TreeSet<MapEntry>(new ComparatorWrapper(this.evictionComparator));
                Collection records = this.mapRecords.values();
                boolean overCapacity = this.overCapacity();
                boolean evictionAware = this.evictionComparator != null && overCapacity;
                int recordsStillOwned = 0;
                int backupPurgeCount = 0;
                long costOfRecords = 0L;
                PartitionManager partitionManager = this.concurrentMapManager.partitionManager;
                for (Record record : records) {
                    PartitionInfo partition = partitionManager.getPartition(record.getBlockId());
                    Address address = partition.getOwner();
                    boolean owned = address != null && this.thisAddress.equals(address);
                    boolean ownedOrBackup = partition.isOwnerOrBackup(this.thisAddress, this.getTotalBackupCount());
                    if (address == null || partitionManager.isPartitionMigrating(partition.getPartitionId())) continue;
                    if (owned) {
                        if (this.store != null && this.mapStoreWrapper.isEnabled() && this.writeDelayMillis > 0L && record.isDirty()) {
                            if (now > record.getWriteTime()) {
                                recordsDirty.add(record);
                                record.setDirty(false);
                            } else {
                                this.dirty = true;
                            }
                        } else if (this.shouldPurgeRecord(record, now)) {
                            recordsToPurge.add(record);
                        } else if (record.isActive() && !record.isValid(now)) {
                            recordsToEvict.add(record);
                        } else if (evictionAware && record.isActive() && record.isEvictable()) {
                            sortedRecords.add(record);
                            ++recordsStillOwned;
                        }
                        if (!record.isActive() || !record.isValid(now)) continue;
                        costOfRecords += record.getCost();
                        continue;
                    }
                    if (ownedOrBackup) {
                        if (!this.shouldPurgeRecord(record, now)) continue;
                        recordsToPurge.add(record);
                        ++backupPurgeCount;
                        continue;
                    }
                    recordsUnknown.add(record);
                }
                this.totalCostOfRecords = costOfRecords;
                if (evictionAware && (forced || overCapacity)) {
                    int numberOfRecordsToEvict = (int)((float)recordsStillOwned * this.evictionRate);
                    int evictedCount = 0;
                    for (Record record : sortedRecords) {
                        if (!record.isActive() || !record.isEvictable()) continue;
                        recordsToEvict.add(record);
                        if (++evictedCount < numberOfRecordsToEvict) continue;
                        break;
                    }
                }
                Level level = levelLog = this.concurrentMapManager.LOG_STATE ? Level.INFO : Level.FINEST;
                if (this.logger.isLoggable(levelLog)) {
                    this.logger.log(levelLog, this.name + " Cleanup " + ", dirty:" + recordsDirty.size() + ", purge:" + recordsToPurge.size() + ", evict:" + recordsToEvict.size() + ", unknown:" + recordsUnknown.size() + ", stillOwned:" + recordsStillOwned + ", backupPurge:" + backupPurgeCount);
                    this.logger.log(levelLog, this.thisAddress + " mapRecords: " + this.mapRecords.size() + "  indexes: " + this.mapIndexService.getOwnedRecords().size() + "  totalCost: " + costOfRecords);
                }
                this.executeStoreUpdate(recordsDirty);
                this.executeEviction(recordsToEvict);
                this.executePurge(recordsToPurge);
                this.executePurgeUnknowns(recordsUnknown);
            }
            finally {
                this.cleanupActive.set(false);
            }
            return true;
        }
        return false;
    }

    private void executePurgeUnknowns(final Set<Record> recordsUnknown) {
        if (recordsUnknown.size() > 0) {
            this.concurrentMapManager.enqueueAndReturn(new Processable(){

                public void process() {
                    CMap.this.purgeIfNotOwnedOrBackup(recordsUnknown);
                }
            });
        }
    }

    private void executePurge(final Set<Record> recordsToPurge) {
        if (recordsToPurge.size() > 0) {
            this.concurrentMapManager.enqueueAndReturn(new Processable(){

                public void process() {
                    long now = Clock.currentTimeMillis();
                    for (Record recordToPurge : recordsToPurge) {
                        if (!CMap.this.shouldPurgeRecord(recordToPurge, now)) continue;
                        CMap.this.removeAndPurgeRecord(recordToPurge);
                    }
                }
            });
        }
    }

    boolean shouldPurgeRecord(Record record, long now) {
        return !record.isActive() && record.isRemovable() && now - record.getRemoveTime() > this.removeDelayMillis;
    }

    private void executeEviction(Collection<Record> lsRecordsToEvict) {
        if (lsRecordsToEvict != null && lsRecordsToEvict.size() > 0) {
            this.logger.log(Level.FINEST, lsRecordsToEvict.size() + " evicting");
            for (Record recordToEvict : lsRecordsToEvict) {
                this.concurrentMapManager.evictAsync(this.name, recordToEvict.getKeyData());
            }
        }
    }

    void fireInvalidation(Record record) {
        if (this.nearCache != null && this.nearCache.shouldInvalidateOnChange()) {
            for (MemberImpl member : this.concurrentMapManager.lsMembers) {
                if (member.localMember() || member.getAddress() == null) continue;
                Packet packet = this.concurrentMapManager.obtainPacket();
                packet.name = this.getName();
                packet.setKey(record.getKeyData());
                packet.operation = ClusterOperation.CONCURRENT_MAP_INVALIDATE;
                this.concurrentMapManager.sendOrReleasePacket(packet, member.getAddress());
            }
            this.nearCache.invalidate(record.getKeyData());
        }
    }

    Record getRecord(Request req) {
        if (req.record == null || !req.record.isActive()) {
            req.record = (Record)this.mapRecords.get(req.key);
        }
        return req.record;
    }

    Record toRecord(Request req) {
        Record record = this.getRecord(req);
        if (record == null) {
            if (this.isMultiMap()) {
                record = this.createAndAddNewRecord(req.key, null);
                record.setMultiValues(this.createMultiValuesCollection());
                if (req.value != null) {
                    record.getMultiValues().add(new ValueHolder(req.value));
                }
            } else {
                record = this.createAndAddNewRecord(req.key, req.value);
            }
        } else if (req.value != null) {
            if (this.isMultiMap()) {
                if (record.getMultiValues() == null) {
                    record.setMultiValues(this.createMultiValuesCollection());
                }
                record.getMultiValues().add(new ValueHolder(req.value));
            } else {
                record.setValueData(req.value);
            }
        }
        record.setIndexes(req.indexes, req.indexTypes);
        if (req.lockCount > 0) {
            DistributedLock lock = new DistributedLock(req.lockAddress, req.lockThreadId, req.lockCount);
            record.setLock(lock);
        }
        return record;
    }

    public boolean removeItem(Request req) {
        Record record = this.getRecord(req);
        if (record == null) {
            return false;
        }
        if (req.txnId != -1L) {
            this.unlock(record, req);
        }
        boolean removed = false;
        if (record.hasValueData()) {
            removed = true;
        } else if (record.getMultiValues() != null) {
            removed = true;
        }
        if (removed) {
            this.concurrentMapManager.fireMapEvent(this.mapListeners, EntryEvent.TYPE_REMOVED, null, record, req.caller);
            record.incrementVersion();
        }
        req.version = record.getVersion();
        this.markAsRemoved(record);
        return true;
    }

    boolean evict(Request req) {
        Record record = this.getRecord(req.key);
        long now = Clock.currentTimeMillis();
        if (record != null && record.isActive() && record.valueCount() > 0) {
            this.concurrentMapManager.checkServiceThread();
            this.fireInvalidation(record);
            this.concurrentMapManager.fireMapEvent(this.mapListeners, EntryEvent.TYPE_EVICTED, null, record, req.caller);
            record.incrementVersion();
            this.markAsEvicted(record);
            req.clearForResponse();
            req.version = record.getVersion();
            this.lastEvictionTime = now;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(Request req) {
        Record record = this.getRecord(req);
        if (record == null) {
            req.clearForResponse();
            return;
        }
        try {
            if (!record.isActive()) {
                return;
            }
            if (!record.isValid() && record.isEvictable()) {
                return;
            }
            if (req.value != null && record.hasValueData() && !record.getValueData().equals(req.value)) {
                return;
            }
            Data oldValue = record.getValueData();
            if (oldValue == null && record.getMultiValues() != null && record.getMultiValues().size() > 0) {
                Values values = new Values(record.getMultiValues());
                oldValue = IOUtil.toData(values);
            }
            if (oldValue != null) {
                this.fireInvalidation(record);
                this.concurrentMapManager.fireMapEvent(this.mapListeners, this.getName(), EntryEvent.TYPE_REMOVED, record.getKeyData(), null, oldValue, record.getListeners(), req.caller);
                record.incrementVersion();
            }
            this.markAsRemoved(record);
            if (this.localUpdateListener != null && req.txnId != Long.MIN_VALUE) {
                this.localUpdateListener.recordUpdated(record);
            }
            req.clearForResponse();
            req.version = record.getVersion();
            req.response = oldValue;
        }
        finally {
            if (req.txnId != -1L) {
                this.unlock(record, req);
            }
        }
    }

    void reset(boolean invalidate) {
        for (Record record : this.mapRecords.values()) {
            List<ScheduledAction> lsScheduledActions;
            if (record.hasScheduledAction() && (lsScheduledActions = record.getScheduledActions()) != null) {
                for (ScheduledAction scheduledAction : lsScheduledActions) {
                    scheduledAction.setValid(false);
                }
            }
            if (!invalidate) continue;
            record.invalidate();
        }
        if (this.nearCache != null) {
            this.nearCache.reset();
        }
        this.mapRecords.clear();
        this.mapIndexService.clear();
    }

    void destroy() {
        this.reset(true);
        this.node.listenerManager.removeAllRegisteredListeners(this.getName());
        if (this.mapStoreWrapper != null) {
            try {
                this.mapStoreWrapper.destroy();
            }
            catch (Exception e) {
                this.logger.log(Level.WARNING, e.getMessage(), e);
            }
        }
    }

    void markAsDirty(Record record, boolean force) {
        if (!record.isDirty() && this.store != null && (force || this.writeDelayMillis > 0L)) {
            this.dirty = true;
            record.setDirty(true);
            if (this.writeDelayMillis > 0L) {
                record.setWriteTime(Clock.currentTimeMillis() + this.writeDelayMillis);
            }
        }
    }

    void markAsActive(Record record) {
        long now = Clock.currentTimeMillis();
        if (!record.isActive() || !record.isValid(now)) {
            record.setActive();
            record.setCreationTime(now);
            record.setLastUpdateTime(0L);
            record.setTTL(this.ttl);
        }
    }

    void markAsRemoved(Record record) {
        record.markRemoved();
        this.markAsEvicted(record);
        this.markAsDirty(record, false);
    }

    void markAsEvicted(Record record) {
        if (record.isActive()) {
            record.setActive(false);
        }
        record.setValueData(null);
        record.setMultiValues(null);
        this.updateIndexes(record);
    }

    void removeAndPurgeRecord(Record record) {
        this.mapRecords.remove(record.getKeyData());
        this.mapIndexService.remove(record);
    }

    void updateIndexes(Record record) {
        this.mapIndexService.index(record);
    }

    Record createAndAddNewRecord(Data key, Data value) {
        if (key == null || key.size() == 0) {
            throw new RuntimeException("Cannot create record from a 0 size key: " + key);
        }
        int blockId = this.concurrentMapManager.getPartitionId(key);
        Record record = this.concurrentMapManager.recordFactory.createNewRecord(this, blockId, key, value, this.ttl, this.maxIdle, this.concurrentMapManager.newRecordId());
        this.mapRecords.put(key, record);
        return record;
    }

    Record createNewTransientRecord(Data key, Data value) {
        if (key == null || key.size() == 0) {
            throw new RuntimeException("Cannot create record from a 0 size key: " + key);
        }
        int blockId = this.concurrentMapManager.getPartitionId(key);
        return new DefaultRecord(this, blockId, key, value, this.ttl, this.maxIdle, this.concurrentMapManager.newRecordId());
    }

    public void addListener(Data key, Address address, boolean includeValue) {
        if (key == null || key.size() == 0) {
            this.mapListeners.put(address, includeValue);
        } else {
            Record rec = this.getRecord(key);
            if (rec == null) {
                rec = this.createAndAddNewRecord(key, null);
            }
            rec.addListener(address, includeValue);
        }
    }

    public void removeListener(Data key, Address address) {
        if (key == null || key.size() == 0) {
            this.mapListeners.remove(address);
        } else {
            Record rec = this.getRecord(key);
            if (rec != null) {
                rec.removeListener(address);
            }
        }
    }

    public void appendState(StringBuffer sbState) {
        sbState.append("\nCMap [");
        sbState.append(this.name);
        sbState.append("] r:");
        sbState.append(this.mapRecords.size());
        if (this.nearCache != null) {
            this.nearCache.appendState(sbState);
        }
        this.mapIndexService.appendState(sbState);
        for (Record record : this.mapRecords.values()) {
            if (!record.isLocked()) continue;
            sbState.append("\nLocked Record by ").append(record.getLock());
        }
    }

    public MapConfig getMapConfig() {
        return this.mapConfig;
    }

    public Node getNode() {
        return this.node;
    }

    public MapIndexService getMapIndexService() {
        return this.mapIndexService;
    }

    private Collection<ValueHolder> createMultiValuesCollection() {
        if (this.multiMapSet) {
            return new ConcurrentHashSet<ValueHolder>();
        }
        return new CopyOnWriteArrayList<ValueHolder>();
    }

    boolean notInitialized() {
        return this.initState == InitializationState.NONE;
    }

    void setInitState(InitializationState state) {
        this.initState = state;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return "CMap [" + this.getName() + "]";
    }

    public static class CMapEntry
    implements HazelcastInstanceAware,
    MapEntry,
    DataSerializable {
        private long cost = 0L;
        private long expirationTime = 0L;
        private long lastAccessTime = 0L;
        private long lastUpdateTime = 0L;
        private long lastStoredTime = 0L;
        private long creationTime = 0L;
        private long version = 0L;
        private int hits = 0;
        private boolean valid = true;
        private String name = null;
        private Object key = null;
        private Object value = null;
        private HazelcastInstance hazelcastInstance = null;

        public CMapEntry() {
        }

        public CMapEntry(Record record) {
            this.cost = record.getCost();
            this.expirationTime = record.getExpirationTime();
            this.lastAccessTime = record.getLastAccessTime();
            this.lastUpdateTime = record.getLastUpdateTime();
            this.creationTime = record.getCreationTime();
            this.lastStoredTime = record.getLastStoredTime();
            this.version = record.getVersion();
            this.hits = record.getHits();
            this.valid = record.isValid();
        }

        public void writeData(DataOutput out) throws IOException {
            out.writeLong(this.cost);
            out.writeLong(this.expirationTime);
            out.writeLong(this.lastAccessTime);
            out.writeLong(this.lastUpdateTime);
            out.writeLong(this.creationTime);
            out.writeLong(this.lastStoredTime);
            out.writeLong(this.version);
            out.writeInt(this.hits);
            out.writeBoolean(this.valid);
        }

        public void readData(DataInput in) throws IOException {
            this.cost = in.readLong();
            this.expirationTime = in.readLong();
            this.lastAccessTime = in.readLong();
            this.lastUpdateTime = in.readLong();
            this.creationTime = in.readLong();
            this.lastStoredTime = in.readLong();
            this.version = in.readLong();
            this.hits = in.readInt();
            this.valid = in.readBoolean();
        }

        public void setHazelcastInstance(HazelcastInstance hazelcastInstance) {
            this.hazelcastInstance = hazelcastInstance;
        }

        public void set(String name, Object key) {
            this.name = name;
            this.key = key;
        }

        public long getCost() {
            return this.cost;
        }

        public long getCreationTime() {
            return this.creationTime;
        }

        public long getExpirationTime() {
            return this.expirationTime;
        }

        public long getLastUpdateTime() {
            return this.lastUpdateTime;
        }

        public int getHits() {
            return this.hits;
        }

        public long getLastAccessTime() {
            return this.lastAccessTime;
        }

        public long getLastStoredTime() {
            return this.lastStoredTime;
        }

        public long getVersion() {
            return this.version;
        }

        public boolean isValid() {
            return this.valid;
        }

        public Object getKey() {
            return this.key;
        }

        public Object getValue() {
            if (this.value == null) {
                FactoryImpl factory = (FactoryImpl)this.hazelcastInstance;
                this.value = ((MProxy)factory.getOrCreateProxyByName(this.name)).get(this.key);
            }
            return this.value;
        }

        public Object setValue(Object value) {
            Object oldValue = this.value;
            FactoryImpl factory = (FactoryImpl)this.hazelcastInstance;
            ((MProxy)factory.getOrCreateProxyByName(this.name)).put(this.key, value);
            return oldValue;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CMapEntry cMapEntry = (CMapEntry)o;
            return !(this.key == null ? cMapEntry.key != null : !this.key.equals(cMapEntry.key)) && !(this.name == null ? cMapEntry.name != null : !this.name.equals(cMapEntry.name));
        }

        public int hashCode() {
            int result = this.name != null ? this.name.hashCode() : 0;
            result = 31 * result + (this.key != null ? this.key.hashCode() : 0);
            return result;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("MapEntry");
            sb.append("{key=").append(this.key);
            sb.append(", valid=").append(this.valid);
            sb.append(", hits=").append(this.hits);
            sb.append(", version=").append(this.version);
            sb.append(", creationTime=").append(this.creationTime);
            sb.append(", lastUpdateTime=").append(this.lastUpdateTime);
            sb.append(", lastAccessTime=").append(this.lastAccessTime);
            sb.append(", expirationTime=").append(this.expirationTime);
            sb.append(", cost=").append(this.cost);
            sb.append('}');
            return sb.toString();
        }
    }

    class MaxSizePartitionsWidePolicy
    extends MaxSizePerJVMPolicy {
        MaxSizePartitionsWidePolicy(MaxSizeConfig maxSizeConfig) {
            super(maxSizeConfig);
        }

        public int getMaxSize() {
            int maxSize = this.maxSizeConfig.getSize();
            if (maxSize == Integer.MAX_VALUE || maxSize == 0) {
                return Integer.MAX_VALUE;
            }
            if (CMap.this.node.getClusterImpl().getMembers().size() < 2) {
                return maxSize;
            }
            PartitionServiceImpl partitionService = CMap.this.concurrentMapManager.partitionServiceImpl;
            int partitionCount = partitionService.getPartitions().size();
            int ownedPartitionCount = partitionService.getOwnedPartitionCount();
            if (partitionCount < 1 || ownedPartitionCount < 1) {
                return maxSize;
            }
            return maxSize * ownedPartitionCount / partitionCount;
        }
    }

    class MaxSizeClusterWidePolicy
    extends MaxSizePerJVMPolicy {
        MaxSizeClusterWidePolicy(MaxSizeConfig maxSizeConfig) {
            super(maxSizeConfig);
        }

        public int getMaxSize() {
            int maxSize = this.maxSizeConfig.getSize();
            int clusterMemberSize = CMap.this.node.getClusterImpl().getMembers().size();
            int memberCount = clusterMemberSize == 0 ? 1 : clusterMemberSize;
            return maxSize / memberCount;
        }
    }

    class MaxSizeHeapPercentagePolicy
    extends MaxSizePerJVMPolicy {
        final int maxPercentage;

        MaxSizeHeapPercentagePolicy(MaxSizeConfig maxSizeConfig) {
            super(maxSizeConfig);
            this.maxPercentage = maxSizeConfig.getSize();
        }

        public boolean overCapacity() {
            long total = Runtime.getRuntime().maxMemory();
            long cost = CMap.this.totalCostOfRecords;
            int usedPercentage = (int)((float)cost / (float)total * 100.0f);
            return usedPercentage >= this.maxPercentage;
        }
    }

    class MaxSizeHeapPolicy
    extends MaxSizePerJVMPolicy {
        final long memoryLimit;

        MaxSizeHeapPolicy(MaxSizeConfig maxSizeConfig) {
            super(maxSizeConfig);
            this.memoryLimit = (long)maxSizeConfig.getSize() * 1024L * 1024L;
        }

        public boolean overCapacity() {
            return CMap.this.totalCostOfRecords >= this.memoryLimit;
        }
    }

    class MaxSizePerJVMPolicy
    implements MapMaxSizePolicy {
        protected final MaxSizeConfig maxSizeConfig;

        MaxSizePerJVMPolicy(MaxSizeConfig maxSizeConfig) {
            this.maxSizeConfig = maxSizeConfig;
        }

        public int getMaxSize() {
            return this.maxSizeConfig.getSize();
        }

        public boolean overCapacity() {
            return this.getMaxSize() <= CMap.this.mapIndexService.size();
        }

        public MaxSizeConfig getMaxSizeConfig() {
            return this.maxSizeConfig;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ComparatorWrapper
    implements Comparator<MapEntry> {
        final Comparator<MapEntry> comparator;

        ComparatorWrapper(Comparator<MapEntry> comparator) {
            this.comparator = comparator;
        }

        @Override
        public int compare(MapEntry o1, MapEntry o2) {
            int result = this.comparator.compare(o1, o2);
            if (result == 0) {
                Record r1 = (Record)o1;
                Record r2 = (Record)o2;
                return r1.getId() > r2.getId() ? 1 : -1;
            }
            return result;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum InitializationState {
        NONE,
        INITIALIZING,
        INITIALIZED;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum EvictionPolicy {
        LRU,
        LFU,
        NONE;

    }
}

