/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.impl.management;

import com.hazelcast.impl.management.ConsoleCommandHandler;
import com.hazelcast.impl.management.ConsoleRequest;
import com.hazelcast.impl.management.ManagementCenterService;
import com.hazelcast.nio.IOUtil;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class ConsoleCommandRequest
implements ConsoleRequest {
    private String command;

    public ConsoleCommandRequest() {
    }

    public ConsoleCommandRequest(String command) {
        this.command = command;
    }

    @Override
    public int getType() {
        return 5;
    }

    @Override
    public void writeResponse(ManagementCenterService mcs, DataOutput dos) throws Exception {
        ConsoleCommandHandler handler = mcs.getCommandHandler();
        try {
            String output = handler.handleCommand(this.command);
            IOUtil.writeLongString(dos, output);
        }
        catch (Throwable e) {
            IOUtil.writeLongString(dos, "Error: " + e.getClass().getSimpleName() + "[" + e.getMessage() + "]");
        }
    }

    @Override
    public Object readResponse(DataInput in) throws IOException {
        return IOUtil.readLongString(in);
    }

    @Override
    public void writeData(DataOutput out) throws IOException {
        out.writeUTF(this.command);
    }

    @Override
    public void readData(DataInput in) throws IOException {
        this.command = in.readUTF();
    }
}

